/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.parser.ast.ComponentDeclaration;
import org.apache.uima.ruta.ide.parser.ast.ComponentReference;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

public class ReferenceFinder
extends ASTVisitor {
    private List<ASTNode> result = new ArrayList<ASTNode>();
    private ASTNode node;

    public ReferenceFinder(ASTNode node) {
        this.node = this.getRealNode(node);
    }

    private ASTNode getRealNode(ASTNode node) {
        RutaCondition c;
        ASTNode expression;
        RutaAction a;
        if (node instanceof RutaAction && "Implicit".equals((a = (RutaAction)node).getName()) && !a.getChilds().isEmpty() && (expression = (ASTNode)a.getChilds().get(0)) != null && !expression.getChilds().isEmpty()) {
            return (ASTNode)expression.getChilds().get(0);
        }
        if (node instanceof RutaCondition && "Implicit".equals((c = (RutaCondition)node).getName()) && !c.getChilds().isEmpty() && (expression = (ASTNode)c.getChilds().get(0)) != null && !expression.getChilds().isEmpty()) {
            return (ASTNode)expression.getChilds().get(0);
        }
        return node;
    }

    public boolean visit(Expression s) throws Exception {
        if (s instanceof RutaVariableReference && this.node instanceof RutaVariableReference) {
            RutaVariableReference vr0 = (RutaVariableReference)this.node;
            RutaVariableReference vr1 = (RutaVariableReference)s;
            if (this.compare(vr1.getStringRepresentation(), vr0.getStringRepresentation()) && vr1.getType() == vr0.getType()) {
                this.result.add((ASTNode)s);
            }
        } else if (!(s instanceof ComponentDeclaration) || !(this.node instanceof ComponentDeclaration)) {
            if (s instanceof ComponentReference && this.node instanceof ComponentReference) {
                ComponentReference cr1 = (ComponentReference)this.node;
                ComponentReference cr2 = (ComponentReference)s;
                if (this.compare(cr1.getName(), cr2.getName())) {
                    this.result.add((ASTNode)s);
                }
            } else if (s instanceof RutaAction && this.node instanceof RutaAction) {
                RutaAction a1 = (RutaAction)this.node;
                RutaAction a2 = (RutaAction)s;
                if (this.compare(a1.getName(), a2.getName())) {
                    this.result.add((ASTNode)s);
                }
            } else if (s instanceof RutaCondition && this.node instanceof RutaCondition) {
                RutaCondition c1 = (RutaCondition)this.node;
                RutaCondition c2 = (RutaCondition)s;
                if (this.compare(c1.getName(), c2.getName())) {
                    this.result.add((ASTNode)s);
                }
            }
        }
        return super.visit(s);
    }

    private boolean compare(String mention1, String mention2) {
        return StringUtils.equals((CharSequence)this.reduce(mention1), (CharSequence)this.reduce(mention2));
    }

    private String reduce(String mention) {
        if (mention.indexOf(46) > 0 && (mention.endsWith(".type") || mention.endsWith(".coveredText") || mention.endsWith(".ct"))) {
            int lastIndexOf = mention.lastIndexOf(46);
            mention = mention.substring(0, lastIndexOf);
        }
        return mention;
    }

    public List<ASTNode> getResult() {
        return this.result;
    }
}

