/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.AnnotationContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class AbstractVariableDeclaration
extends Statement
implements InvocationSite {
    public int declarationEnd;
    public int declarationSourceEnd;
    public int declarationSourceStart;
    public int hiddenVariableDepth;
    public Expression initialization;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference type;
    public static final int FIELD = 1;
    public static final int INITIALIZER = 2;
    public static final int ENUM_CONSTANT = 3;
    public static final int LOCAL_VARIABLE = 4;
    public static final int PARAMETER = 5;
    public static final int TYPE_PARAMETER = 6;
    public static final int RECORD_COMPONENT = 7;

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    @Override
    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public abstract int getKind();

    @Override
    public InferenceContext18 freshInferenceContext(Scope scope) {
        return null;
    }

    public boolean isArgument() {
        return false;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    @Override
    public StringBuilder printStatement(int indent, StringBuilder output) {
        this.printAsExpression(indent, output);
        switch (this.getKind()) {
            case 3: {
                return output.append(',');
            }
        }
        return output.append(';');
    }

    public StringBuilder printAsExpression(int indent, StringBuilder output) {
        AbstractVariableDeclaration.printIndent(indent, output);
        AbstractVariableDeclaration.printModifiers(this.modifiers, output);
        if (this.annotations != null) {
            AbstractVariableDeclaration.printAnnotations(this.annotations, output);
            output.append(' ');
        }
        if (this.type != null) {
            this.type.print(0, output).append(' ');
        }
        output.append(this.name);
        switch (this.getKind()) {
            case 3: {
                if (this.initialization == null) break;
                this.initialization.printExpression(indent, output);
                break;
            }
            default: {
                if (this.initialization == null) break;
                output.append(" = ");
                this.initialization.printExpression(indent, output);
            }
        }
        return output;
    }

    @Override
    public void resolve(BlockScope scope) {
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
        this.hiddenVariableDepth = depth;
    }

    @Override
    public void setFieldIndex(int depth) {
    }

    public boolean isUnnamed(Scope scope) {
        return this.name.length == 1 && this.name[0] == '_' && JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(scope.compilerOptions().sourceLevel, scope.compilerOptions().enablePreviewFeatures);
    }

    public boolean isVarTyped(Scope scope) {
        return this.type != null && this.type.isTypeNameVar(scope);
    }

    public void getAllAnnotationContexts(int targetType, List<AnnotationContext> allAnnotationContexts) {
    }

    public void getAllAnnotationContexts(int targetType, int parameterIndex, List<AnnotationContext> allAnnotationContexts) {
    }

    public void getAllAnnotationContexts(int targetType, LocalVariableBinding localVariable, List<AnnotationContext> allTypeAnnotationContexts) {
    }

    public abstract Binding getBinding();

    public abstract void setBinding(Binding var1);
}

