/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.TranslateVisitor;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class GroovyTranslateVisitor
extends TranslateVisitor {
    private static final String vertexClassName = ReferenceVertex.class.getSimpleName();

    public GroovyTranslateVisitor() {
        this("g");
    }

    public GroovyTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        String integerLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = integerLiteral.length() - 1;
        char lastCharacter = integerLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'b': {
                this.sb.append("new Byte(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 's': {
                this.sb.append("new Short(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 'n': {
                this.sb.append(integerLiteral, 0, lastCharIndex).append("g");
                break;
            }
            default: {
                this.sb.append(integerLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        if (ctx.infLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return (Void)this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastCharacter = floatLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'd': 
            case 'f': {
                this.sb.append(floatLiteral, 0, lastCharIndex).append(lastCharacter);
                break;
            }
            case 'm': {
                this.sb.append(floatLiteral, 0, lastCharIndex).append("g");
                break;
            }
            default: {
                this.sb.append(floatLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral() != null && ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Double.NEGATIVE_INFINITY");
        } else {
            this.sb.append("Double.POSITIVE_INFINITY");
        }
        return null;
    }

    @Override
    public Void visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        if (ctx.getParent() instanceof GremlinParser.GenericMapNullableArgumentContext) {
            this.sb.append("null as Map");
            return null;
        }
        this.sb.append(ctx.getText());
        return null;
    }

    public Void visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        this.sb.append("[");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.visit((ParseTree)genericLiteralContext);
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(", ");
        }
        this.sb.append("] as Set");
        return null;
    }

    public Void visitStringLiteral(GremlinParser.StringLiteralContext ctx) {
        String literal = ctx.getText();
        literal = literal.replace("$", "\\$");
        this.sb.append(literal);
        return null;
    }

    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText());
        } else {
            if (!ctx.getChild(0).getText().equals("new")) {
                this.sb.append("new ");
            }
            this.visitChildren((RuleNode)ctx);
        }
        return null;
    }

    public Void visitTraversalSourceSpawnMethod_inject(GremlinParser.TraversalSourceSpawnMethod_injectContext ctx) {
        return this.handleInject((ParserRuleContext)ctx);
    }

    public Void visitTraversalMethod_inject(GremlinParser.TraversalMethod_injectContext ctx) {
        return this.handleInject((ParserRuleContext)ctx);
    }

    public Void visitTraversalMethod_hasLabel_String_String(GremlinParser.TraversalMethod_hasLabel_String_StringContext ctx) {
        if (ctx.getChildCount() > 4 && ctx.getChild(2).getText().equals("null")) {
            GremlinParser.StringNullableArgumentVarargsContext varArgs = (GremlinParser.StringNullableArgumentVarargsContext)ctx.getChild(4);
            this.sb.append(ctx.getChild(0).getText());
            this.sb.append("((String) null, ");
            for (int i = 0; i < varArgs.getChildCount(); i += 2) {
                if (varArgs.getChild(i).getText().equals("null")) {
                    this.sb.append("(String) null");
                } else {
                    this.visit(varArgs.getChild(i));
                }
                if (i >= varArgs.getChildCount() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append(")");
            return null;
        }
        return (Void)this.visitChildren((RuleNode)ctx);
    }

    private Void handleInject(ParserRuleContext ctx) {
        GremlinParser.GenericLiteralVarargsContext varArgs;
        if (ctx.getChildCount() > 3 && ctx.getChild(2) instanceof GremlinParser.GenericLiteralVarargsContext && (varArgs = (GremlinParser.GenericLiteralVarargsContext)ctx.getChild(2)).getChildCount() > 2 && "null".equals(varArgs.getChild(2).getText())) {
            this.sb.append(ctx.getChild(0).getText());
            this.sb.append("(");
            for (int i = 0; i < varArgs.getChildCount(); i += 2) {
                if (i == 2) {
                    this.sb.append("(Object) null");
                } else {
                    this.visit(varArgs.getChild(i));
                }
                if (i >= varArgs.getChildCount() - 1) continue;
                this.sb.append(", ");
            }
            this.sb.append(")");
            return null;
        }
        return (Void)this.visitChildren((RuleNode)ctx);
    }
}

