/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ShortestPath;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.Serializer;

public final class ShortestPathVertexProgramStep
extends VertexProgramStep
implements TraversalParent,
Configuring {
    private Parameters parameters = new Parameters();
    private PureTraversal<Vertex, ?> targetVertexFilter = ShortestPathVertexProgram.DEFAULT_VERTEX_FILTER_TRAVERSAL.clone();
    private PureTraversal<Vertex, Edge> edgeTraversal = ShortestPathVertexProgram.DEFAULT_EDGE_TRAVERSAL.clone();
    private PureTraversal<Edge, Number> distanceTraversal = ShortestPathVertexProgram.DEFAULT_DISTANCE_TRAVERSAL.clone();
    private Number maxDistance;
    private boolean includeEdges;

    public ShortestPathVertexProgramStep(Traversal.Admin<?, ?> traversal) {
        super(traversal);
    }

    void setTargetVertexFilter(Traversal filterTraversal) {
        this.targetVertexFilter = new PureTraversal(this.integrateChild(filterTraversal.asAdmin()));
    }

    void setEdgeTraversal(Traversal edgeTraversal) {
        this.edgeTraversal = new PureTraversal(this.integrateChild(edgeTraversal.asAdmin()));
    }

    void setDistanceTraversal(Traversal distanceTraversal) {
        this.distanceTraversal = new PureTraversal(this.integrateChild(distanceTraversal.asAdmin()));
    }

    void setMaxDistance(Number maxDistance) {
        this.maxDistance = maxDistance;
    }

    void setIncludeEdges(boolean includeEdges) {
        this.includeEdges = includeEdges;
    }

    @Override
    public void configure(Object ... keyValues) {
        if (!ShortestPath.configure(this, (String)keyValues[0], keyValues[1])) {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    protected Traverser.Admin<ComputerResult> processNextStart() throws NoSuchElementException {
        return super.processNextStart();
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        return Arrays.asList(this.targetVertexFilter.get(), this.edgeTraversal.get(), this.distanceTraversal.get());
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.targetVertexFilter.get(), this.edgeTraversal.get(), this.distanceTraversal.get(), this.maxDistance, this.includeEdges, new GraphFilter(this.computer));
    }

    @Override
    public ShortestPathVertexProgram generateProgram(Graph graph, Memory memory) {
        TraverserSet haltedTraversers;
        Object rootTraversalValue;
        ShortestPathVertexProgram.Builder builder = ShortestPathVertexProgram.build().target(this.targetVertexFilter.getPure()).edgeTraversal(this.edgeTraversal.getPure()).distanceTraversal(this.distanceTraversal.getPure()).maxDistance(this.maxDistance).includeEdges(this.includeEdges);
        PureTraversal pureRootTraversal = new PureTraversal(this.traversal);
        try {
            rootTraversalValue = Base64.getEncoder().encodeToString(Serializer.serializeObject(pureRootTraversal));
        }
        catch (IOException ignored) {
            rootTraversalValue = pureRootTraversal;
        }
        builder.configure("gremlin.vertexProgramStep.rootTraversal", rootTraversalValue, "gremlin.vertexProgramStep.stepId", this.id);
        if (memory.exists("gremlin.traversalVertexProgram.haltedTraversers") && !(haltedTraversers = (TraverserSet)memory.get("gremlin.traversalVertexProgram.haltedTraversers")).isEmpty()) {
            Object haltedTraversersValue;
            try {
                haltedTraversersValue = Base64.getEncoder().encodeToString(Serializer.serializeObject(haltedTraversers));
            }
            catch (IOException ignored) {
                haltedTraversersValue = haltedTraversers;
            }
            builder.configure("gremlin.traversalVertexProgram.haltedTraversers", haltedTraversersValue);
        }
        return (ShortestPathVertexProgram)builder.create(graph);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return TraversalParent.super.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public ShortestPathVertexProgramStep clone() {
        ShortestPathVertexProgramStep clone = (ShortestPathVertexProgramStep)super.clone();
        clone.targetVertexFilter = this.targetVertexFilter.clone();
        clone.edgeTraversal = this.edgeTraversal.clone();
        clone.distanceTraversal = this.distanceTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.targetVertexFilter.get());
        this.integrateChild(this.edgeTraversal.get());
        this.integrateChild(this.distanceTraversal.get());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

