/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToCharPByte
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    public static final int max = 8322945;
    private final char[] _data_c;
    private final byte[] _data_b;

    protected MapToCharPByte(int size) {
        this(65535, size);
    }

    public MapToCharPByte(int unique, int size) {
        super(Math.min(unique, 8322945));
        this._data_c = new char[size];
        this._data_b = new byte[size];
    }

    public MapToCharPByte(int unique, char[] data_c, byte[] data_b) {
        super(unique);
        this._data_c = data_c;
        this._data_b = data_b;
        this.verify();
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR_BYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data_c[n] + (this._data_b[n] << 16);
    }

    @Override
    public void fill(int v) {
        int m = v & 0xFFFFFF;
        Arrays.fill(this._data_c, (char)m);
        Arrays.fill(this._data_b, (byte)(m >> 16));
    }

    @Override
    public long getInMemorySize() {
        return MapToCharPByte.getInMemorySize(this._data_c.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 32L;
        size = (long)((double)size + MemoryEstimates.charArrayCost(dataLength));
        size = (long)((double)size + MemoryEstimates.byteArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data_c.length * 3;
    }

    @Override
    public void set(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
    }

    @Override
    public int setAndGet(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
        return m;
    }

    @Override
    public int size() {
        return this._data_c.length;
    }

    @Override
    public void replace(int v, int r) {
        int m = v & 0xFFFFFF;
        int mr = r & 0xFFFFFF;
        char c = (char)m;
        char cr = (char)mr;
        byte b = (byte)(m >> 16);
        byte br = (byte)(mr >> 16);
        for (int i = 0; i < this._data_c.length; ++i) {
            if (this._data_b[i] != b || this._data_c[i] != c) continue;
            this._data_b[i] = br;
            this._data_c[i] = cr;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        out.writeByte(MapToFactory.MAP_TYPE.CHAR_BYTE.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data_c.length);
        for (i = 0; i < this._data_c.length; ++i) {
            out.writeChar(this._data_c[i]);
        }
        for (i = 0; i < this._data_c.length; ++i) {
            out.writeByte(this._data_b[i]);
        }
    }

    protected static MapToCharPByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data_c = new char[length];
        for (int i = 0; i < length; ++i) {
            data_c[i] = in.readChar();
        }
        byte[] data_b = new byte[length];
        for (int i = 0; i < length; ++i) {
            data_b[i] = in.readByte();
        }
        return new MapToCharPByte(unique, data_c, data_b);
    }

    protected char[] getChars() {
        return this._data_c;
    }

    protected byte[] getBytes() {
        return this._data_b;
    }

    @Override
    public int getUpperBoundValue() {
        return 8322945;
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.set(i, d[i]);
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data_c[i] = '\u0001';
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        for (int i = 0; i < this.size(); ++i) {
            int n = this.getIndex(i);
            ret[n] = ret[n] + 1;
        }
        return ret;
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data_c.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else if (unique < 65534) {
            ret = new MapToChar(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ((AMapToData)ret).copy(this);
        return ret;
    }

    @Override
    public int countRuns() {
        int c = 1;
        char prev = this._data_c[0];
        byte prev_b = this._data_b[0];
        for (int i = 1; i < this._data_c.length; ++i) {
            c += prev == this._data_c[i] && prev_b == this._data_b[i] ? 0 : 1;
            prev = this._data_c[i];
            prev_b = this._data_b[i];
        }
        return c;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToCharPByte(this.getUnique(), Arrays.copyOfRange(this._data_c, l, u), Arrays.copyOfRange(this._data_b, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToCharPByte) {
            MapToCharPByte tb = (MapToCharPByte)t;
            char[] tbb = tb._data_c;
            byte[] tbbb = tb._data_b;
            int newSize = this._data_c.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            char[] ret_c = Arrays.copyOf(this._data_c, newSize);
            System.arraycopy(tbb, 0, ret_c, this._data_c.length, t.size());
            byte[] ret_b = Arrays.copyOf(this._data_b, newSize);
            System.arraycopy(tbbb, 0, ret_b, this._data_b.length, t.size());
            return new MapToCharPByte(newDistinct, ret_c, ret_b);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        char[] ret = new char[p];
        byte[] retb = new byte[p];
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToCharPByte mm = (MapToCharPByte)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data_c, 0, ret, p, ms);
            System.arraycopy(mm._data_b, 0, retb, p, ms);
            p += ms;
        }
        return new MapToCharPByte(this.getUnique(), ret, retb);
    }

    @Override
    public int getMaxPossible() {
        return 0xFFFF00;
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToCharPByte && e.getUnique() == this.getUnique() && Arrays.equals(((MapToCharPByte)e)._data_b, this._data_b) && Arrays.equals(((MapToCharPByte)e)._data_c, this._data_c);
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }
}

