/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.io.BinaryBlockSerialization;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.MatrixReaderFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.OrderedJSONObject;

public class HDFSTool {
    private static final int MAX_DELETE_RETRIES = 10;
    public static final String DFS_REPLICATION = "dfs.replication";
    public static final String IO_FILE_BUFFER_SIZE = "io.file.buffer.size";
    public static final String IO_SERIALIZATIONS = "io.serializations";
    public static final String DFS_BLOCKSIZE = "dfs.blocksize";
    public static final String DFS_PERMISSIONS_ENABLED = "dfs.permissions.enabled";
    public static final String FS_DEFAULTFS = "fs.defaultFS";
    public static final boolean USE_BINARYBLOCK_SERIALIZATION = true;
    private static final Log LOG = LogFactory.getLog((String)HDFSTool.class.getName());

    public static void addBinaryBlockSerializationFramework(Configuration job) {
        String frameworkList = job.get(IO_SERIALIZATIONS);
        String frameworkClassBB = BinaryBlockSerialization.class.getCanonicalName();
        job.set(IO_SERIALIZATIONS, frameworkClassBB + "," + frameworkList);
    }

    public static boolean existsFileOnHDFS(String fname) {
        if (fname == null || fname.isEmpty() || fname.trim().isEmpty()) {
            return false;
        }
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).exists(path);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed check existsFileOnHDFS.", (Throwable)ex);
            return false;
        }
    }

    public static boolean isDirectory(String fname) {
        if (fname == null || fname.isEmpty() || fname.trim().isEmpty()) {
            return false;
        }
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).getFileStatus(path).isDirectory();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Failed to check if file is directory", ex);
        }
    }

    public static FileStatus[] getDirectoryListing(String fname) {
        try {
            Path path = new Path(fname);
            return IOUtilFunctions.getFileSystem(path).listStatus(path);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed listing of directory contents.", (Throwable)ex);
            return new FileStatus[0];
        }
    }

    public static void deleteFileWithMTDIfExistOnHDFS(String fname) throws IOException {
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname + ".mtd");
    }

    public static void deleteFileIfExistOnHDFS(String dir) throws IOException {
        Path path = new Path(dir);
        HDFSTool.deleteFileIfExists(IOUtilFunctions.getFileSystem(path), path);
    }

    public static void deleteFileIfExistOnHDFS(Path outpath, JobConf job) throws IOException {
        HDFSTool.deleteFileIfExists(IOUtilFunctions.getFileSystem(outpath, (Configuration)job), outpath);
    }

    public static void deleteFileIfExistOnLFS(Path outpath, JobConf job) throws IOException {
        HDFSTool.deleteFileIfExists((FileSystem)FileSystem.getLocal((Configuration)job), outpath);
    }

    private static void deleteFileIfExists(FileSystem fs, Path outpath) throws IOException {
        if (fs.exists(outpath)) {
            for (int retries = 10; !fs.delete(outpath, true) && retries > 0; --retries) {
            }
        }
    }

    public static boolean isHDFSFileEmpty(String dir) throws IOException {
        if (dir == null || dir.isEmpty() || dir.trim().isEmpty()) {
            return false;
        }
        Path path = new Path(dir);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        return HDFSTool.isFileEmpty(fs, path);
    }

    public static boolean isFileEmpty(FileSystem fs, Path dir) throws IOException {
        FileStatus fstat = fs.getFileStatus(dir);
        if (fstat.isDirectory() || IOUtilFunctions.isObjectStoreFileScheme(dir)) {
            FileStatus[] stats = fs.listStatus(dir);
            if (stats != null) {
                for (FileStatus stat : stats) {
                    if (stat.getLen() <= 0L) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return fstat.getLen() == 0L;
    }

    public static void renameFileOnHDFS(String originalDir, String newDir) throws IOException {
        Path pathOrig = new Path(originalDir);
        Path pathNew = new Path(newDir);
        if (!IOUtilFunctions.isSameFileScheme(pathOrig, pathNew)) {
            throw new IOException("Cannot rename files to different target file system.");
        }
        HDFSTool.deleteFileIfExistOnHDFS(newDir);
        FileSystem fs = IOUtilFunctions.getFileSystem(pathOrig);
        if (!fs.exists(pathOrig)) {
            throw new FileNotFoundException(originalDir);
        }
        fs.rename(pathOrig, pathNew);
    }

    public static void mergeIntoSingleFile(String originalDir, String newFile) throws IOException {
        Path pathOrig = new Path(originalDir);
        Path pathNew = new Path(newFile);
        if (!IOUtilFunctions.isSameFileScheme(pathOrig, pathNew)) {
            throw new IOException("Cannot merge files into different target file system.");
        }
        FileSystem fs = IOUtilFunctions.getFileSystem(pathOrig);
        HDFSTool.copyMerge(fs, pathOrig, fs, pathNew, true, (Configuration)ConfigurationManager.getCachedJobConf(), null);
    }

    public static void copyFileOnHDFS(String originalDir, String newDir) throws IOException {
        Path originalPath = new Path(originalDir);
        Path newPath = new Path(newDir);
        boolean deleteSource = false;
        boolean overwrite = true;
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        FileSystem fs = IOUtilFunctions.getFileSystem(originalPath, (Configuration)job);
        if (fs.exists(originalPath)) {
            FileUtil.copy((FileSystem)fs, (Path)originalPath, (FileSystem)fs, (Path)newPath, (boolean)deleteSource, (boolean)overwrite, (Configuration)job);
        }
    }

    public static long estimateNnzBasedOnFileSize(Path path, long rlen, long clen, int blen, double factor) throws IOException {
        return (long)Math.min((double)(rlen * clen), (double)(rlen * clen) * ((double)HDFSTool.getFilesizeOnHDFS(path) / factor / (double)OptimizerUtils.estimatePartitionedSizeExactSparsity(rlen, clen, (long)blen, 1.0)));
    }

    public static long getFilesizeOnHDFS(Path path) throws IOException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        long ret = 0L;
        ret = fs.getFileStatus(path).isDirectory() ? fs.getContentSummary(path).getLength() : fs.getFileStatus(path).getLen();
        return ret;
    }

    private static BufferedReader setupInputFile(String filename) throws IOException {
        Path path = new Path(filename);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        return br;
    }

    public static double readDoubleFromHDFSFile(String filename) throws IOException {
        return (Double)HDFSTool.readObjectFromHDFSFile(filename, Types.ValueType.FP64);
    }

    public static long readIntegerFromHDFSFile(String filename) throws IOException {
        return (Long)HDFSTool.readObjectFromHDFSFile(filename, Types.ValueType.INT64);
    }

    public static boolean readBooleanFromHDFSFile(String filename) throws IOException {
        return (Boolean)HDFSTool.readObjectFromHDFSFile(filename, Types.ValueType.BOOLEAN);
    }

    public static String readStringFromHDFSFile(String filename) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = HDFSTool.setupInputFile(filename);){
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static Object readObjectFromHDFSFile(String filename, Types.ValueType vt) throws IOException {
        String line = null;
        try (BufferedReader br = HDFSTool.setupInputFile(filename);){
            line = br.readLine();
        }
        if (line == null) {
            throw new IOException("Empty file on hdfs: " + filename);
        }
        switch (vt) {
            case BOOLEAN: {
                return Boolean.parseBoolean(line);
            }
            case FP64: {
                return Double.parseDouble(line);
            }
            case INT64: {
                return Long.parseLong(line);
            }
        }
        return line;
    }

    public static ScalarObject readScalarObjectFromHDFSFile(String fname, Types.ValueType vt) {
        try {
            Object obj = null;
            switch (vt) {
                case INT64: {
                    obj = HDFSTool.readIntegerFromHDFSFile(fname);
                    break;
                }
                case FP64: {
                    obj = HDFSTool.readDoubleFromHDFSFile(fname);
                    break;
                }
                case BOOLEAN: {
                    obj = HDFSTool.readBooleanFromHDFSFile(fname);
                    break;
                }
                default: {
                    obj = HDFSTool.readStringFromHDFSFile(fname);
                }
            }
            return ScalarObjectFactory.createScalarObject(vt, obj);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private static BufferedWriter setupOutputFile(String filename) throws IOException {
        Path path = new Path(filename);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        return br;
    }

    public static void writeScalarToHDFS(ScalarObject scalar, String fname) {
        try {
            HDFSTool.writeObjectToHDFS(scalar.getValue(), fname);
            HDFSTool.writeScalarMetaDataFile(fname + ".mtd", scalar.getValueType(), scalar.getPrivacyConstraint());
            FileSystem fs = IOUtilFunctions.getFileSystem(fname);
            if (fs instanceof LocalFileSystem) {
                Path path = new Path(fname);
                IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public static void writeDoubleToHDFS(double d, String filename) throws IOException {
        HDFSTool.writeObjectToHDFS(d, filename);
    }

    public static void writeIntToHDFS(long i, String filename) throws IOException {
        HDFSTool.writeObjectToHDFS(i, filename);
    }

    public static void writeBooleanToHDFS(boolean b, String filename) throws IOException {
        HDFSTool.writeObjectToHDFS(b, filename);
    }

    public static void writeStringToHDFS(String s, String filename) throws IOException {
        HDFSTool.writeObjectToHDFS(s, filename);
    }

    public static void writeObjectToHDFS(Object obj, String filename) throws IOException {
        try (BufferedWriter br = HDFSTool.setupOutputFile(filename);){
            br.write(obj.toString());
        }
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, DataCharacteristics mc, Types.FileFormat fmt) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, null, Types.DataType.MATRIX, mc, fmt);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, DataCharacteristics mc, Types.FileFormat fmt, PrivacyConstraint privacyConstraint) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, null, Types.DataType.MATRIX, mc, fmt, null, privacyConstraint);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, Types.ValueType[] schema, Types.DataType dt, DataCharacteristics mc, Types.FileFormat fmt) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, schema, dt, mc, fmt, (PrivacyConstraint)null);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, Types.ValueType[] schema, Types.DataType dt, DataCharacteristics mc, Types.FileFormat fmt, PrivacyConstraint privacyConstraint) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, schema, dt, mc, fmt, null, privacyConstraint);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, DataCharacteristics dc, Types.FileFormat fmt, FileFormatProperties formatProperties) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, null, Types.DataType.MATRIX, dc, fmt, formatProperties);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, DataCharacteristics dc, Types.FileFormat fmt, FileFormatProperties formatProperties, PrivacyConstraint privacyConstraint) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, null, Types.DataType.MATRIX, dc, fmt, formatProperties, privacyConstraint);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, Types.ValueType[] schema, Types.DataType dt, DataCharacteristics dc, Types.FileFormat fmt, FileFormatProperties formatProperties) throws IOException {
        HDFSTool.writeMetaDataFile(mtdfile, vt, schema, dt, dc, fmt, formatProperties, null);
    }

    public static void writeMetaDataFile(String mtdfile, Types.ValueType vt, Types.ValueType[] schema, Types.DataType dt, DataCharacteristics dc, Types.FileFormat fmt, FileFormatProperties formatProperties, PrivacyConstraint privacyConstraint) throws IOException {
        Path path = new Path(mtdfile);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            String mtd = HDFSTool.metaDataToString(vt, schema, dt, dc, fmt, formatProperties, privacyConstraint);
            br.write(mtd);
        }
        catch (Exception e) {
            throw new IOException("Error creating and writing metadata JSON file", e);
        }
    }

    public static void writeScalarMetaDataFile(String mtdfile, Types.ValueType vt) throws IOException {
        HDFSTool.writeScalarMetaDataFile(mtdfile, vt, null);
    }

    public static void writeScalarMetaDataFile(String mtdfile, Types.ValueType vt, PrivacyConstraint privacyConstraint) throws IOException {
        Path path = new Path(mtdfile);
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            String mtd = HDFSTool.metaDataToString(vt, null, Types.DataType.SCALAR, null, Types.FileFormat.TEXT, null, privacyConstraint);
            br.write(mtd);
        }
        catch (Exception e) {
            throw new IOException("Error creating and writing metadata JSON file", e);
        }
    }

    public static String metaDataToString(Types.ValueType vt, Types.ValueType[] schema, Types.DataType dt, DataCharacteristics dc, Types.FileFormat fmt, FileFormatProperties formatProperties, PrivacyConstraint privacyConstraint) throws JSONException, DMLRuntimeException {
        String userName;
        String description;
        OrderedJSONObject mtd = new OrderedJSONObject();
        mtd.put("data_type", (Object)dt.toString().toLowerCase());
        if (schema == null) {
            mtd.put("value_type", (Object)vt.toExternalString().toLowerCase());
        } else {
            StringBuffer schemaSB = new StringBuffer();
            for (int i = 0; i < schema.length; ++i) {
                if (schema[i] == Types.ValueType.UNKNOWN) {
                    schemaSB.append("*");
                } else {
                    schemaSB.append(schema[i].toString());
                }
                schemaSB.append(",");
            }
            mtd.put("schema", (Object)schemaSB.toString());
        }
        if (!dt.isScalar()) {
            mtd.put("rows", dc.getRows());
            mtd.put("cols", dc.getCols());
            if (dt.isMatrix()) {
                if (fmt == Types.FileFormat.BINARY) {
                    mtd.put("rows_in_block", dc.getBlocksize());
                    mtd.put("cols_in_block", dc.getBlocksize());
                }
                mtd.put("nnz", dc.getNonZeros());
            }
        }
        mtd.put("format", (Object)fmt.toString());
        if (formatProperties != null && StringUtils.isNotEmpty((String)(description = formatProperties.getDescription()))) {
            String jsonDescription = StringEscapeUtils.escapeJson((String)description);
            mtd.put("description", (Object)jsonDescription);
        }
        if (StringUtils.isNotEmpty((String)(userName = System.getProperty("user.name")))) {
            mtd.put("author", (Object)userName);
        } else {
            mtd.put("author", (Object)"SystemDS");
        }
        if (formatProperties instanceof FileFormatPropertiesCSV) {
            FileFormatPropertiesCSV csvProps = (FileFormatPropertiesCSV)formatProperties;
            mtd.put("header", csvProps.hasHeader());
            mtd.put("sep", (Object)csvProps.getDelim());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        mtd.put("created", (Object)sdf.format(new Date()));
        if (privacyConstraint != null) {
            privacyConstraint.toJson(mtd);
        }
        return mtd.toString(4);
    }

    public static double[][] readMatrixFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        MatrixReader reader = MatrixReaderFactory.createMatrixReader(fmt);
        long estnnz = rlen <= 0L || clen <= 0L ? -1L : rlen * clen;
        MatrixBlock mb = reader.readMatrixFromHDFS(dir, rlen, clen, blen, estnnz);
        return DataConverter.convertToDoubleMatrix(mb);
    }

    public static double[] readColumnVectorFromHDFS(String dir, Types.FileFormat fmt, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        MatrixReader reader = MatrixReaderFactory.createMatrixReader(fmt);
        long estnnz = rlen <= 0L || clen <= 0L ? -1L : rlen * clen;
        MatrixBlock mb = reader.readMatrixFromHDFS(dir, rlen, clen, blen, estnnz);
        return DataConverter.convertToDoubleVector(mb, false);
    }

    public static void createDirIfNotExistOnHDFS(String dir, String permissions) throws IOException {
        HDFSTool.createDirIfNotExistOnHDFS(new Path(dir), permissions);
    }

    public static void createDirIfNotExistOnHDFS(Path path, String permissions) throws IOException {
        try {
            FileSystem fs = IOUtilFunctions.getFileSystem(path);
            if (!fs.exists(path)) {
                char[] c = permissions.toCharArray();
                short sU = (short)((c[0] - 48) * 64);
                short sG = (short)((c[1] - 48) * 8);
                short sO = (short)(c[2] - 48);
                short mode = (short)(sU + sG + sO);
                FsPermission perm = new FsPermission(mode);
                fs.mkdirs(path, perm);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed in creating a non existing dir on HDFS", ex);
        }
    }

    public static FSDataOutputStream getHDFSDataOutputStream(String filename, boolean overwrite) throws IOException {
        Path path = new Path(filename);
        return IOUtilFunctions.getFileSystem(path).create(path, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, boolean deleteSource, Configuration conf, String addString) throws IOException {
        dstFile = HDFSTool.checkDest(srcDir.getName(), dstFS, dstFile, false);
        if (!srcFS.getFileStatus(srcDir).isDirectory()) {
            return false;
        }
        try (FSDataOutputStream out = dstFS.create(dstFile);){
            Object[] contents = srcFS.listStatus(srcDir);
            Arrays.sort(contents);
            for (int i = 0; i < contents.length; ++i) {
                if (!contents[i].isFile()) continue;
                try (FSDataInputStream in = srcFS.open(contents[i].getPath());){
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                    if (addString == null) continue;
                    out.write(addString.getBytes("UTF-8"));
                    continue;
                }
            }
        }
        if (deleteSource) {
            return srcFS.delete(srcDir, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return HDFSTool.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }
}

