/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupRLE
extends AColGroupOffset {
    private static final long serialVersionUID = -1560710477952862791L;

    protected ColGroupRLE(int numRows) {
        super(numRows);
    }

    protected ColGroupRLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs, int[] cachedCounts) {
        super(colIndices, numRows, zeros, dict, cachedCounts);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.RLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.RLE;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock target, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock target, int rl, int ru, int offR, int offC, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int count = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                count += this._data[boff + bix + 1];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows - sum;
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupRLE(this._colIndexes, this._numRows, this._zeros, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, false, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        throw new NotImplementedException("Not implemented because dictionaries no longer should support extending by a tuple Ideally implement a modification such that RLE becomes SDC group when materializing Zero tuples");
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    public boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                Arrays.fill(ret, curRunStartOff, curRunEnd, false);
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] astart = new int[numVals];
        int[] apos = this.skipScan(numVals, rl, astart);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = apos[k]; bix < blen && curRunStartOff < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int i = Math.max(curRunStartOff, rl); i < Math.min(curRunEnd, ru); ++i) {
                    int n = i - rl;
                    rnnz[n] = rnnz[n] + numCols;
                }
            }
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        int numVals = this.getNumValues();
        for (int k = 0; k < numVals; ++k) {
            char llen;
            char lstart;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = 0;
            for (int start = 0; bix < blen && start <= r; start += lstart + llen, bix += 2) {
                lstart = this._data[boff + bix];
                llen = this._data[boff + bix + 1];
                int from = start + lstart;
                int to = start + lstart + llen;
                if (r < from || r >= to) continue;
                return this._dict.getValue(k * this._colIndexes.length + colIdx);
            }
        }
        return 0.0;
    }

    private int[] skipScan(int numVals, int rl, int[] astart) {
        int[] apos = new int[numVals];
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                    start += lstart + llen;
                }
                apos[k] = bix;
                astart[k] = start;
            }
        }
        return apos;
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    public void tsmmAColGroup(AColGroup other, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d", "Data:", this._data.length));
        sb.append("{");
        sb.append(this._data[0] + "-" + this._data[1]);
        for (int i = 2; i < this._data.length; i += 2) {
            sb.append(", " + this._data[i] + "-" + this._data[i + 1]);
        }
        sb.append("}");
        return sb.toString();
    }

    public static char[] genRLEBitmap(int[] offsets, int len) {
        ArrayList<Character> buf = new ArrayList<Character>();
        int lastRunEnd = 0;
        int curRunLen = 0;
        int firstOff = offsets[0];
        while (firstOff > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            firstOff -= 65535;
            lastRunEnd += 65535;
        }
        int curRunOff = firstOff;
        curRunLen = 1;
        for (int i = 1; i < len; ++i) {
            int absOffset = offsets[i];
            int curRunEnd = lastRunEnd + curRunOff + curRunLen;
            if (absOffset > curRunEnd || curRunLen >= 65535) {
                buf.add(Character.valueOf((char)curRunOff));
                buf.add(Character.valueOf((char)curRunLen));
                lastRunEnd = curRunEnd;
                for (curRunOff = absOffset - lastRunEnd; curRunOff > 65535; curRunOff -= 65535) {
                    buf.add(Character.valueOf('\uffff'));
                    buf.add(Character.valueOf('\u0000'));
                    lastRunEnd += 65535;
                }
                curRunLen = 1;
                continue;
            }
            ++curRunLen;
        }
        if (curRunOff + curRunLen > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            curRunOff -= 65535;
        }
        buf.add(Character.valueOf((char)curRunOff));
        buf.add(Character.valueOf((char)curRunLen));
        char[] ret = new char[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = ((Character)buf.get(i)).charValue();
        }
        return ret;
    }
}

