/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class QuantileSortFEDInstruction
extends UnaryFEDInstruction {
    int _numThreads;

    private QuantileSortFEDInstruction(CPOperand in, CPOperand out, String opcode, String istr, int k) {
        this(in, null, out, opcode, istr, k);
    }

    private QuantileSortFEDInstruction(CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr, int k) {
        super(FEDInstruction.FEDType.QSort, null, in1, in2, out, opcode, istr);
        this._numThreads = k;
    }

    private static void parseInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        out.split(parts[parts.length - 2]);
        switch (parts.length) {
            case 4: {
                in1.split(parts[1]);
                in2 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuantileSortFEDInstruction parseInstruction(String str, boolean hasFedOut) {
        QuantileSortFEDInstruction inst;
        int twoInputLength;
        FEDInstruction.FederatedOutput fedOut;
        int k;
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        boolean isSpark = str.startsWith("SPARK");
        if (hasFedOut) {
            k = isSpark ? 1 : Integer.parseInt(parts[parts.length - 2]);
            fedOut = FEDInstruction.FederatedOutput.valueOf(parts[parts.length - 1]);
        } else {
            k = isSpark ? 1 : Integer.parseInt(parts[parts.length - 1]);
            fedOut = FEDInstruction.FederatedOutput.NONE;
        }
        if (!opcode.equalsIgnoreCase("qsort")) throw new DMLRuntimeException("Unknown opcode while parsing a QuantileSortFEDInstruction: " + str);
        int oneInputLength = isSpark ? 3 : 4;
        int n = twoInputLength = isSpark ? 4 : 5;
        if (parts.length == oneInputLength) {
            QuantileSortFEDInstruction.parseUnaryInstruction(str, in1, out);
            inst = new QuantileSortFEDInstruction(in1, out, opcode, str, k);
        } else {
            if (parts.length != twoInputLength) throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
            in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            InstructionUtils.checkNumFields(str, twoInputLength - 1);
            QuantileSortFEDInstruction.parseInstruction(str, in1, in2, out);
            inst = new QuantileSortFEDInstruction(in1, in2, out, opcode, str, k);
        }
        inst._fedOut = fedOut;
        return inst;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (ec.getMatrixObject(this.input1).isFederated(FTypes.FType.COL) || ec.getMatrixObject(this.input1).isFederated(FTypes.FType.FULL)) {
            this.processColumnQSort(ec);
        } else {
            this.processRowQSort(ec);
        }
    }

    public void processRowQSort(ExecutionContext ec) {
        MatrixObject in = ec.getMatrixObject(this.input1);
        MatrixObject out = ec.getMatrixObject(this.output);
        if (this.input2 != null) {
            MatrixLineagePair weights = ec.getMatrixLineagePair(this.input2);
            String newInst = this._numThreads > 1 ? InstructionUtils.stripThreadCount(this.instString) : this.instString;
            newInst = InstructionUtils.replaceOperand(newInst, 1, "append");
            newInst = InstructionUtils.concatOperands(newInst, "true");
            FederatedRequest[] fr1 = in.getFedMapping().broadcastSliced(weights, false);
            FederatedRequest fr2 = FederationUtils.callInstruction(newInst, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{in.getFedMapping().getID(), fr1[0].getID()});
            in.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
            out.getDataCharacteristics().set(in.getDataCharacteristics());
            out.getDataCharacteristics().setCols(2L);
            out.setFedMapping(in.getFedMapping().copyWithNewID(fr2.getID(), 2L));
        } else {
            long id = FederationUtils.getNextFedDataID();
            out.getDataCharacteristics().set(in.getDataCharacteristics());
            out.setFedMapping(in.getFedMapping().identCopy(this.getTID(), id));
        }
    }

    public void processColumnQSort(ExecutionContext ec) {
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap fedMapping = in.getFedMapping();
        long varID = FederationUtils.getNextFedDataID();
        FederationMap sortedMapping = fedMapping.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response;
                MatrixBlock wtBlock = null;
                if (this.input2 != null) {
                    wtBlock = ec.getMatrixInput(this.input2.getName());
                }
                if (!(response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetSorted(data.getVarID(), varID, wtBlock, this._numThreads))).get()).isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        MatrixObject sorted = ec.getMatrixObject(this.output);
        sorted.getDataCharacteristics().set(in.getDataCharacteristics());
        sorted.setFedMapping(sortedMapping);
    }

    private static class GetSorted
    extends FederatedUDF {
        private static final long serialVersionUID = -1969015577260167645L;
        private final long _outputID;
        private final MatrixBlock _weights;
        private final int _numThreads;

        protected GetSorted(long input, long outputID, MatrixBlock weights, int k) {
            super(new long[]{input});
            this._outputID = outputID;
            this._weights = weights;
            this._numThreads = k;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            MatrixBlock res = mb.sortOperations(this._weights, new MatrixBlock(), this._numThreads);
            MatrixObject mout = ExecutionContext.createMatrixObject(res);
            ec.setVariable(String.valueOf(this._outputID), mout);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

