/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import java.io.Closeable;
import java.nio.MappedByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;

@InterfaceAudience.Private
public class ClientMmap
implements Closeable {
    static final Log LOG = LogFactory.getLog(ClientMmap.class);
    private ShortCircuitReplica replica;
    private final MappedByteBuffer map;
    private final boolean anchored;

    ClientMmap(ShortCircuitReplica replica, MappedByteBuffer map, boolean anchored) {
        this.replica = replica;
        this.map = map;
        this.anchored = anchored;
    }

    @Override
    public void close() {
        if (this.replica != null) {
            if (this.anchored) {
                this.replica.removeNoChecksumAnchor();
            }
            this.replica.unref();
        }
        this.replica = null;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.map;
    }
}

