/*
 * Decompiled with CFR 0.152.
 */
package jcuda.driver;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jcuda.driver.CUjit_option;

public final class JITOptions {
    private final Map<Integer, Object> map = new LinkedHashMap<Integer, Object>();

    int[] getKeys() {
        Set<Integer> keySet = this.map.keySet();
        int[] keys = new int[keySet.size()];
        int index = 0;
        for (Integer key : keySet) {
            keys[index] = key;
            ++index;
        }
        return keys;
    }

    public void remove(int key) {
        this.map.remove(key);
    }

    public void put(int key) {
        this.map.put(key, null);
    }

    public void putInt(int key, int value) {
        this.map.put(key, value);
    }

    public void putFloat(int key, float value) {
        this.map.put(key, Float.valueOf(value));
    }

    public void putBytes(int key, byte[] value) {
        this.map.put(key, value);
    }

    public int getInt(int key) {
        Object value = this.map.get(key);
        if (!(value instanceof Integer)) {
            return 0;
        }
        Integer result = (Integer)value;
        return result;
    }

    public float getFloat(int key) {
        Object value = this.map.get(key);
        if (!(value instanceof Float)) {
            return 0.0f;
        }
        Float result = (Float)value;
        return result.floatValue();
    }

    public byte[] getBytes(int key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof byte[])) {
            return null;
        }
        byte[] data = (byte[])value;
        return data;
    }

    public String getString(int key) {
        byte[] data = this.getBytes(key);
        if (data == null) {
            return null;
        }
        return JITOptions.createString(data);
    }

    private static String createString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length && data[i] != 0; ++i) {
            sb.append((char)data[i]);
        }
        String result = sb.toString();
        return result;
    }

    public String toString() {
        return "JITOptions[" + this.createString(",") + "]";
    }

    public String toFormattedString() {
        return "JITOptions:\n    " + this.createString("\n    ");
    }

    private String createString(String f) {
        StringBuffer sb = new StringBuffer();
        int[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            sb.append(CUjit_option.stringFor(key) + "=");
            Object value = this.map.get(key);
            if (value instanceof byte[]) {
                byte[] data = (byte[])value;
                sb.append(JITOptions.createString(data));
            } else {
                sb.append(String.valueOf(value));
            }
            if (i >= keys.length - 1) continue;
            sb.append(f);
        }
        return sb.toString();
    }
}

