/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.FastBufferedDataInputStream;
import org.apache.sysds.runtime.util.FastBufferedDataOutputStream;

public class CorrMatrixBlock
implements Externalizable {
    private static final long serialVersionUID = -2204456681697015083L;
    private MatrixBlock _value = null;
    private MatrixBlock _corr = null;

    public CorrMatrixBlock() {
    }

    public CorrMatrixBlock(MatrixBlock value) {
        this._value = value;
    }

    public CorrMatrixBlock(MatrixBlock value, MatrixBlock corr) {
        this._value = value;
        this._corr = corr;
    }

    public MatrixBlock getValue() {
        return this._value;
    }

    public MatrixBlock getCorrection() {
        return this._corr;
    }

    public CorrMatrixBlock set(MatrixBlock value, MatrixBlock corr) {
        this._value = value;
        this._corr = corr;
        return this;
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        AutoCloseable dis = is;
        if (is instanceof ObjectInputStream) {
            ObjectInputStream ois = (ObjectInputStream)is;
            dis = new FastBufferedDataInputStream(ois);
        }
        this.readHeaderAndPayload((DataInput)((Object)dis));
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream && !this._value.isEmptyBlock(false)) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.writeHeaderAndPayload(fos);
            fos.flush();
        } else {
            this.writeHeaderAndPayload(os);
        }
    }

    private void writeHeaderAndPayload(DataOutput dos) throws IOException {
        boolean writeCorr = this._corr != null && !this._corr.isEmptyBlock(false);
        dos.writeByte(writeCorr ? 1 : 0);
        this._value.write(dos);
        if (writeCorr) {
            this._corr.write(dos);
        }
    }

    private void readHeaderAndPayload(DataInput dis) throws IOException {
        boolean corrExists = dis.readByte() != 0;
        this._value = new MatrixBlock();
        this._value.readFields(dis);
        if (corrExists) {
            this._corr = new MatrixBlock();
            this._corr.readFields(dis);
        }
    }
}

