/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.rpc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheDataOutput;
import org.apache.sysds.runtime.controlprogram.paramserv.rpc.PSRpcObject;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.util.ByteBufferDataInput;

public class PSRpcCall
extends PSRpcObject {
    private int _method;
    private int _workerID;
    private ListObject _data;

    public PSRpcCall(int method, int workerID, ListObject data) {
        this._method = method;
        this._workerID = workerID;
        this._data = data;
    }

    public PSRpcCall(ByteBuffer buffer) throws IOException {
        this.deserialize(buffer);
    }

    public int getMethod() {
        return this._method;
    }

    public int getWorkerID() {
        return this._workerID;
    }

    public ListObject getData() {
        return this._data;
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IOException {
        ByteBufferDataInput dis = new ByteBufferDataInput(buffer);
        this._method = dis.readInt();
        PSRpcCall.validateMethod(this._method);
        this._workerID = dis.readInt();
        if (dis.available() > 1) {
            this._data = this.readAndDeserialize(dis);
        }
    }

    @Override
    public ByteBuffer serialize() throws IOException {
        int len = 8 + this.getExactSerializedSize(this._data);
        CacheDataOutput dos = new CacheDataOutput(len);
        dos.writeInt(this._method);
        dos.writeInt(this._workerID);
        if (this._data != null) {
            this.serializeAndWriteListObject(this._data, dos);
        }
        return ByteBuffer.wrap(dos.getBytes());
    }

    private static void validateMethod(int method) {
        switch (method) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new DMLRuntimeException("PSRpcCall: only support rpc method 'push' or 'pull'");
            }
        }
    }
}

