/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.util.Arrays;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockLDRB;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DenseBlockLFP64
extends DenseBlockLDRB {
    private static final long serialVersionUID = -1723319832162080273L;
    private double[][] _blocks;

    public DenseBlockLFP64(int[] dims) {
        super(dims);
        this.reset(this._rlen, this._odims, 0.0);
    }

    @Override
    protected void allocateBlocks(int numBlocks) {
        this._blocks = new double[numBlocks][];
    }

    @Override
    protected void allocateBlock(int bix, int length) {
        this._blocks[bix] = new double[length];
    }

    @Override
    protected void setInternal(int bix, int ix, double v) {
        this._blocks[bix][ix] = v;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isContiguous() {
        return this._blocks.length == 1;
    }

    @Override
    public int numBlocks() {
        return this._blocks.length;
    }

    @Override
    public long capacity() {
        return this._blocks != null ? (long)(this._blocks.length - 1) * (long)this._blocks[0].length + (long)this._blocks[this._blocks.length - 1].length : -1L;
    }

    @Override
    protected long computeNnz(int bix, int start, int length) {
        return UtilFunctions.computeNnz(this._blocks[bix], start, length);
    }

    @Override
    public double[] values(int r) {
        return this.valuesAt(this.index(r));
    }

    @Override
    public double[] valuesAt(int bix) {
        return this._blocks[bix];
    }

    @Override
    public void incr(int r, int c) {
        this.incr(r, c, 1.0);
    }

    @Override
    public void incr(int r, int c, double delta) {
        double[] dArray = this._blocks[this.index(r)];
        int n = this.pos(r, c);
        dArray[n] = dArray[n] + delta;
    }

    @Override
    protected void fillBlock(int bix, int fromIndex, int toIndex, double v) {
        Arrays.fill(this._blocks[bix], fromIndex, toIndex, v);
    }

    @Override
    public DenseBlock set(int r, int c, double v) {
        this._blocks[this.index((int)r)][this.pos((int)r, (int)c)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, double v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, long v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = v;
        return this;
    }

    @Override
    public DenseBlock set(int[] ix, String v) {
        this._blocks[this.index((int)ix[0])][this.pos((int[])ix)] = Double.parseDouble(v);
        return this;
    }

    @Override
    public double get(int r, int c) {
        return this._blocks[this.index(r)][this.pos(r, c)];
    }

    @Override
    public double get(int[] ix) {
        return this._blocks[this.index(ix[0])][this.pos(ix)];
    }

    @Override
    public String getString(int[] ix) {
        return String.valueOf(this._blocks[this.index(ix[0])][this.pos(ix)]);
    }

    @Override
    public long getLong(int[] ix) {
        return UtilFunctions.toLong(this._blocks[this.index(ix[0])][this.pos(ix)]);
    }
}

