/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LeftIndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.hops.rewrite.ProgramRewriter;
import org.apache.sysds.hops.rewrite.RewriteInjectSparkLoopCheckpointing;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.ParForStatement;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysds.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTree;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.apache.sysds.runtime.controlprogram.parfor.opt.Optimizer;
import org.apache.sysds.runtime.controlprogram.parfor.opt.ProgramRecompiler;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.utils.NativeHelper;

public class OptimizerRuleBased
extends Optimizer {
    private static final Log LOG = LogFactory.getLog((String)OptimizerRuleBased.class.getName());
    public static final double PROB_SIZE_THRESHOLD_REMOTE = 100.0;
    public static final double PROB_SIZE_THRESHOLD_PARTITIONING = 2.0;
    public static final double PROB_SIZE_THRESHOLD_MB = 2.68435456E8;
    public static final int MAX_REPLICATION_FACTOR_PARTITIONING = 5;
    public static final int MAX_REPLICATION_FACTOR_EXPORT = 7;
    public static final boolean ALLOW_REMOTE_NESTED_PARALLELISM = false;
    public static final String FUNCTION_UNFOLD_NAMEPREFIX = "__unfold_";
    public static final double PAR_K_FACTOR = 1.0;
    public static final double PAR_K_MR_FACTOR = 1.0;
    protected long _N = -1L;
    protected long _Nmax = -1L;
    protected int _lk = -1;
    protected int _lkmaxCP = -1;
    protected int _lkmaxMR = -1;
    protected int _rnk = -1;
    protected int _rk = -1;
    protected int _rk2 = -1;
    protected int _rkmax = -1;
    protected int _rkmax2 = -1;
    protected double _lm = -1.0;
    protected double _rm = -1.0;
    protected double _rm2 = -1.0;
    protected CostEstimator _cost = null;

    @Override
    public Optimizer.CostModelType getCostModelType() {
        return Optimizer.CostModelType.STATIC_MEM_METRIC;
    }

    @Override
    public Optimizer.PlanInputType getPlanInputType() {
        return Optimizer.PlanInputType.ABSTRACT_PLAN;
    }

    @Override
    public ParForProgramBlock.POptMode getOptMode() {
        return ParForProgramBlock.POptMode.RULEBASED;
    }

    @Override
    public boolean optimize(ParForStatementBlock sb, ParForProgramBlock pb, OptTree plan, CostEstimator est, ExecutionContext ec) {
        LOG.debug((Object)("--- " + (Object)((Object)this.getOptMode()) + " OPTIMIZER -------"));
        OptNode pn = plan.getRoot();
        if (pn.isLeaf()) {
            return true;
        }
        this.analyzeProblemAndInfrastructure(pn);
        this._cost = est;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: Optimize w/ max_mem=" + OptimizerRuleBased.toMB(this._lm) + "/" + OptimizerRuleBased.toMB(this._rm) + "/" + OptimizerRuleBased.toMB(this._rm2) + ", max_k=" + this._lk + "/" + this._rk + "/" + this._rk2 + ")."));
            if (OptimizerUtils.isSparkExecutionMode()) {
                LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: Optimize w/ " + SparkExecutionContext.getSparkClusterConfig().toString()));
            }
            if (this._rnk <= 0 || this._rk <= 0) {
                LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Optimize for inactive cluster (num_nodes=" + this._rnk + ", num_map_slots=" + this._rk + ")."));
            }
        }
        pn.setSerialParFor();
        double M0a = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated mem (serial exec) M=" + OptimizerRuleBased.toMB(M0a)));
        HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices = new HashMap<String, ParForProgramBlock.PartitionFormat>();
        this.rewriteSetDataPartitioner(pn, ec.getVariables(), partitionedMatrices, OptimizerUtils.getLocalMemBudget(), false);
        double M0b = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        this.rewriteRemoveUnnecessaryCompareMatrix(pn, ec);
        boolean flagLIX = this.rewriteSetResultPartitioning(pn, M0b, ec.getVariables());
        double M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (serial exec) M=" + OptimizerRuleBased.toMB(M1)));
        double M2 = pn.isCPOnly() ? M1 : this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn, LopProperties.ExecType.CP);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (serial exec, all CP) M=" + OptimizerRuleBased.toMB(M2)));
        double M3 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn, true);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: estimated new mem (cond partitioning) M=" + OptimizerRuleBased.toMB(M3)));
        boolean flagRecompMR = this.rewriteSetExecutionStategy(pn, M0a, M1, M2, M3, flagLIX);
        if (pn.getExecType() == this.getRemoteExecType()) {
            if (M1 > this._rm && M3 <= this._rm) {
                this.rewriteSetDataPartitioner(pn, ec.getVariables(), partitionedMatrices, M3, false);
                M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
            }
            if (flagRecompMR) {
                this.rewriteSetOperationsExecType(pn, flagRecompMR);
                M1 = this._cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn);
            }
            this.rewriteDataColocation(pn, ec.getVariables());
            this.rewriteSetPartitionReplicationFactor(pn, partitionedMatrices, ec.getVariables());
            this.rewriteSetExportReplicationFactor(pn, ec.getVariables());
            this.rewriteSetDegreeOfParallelism(pn, this._cost, ec.getVariables(), M1, false);
            this.rewriteSetTaskPartitioner(pn, false, flagLIX);
            this.rewriteSetFusedDataPartitioningExecution(pn, M1, flagLIX, partitionedMatrices, ec.getVariables());
            HashSet<ParForStatementBlock.ResultVar> inplaceResultVars = new HashSet<ParForStatementBlock.ResultVar>();
            this.rewriteSetInPlaceResultIndexing(pn, this._cost, ec.getVariables(), inplaceResultVars, ec);
        } else {
            this.rewriteSetDegreeOfParallelism(pn, this._cost, ec.getVariables(), M1, false);
            this.rewriteSetTaskPartitioner(pn, false, false);
            HashSet<ParForStatementBlock.ResultVar> inplaceResultVars = new HashSet<ParForStatementBlock.ResultVar>();
            this.rewriteSetInPlaceResultIndexing(pn, this._cost, ec.getVariables(), inplaceResultVars, ec);
            this.rewriteInjectSparkLoopCheckpointing(pn);
            this.rewriteInjectSparkRepartition(pn, ec.getVariables());
            this.rewriteSetSparkEagerRDDCaching(pn, ec.getVariables());
        }
        this.rewriteSetResultMerge(pn, ec.getVariables(), true);
        this.rewriteSetRecompileMemoryBudget(pn);
        this.rewriteRemoveRecursiveParFor(pn, ec.getVariables());
        this.rewriteRemoveUnnecessaryParFor(pn);
        this._numTotalPlans = -1L;
        return true;
    }

    protected void analyzeProblemAndInfrastructure(OptNode pn) {
        this._N = Long.parseLong(pn.getParam(OptNode.ParamType.NUM_ITERATIONS));
        this._Nmax = pn.getMaxProblemSize();
        this._lk = InfrastructureAnalyzer.getLocalParallelism();
        this._lkmaxCP = (int)Math.ceil(1.0 * (double)this._lk);
        this._lkmaxMR = (int)Math.ceil(1.0 * (double)this._lk);
        this._lm = OptimizerUtils.getLocalMemBudget();
        if (OptimizerUtils.isSparkExecutionMode()) {
            this._rnk = SparkExecutionContext.getNumExecutors();
            this._rk2 = this._rk = SparkExecutionContext.getDefaultParallelism(true);
            int cores = SparkExecutionContext.getDefaultParallelism(true) / SparkExecutionContext.getNumExecutors();
            int ccores = Math.max((int)Math.min((long)cores, this._N), 1);
            this._rm = SparkExecutionContext.getBroadcastMemoryBudget() / (double)ccores;
            this._rm2 = SparkExecutionContext.getBroadcastMemoryBudget() / (double)ccores;
        } else {
            this._rnk = 1;
            this._rk = InfrastructureAnalyzer.getLocalParallelism();
            this._rk2 = InfrastructureAnalyzer.getLocalParallelism();
            this._rm = InfrastructureAnalyzer.getLocalMaxMemory() / (long)this._rk;
            this._rm2 = InfrastructureAnalyzer.getLocalMaxMemory() / (long)this._rk2;
        }
        this._rkmax = (int)Math.ceil(1.0 * (double)this._rk);
        this._rkmax2 = (int)Math.ceil(1.0 * (double)this._rk2);
    }

    protected OptNode.ExecType getRemoteExecType() {
        return OptNode.ExecType.SPARK;
    }

    protected boolean rewriteSetDataPartitioner(OptNode n, LocalVariableMap vars, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, double thetaM, boolean constrained) {
        if (n.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Data partitioner can only be set for a ParFor node."));
        }
        boolean blockwise = false;
        long id = n.getID();
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
        ParForStatementBlock pfsb = (ParForStatementBlock)o[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)o[1];
        boolean apply = false;
        if (OptimizerUtils.isHybridExecutionMode() && ((double)this._N >= 2.0 || (double)this._Nmax >= 2.0)) {
            HashMap<String, ParForProgramBlock.PartitionFormat> cand2 = new HashMap<String, ParForProgramBlock.PartitionFormat>();
            for (String c : pfsb.getReadOnlyParentMatrixVars()) {
                ParForProgramBlock.PartitionFormat dpf = pfsb.determineDataPartitionFormat(c);
                double mem = this.getMemoryEstimate(c, vars);
                if (dpf == ParForProgramBlock.PartitionFormat.NONE || dpf._dpf == ParForProgramBlock.PDataPartitionFormat.BLOCK_WISE_M_N || !constrained && (!(mem > this._lm / 2.0) || !(mem > this._rm / 2.0)) || vars.get(c) == null || vars.get(c).getDataType().isList()) continue;
                cand2.put(c, dpf);
            }
            apply = this.rFindDataPartitioningCandidates(n, cand2, vars, thetaM);
            if (apply) {
                partitionedMatrices.putAll(cand2);
            }
        }
        ParForProgramBlock.PDataPartitioner REMOTE = ParForProgramBlock.PDataPartitioner.REMOTE_SPARK;
        ParForProgramBlock.PDataPartitioner pdp = apply ? REMOTE : ParForProgramBlock.PDataPartitioner.NONE;
        pfpb.setDataPartitioner(pdp);
        n.addParam(OptNode.ParamType.DATA_PARTITIONER, pdp.toString());
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set data partitioner' - result=" + pdp.toString() + " (" + Arrays.toString(partitionedMatrices.keySet().toArray()) + ")"));
        return blockwise;
    }

    protected boolean rFindDataPartitioningCandidates(OptNode n, HashMap<String, ParForProgramBlock.PartitionFormat> cand, LocalVariableMap vars, double thetaM) {
        Hop h;
        String inMatrix;
        boolean ret = false;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                if (cn.getNodeType() == OptNode.NodeType.FUNCCALL) continue;
                ret |= this.rFindDataPartitioningCandidates(cn, cand, vars, thetaM);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && cand.containsKey(inMatrix = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName()) && h.getDataType().isMatrix()) {
            ParForProgramBlock.PartitionFormat dpf = cand.get(inMatrix);
            double mnew = this.getNewRIXMemoryEstimate(n, inMatrix, dpf, vars);
            if (n.getExecType() == this.getRemoteExecType() || h.getMemEstimate() > thetaM) {
                n.setExecType(OptNode.ExecType.CP);
                n.addParam(OptNode.ParamType.DATA_PARTITION_FORMAT, dpf.toString());
                h.setMemEstimate(mnew);
                ret = true;
            } else {
                n.addParam(OptNode.ParamType.DATA_PARTITION_COND, String.valueOf(true));
                n.addParam(OptNode.ParamType.DATA_PARTITION_COND_MEM, String.valueOf(mnew));
            }
        }
        return ret;
    }

    protected double getNewRIXMemoryEstimate(OptNode n, String varName, ParForProgramBlock.PartitionFormat dpf, LocalVariableMap vars) {
        double mem = -1.0;
        Data dat = vars.get(varName);
        if (dat != null && dat instanceof MatrixObject) {
            MatrixObject mo = (MatrixObject)dat;
            switch (dpf._dpf) {
                case COLUMN_WISE: {
                    mem = OptimizerUtils.estimateSize(mo.getNumRows(), 1L);
                    break;
                }
                case ROW_WISE: {
                    mem = OptimizerUtils.estimateSize(1L, mo.getNumColumns());
                    break;
                }
                case COLUMN_BLOCK_WISE_N: {
                    mem = OptimizerUtils.estimateSize(mo.getNumRows(), dpf._N);
                    break;
                }
                case ROW_BLOCK_WISE_N: {
                    mem = OptimizerUtils.estimateSize(dpf._N, mo.getNumColumns());
                    break;
                }
            }
        }
        return mem;
    }

    protected double getMemoryEstimate(String varName, LocalVariableMap vars) {
        Data dat = vars.get(varName);
        return dat instanceof MatrixObject ? (double)OptimizerUtils.estimateSize(((MatrixObject)dat).getDataCharacteristics()) : OptimizerUtils.DEFAULT_SIZE;
    }

    protected static LopProperties.ExecType getRIXExecType(MatrixObject mo, ParForProgramBlock.PDataPartitionFormat dpf, boolean withSparsity) {
        double mem = -1.0;
        long rlen = mo.getNumRows();
        long clen = mo.getNumColumns();
        long blen = mo.getBlocksize();
        long nnz = mo.getNnz();
        double lsparsity = (double)nnz / (double)rlen / (double)clen;
        double sparsity = withSparsity ? lsparsity : 1.0;
        switch (dpf) {
            case COLUMN_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), 1L, sparsity);
                break;
            }
            case COLUMN_BLOCK_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), blen, sparsity);
                break;
            }
            case ROW_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(1L, mo.getNumColumns(), sparsity);
                break;
            }
            case ROW_BLOCK_WISE: {
                mem = OptimizerUtils.estimateSizeExactSparsity(blen, mo.getNumColumns(), sparsity);
                break;
            }
        }
        if (mem < OptimizerUtils.getLocalMemBudget()) {
            return LopProperties.ExecType.CP;
        }
        return LopProperties.ExecType.CP_FILE;
    }

    public static boolean allowsBinaryCellPartitions(MatrixObject mo, ParForProgramBlock.PartitionFormat dpf) {
        return OptimizerRuleBased.getRIXExecType(mo, ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE, false) == LopProperties.ExecType.CP;
    }

    protected boolean rewriteSetResultPartitioning(OptNode n, double M, LocalVariableMap vars) {
        boolean apply;
        long id = n.getID();
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
        ParForProgramBlock pfpb = (ParForProgramBlock)o[1];
        Collection<OptNode> cand = n.getNodeList(this.getRemoteExecType());
        boolean bl = apply = M < this._rm && !cand.isEmpty() && this.isResultPartitionableAll(cand, pfpb.getResultVariables(), vars, pfpb.getIterVar());
        if (apply) {
            try {
                for (OptNode lix : cand) {
                    this.recompileLIX(lix, vars);
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Unable to recompile LIX.", ex);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set result partitioning' - result=" + apply));
        return apply;
    }

    protected boolean isResultPartitionableAll(Collection<OptNode> nlist, ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars, String iterVarname) {
        boolean ret = true;
        for (OptNode n : nlist) {
            if (!(ret &= this.isResultPartitionable(n, resultVars, vars, iterVarname))) break;
        }
        return ret;
    }

    protected boolean isResultPartitionable(OptNode n, ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars, String iterVarname) {
        boolean ret = true;
        String opStr = n.getParam(OptNode.ParamType.OPSTRING);
        if (opStr == null || !opStr.equals(LeftIndexingOp.OPSTRING)) {
            ret = false;
        }
        Hop h = null;
        Hop base = null;
        if (ret && !ParForStatementBlock.ResultVar.contains(resultVars, (base = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0)).getName())) {
            ret = false;
        }
        if (ret) {
            int dpf = 0;
            Hop inpRowL = h.getInput().get(2);
            Hop inpRowU = h.getInput().get(3);
            Hop inpColL = h.getInput().get(4);
            Hop inpColU = h.getInput().get(5);
            if (inpRowL.getName().equals(iterVarname) && inpRowU.getName().equals(iterVarname)) {
                dpf = 1;
            }
            if (inpColL.getName().equals(iterVarname) && inpColU.getName().equals(iterVarname)) {
                int n2 = dpf = dpf == 0 ? 2 : 3;
            }
            if (dpf == 0) {
                ret = false;
            } else {
                boolean sparse;
                MatrixObject mo = (MatrixObject)vars.get(base.getName());
                if (mo.getNnz() != 0L) {
                    ret = false;
                }
                if (sparse = MatrixBlock.evalSparseFormatInMemory(base.getDim1(), base.getDim2(), base.getDim1())) {
                    double memSparseBlock = OptimizerRuleBased.estimateSizeSparseRowBlock(base.getDim1());
                    double memSparseRow1 = OptimizerRuleBased.estimateSizeSparseRow(base.getDim2(), base.getDim2());
                    double memSparseRowMin = OptimizerRuleBased.estimateSizeSparseRowMin(base.getDim2());
                    double memTask1 = -1.0;
                    int taskN = -1;
                    switch (dpf) {
                        case 1: {
                            memTask1 = memSparseBlock + memSparseRow1;
                            taskN = (int)((this._rm - memSparseBlock) / memSparseRow1);
                            break;
                        }
                        case 2: {
                            memTask1 = memSparseBlock + memSparseRowMin * (double)base.getDim1();
                            taskN = OptimizerRuleBased.estimateNumTasksSparseCol(this._rm - memSparseBlock, base.getDim1());
                            break;
                        }
                        case 3: {
                            memTask1 = memSparseBlock + memSparseRowMin;
                            taskN = (int)((this._rm - memSparseBlock) / memSparseRowMin);
                        }
                    }
                    if (memTask1 > this._rm || memTask1 < 0.0) {
                        ret = false;
                    } else {
                        n.addParam(OptNode.ParamType.TASK_SIZE, String.valueOf(taskN));
                    }
                } else {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private static double estimateSizeSparseRowBlock(long rows) {
        return 44L + rows * 8L;
    }

    private static double estimateSizeSparseRow(long cols, long nnz) {
        long cnnz = Math.max(4L, Math.max(cols, nnz));
        return 116L + 12L * cnnz;
    }

    private static double estimateSizeSparseRowMin(long cols) {
        long cnnz = Math.min(4L, cols);
        return 116L + 12L * cnnz;
    }

    private static int estimateNumTasksSparseCol(double budget, long rows) {
        double lbudget = budget - (double)(rows * 116L);
        return (int)Math.floor(lbudget / 12.0);
    }

    protected void recompileLIX(OptNode n, LocalVariableMap vars) {
        Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
        h.setForcedExecType(LopProperties.ExecType.CP);
        n.setExecType(OptNode.ExecType.CP);
        long pid = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
        OptNode nParent = OptTreeConverter.getAbstractPlanMapping().getOptNode(pid);
        Object[] o = OptTreeConverter.getAbstractPlanMapping().getMappedProg(pid);
        StatementBlock sb = (StatementBlock)o[0];
        BasicProgramBlock pb = (BasicProgramBlock)o[1];
        HashMap<Hop, Double> estRix = this.getPartitionedRIXEstimates(nParent);
        ArrayList<Instruction> newInst = Recompiler.recompileHopsDag(sb, sb.getHops(), vars, null, false, false, 0L);
        pb.setInstructions(newInst);
        this.resetPartitionRIXEstimates(estRix);
        h.setMemEstimate(this._rm - 1.0);
    }

    protected HashMap<Hop, Double> getPartitionedRIXEstimates(OptNode parent) {
        HashMap<Hop, Double> estimates = new HashMap<Hop, Double>();
        for (OptNode n : parent.getChilds()) {
            if (n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null) continue;
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            estimates.put(h, h.getMemEstimate());
        }
        return estimates;
    }

    protected void resetPartitionRIXEstimates(HashMap<Hop, Double> estimates) {
        for (Map.Entry<Hop, Double> e : estimates.entrySet()) {
            Hop h = e.getKey();
            double val = e.getValue();
            h.setMemEstimate(val);
        }
    }

    protected boolean rewriteSetExecutionStategy(OptNode n, double M0, double M, double M2, double M3, boolean flagLIX) {
        boolean isCPOnly = n.isCPOnly();
        boolean isCPOnlyPossible = isCPOnly || this.isCPOnlyPossible(n, this._rm);
        String datapartitioner = n.getParam(OptNode.ParamType.DATA_PARTITIONER);
        OptNode.ExecType REMOTE = this.getRemoteExecType();
        ParForProgramBlock.PDataPartitioner REMOTE_DP = ParForProgramBlock.PDataPartitioner.REMOTE_SPARK;
        if (ConfigurationManager.isParallelParFor() && (isCPOnly && M <= this._rm || isCPOnly && M3 <= this._rm || isCPOnlyPossible && M2 <= this._rm)) {
            int cpk = (int)Math.min((double)this._lk, Math.floor(this._lm / M));
            if (2 * cpk < this._lk && (long)(2 * cpk) < this._N && 2 * cpk < this._rk) {
                n.setExecType(REMOTE);
            } else if ((long)this._lk < this._N && this._lk < this._rk && M <= this._rm && this.isLargeProblem(n, M0)) {
                n.setExecType(REMOTE);
            } else if (!isCPOnly && isCPOnlyPossible) {
                n.setExecType(REMOTE);
            } else if (flagLIX) {
                n.setExecType(REMOTE);
            } else if (datapartitioner != null && datapartitioner.equals(REMOTE_DP.toString()) && !InfrastructureAnalyzer.isLocalMode()) {
                n.setExecType(REMOTE);
            } else {
                n.setExecType(OptNode.ExecType.CP);
            }
        } else {
            n.setExecType(OptNode.ExecType.CP);
        }
        long id = n.getID();
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(id)[1];
        ParForProgramBlock.PExecMode mode = n.getExecType().toParForExecMode();
        pfpb.setExecMode(mode);
        boolean requiresRecompile = mode == ParForProgramBlock.PExecMode.REMOTE_SPARK && !isCPOnly;
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set execution strategy' - result=" + (Object)((Object)mode) + " (recompile=" + requiresRecompile + ")"));
        return requiresRecompile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isLargeProblem(OptNode pn, double M) {
        boolean isCtxCreated;
        boolean bl = isCtxCreated = OptimizerUtils.isSparkExecutionMode() && SparkExecutionContext.isSparkContextCreated();
        if ((double)this._N >= 100.0) {
            if (M > 2.68435456E8) return true;
        }
        if (!((double)this._Nmax >= 1000.0)) return false;
        int n = isCtxCreated ? 10 : 1;
        if (!(M > 2.68435456E8 / (double)n)) return false;
        return true;
    }

    protected boolean isCPOnlyPossible(OptNode n, double memBudget) {
        double mem;
        Hop h;
        boolean ret;
        OptNode.ExecType et = n.getExecType();
        boolean bl = ret = et == OptNode.ExecType.CP;
        if (n.isLeaf() && et == this.getRemoteExecType() && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getForcedExecType() != LopProperties.ExecType.SPARK && h.hasValidCPDimsAndSize() && (mem = this._cost.getLeafNodeEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, n, LopProperties.ExecType.CP)) <= memBudget) {
            ret = true;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                if (!ret) break;
                ret &= this.isCPOnlyPossible(c, memBudget);
            }
        }
        return ret;
    }

    protected void rewriteSetOperationsExecType(OptNode pn, boolean recompile) {
        int count = this.setOperationExecType(pn, OptNode.ExecType.CP);
        if (recompile && count <= 0) {
            LOG.warn((Object)"OPT: Forced set operations exec type 'CP', but no operation requires recompile.");
        }
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        HashSet<String> fnStack = new HashSet<String>();
        Recompiler.recompileProgramBlockHierarchy2Forced(pfpb.getChildBlocks(), 0L, fnStack, LopProperties.ExecType.CP);
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set operation exec type CP' - result=" + count));
    }

    protected int setOperationExecType(OptNode n, OptNode.ExecType et) {
        int count = 0;
        if (n.getExecType() != OptNode.ExecType.CP && n.getNodeType() == OptNode.NodeType.HOP) {
            n.setExecType(OptNode.ExecType.CP);
            count = 1;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                count += this.setOperationExecType(c, et);
            }
        }
        return count;
    }

    protected void rewriteDataColocation(OptNode n, LocalVariableMap vars) {
        boolean apply = false;
        String varname = null;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if (apply) {
            pfpb.enableColocatedPartitionedMatrix(varname);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'enable data colocation' - result=" + apply + (apply ? " (" + varname + ")" : "")));
    }

    protected void rFindDataColocationCandidates(OptNode n, HashSet<String> cand, String iterVarname) {
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                this.rFindDataColocationCandidates(cn, cand, iterVarname);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) != null) {
            ParForProgramBlock.PartitionFormat dpf = ParForProgramBlock.PartitionFormat.valueOf(n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT));
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String inMatrix = h.getInput().get(0).getName();
            String indexAccess = null;
            switch (dpf._dpf) {
                case ROW_WISE: {
                    if (!(h.getInput().get(1) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(1).getName();
                    break;
                }
                case COLUMN_WISE: {
                    if (!(h.getInput().get(3) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(3).getName();
                    break;
                }
            }
            if (indexAccess != null && indexAccess.equals(iterVarname)) {
                cand.add(inMatrix);
            }
        }
    }

    protected void rewriteSetPartitionReplicationFactor(OptNode n, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, LocalVariableMap vars) {
        boolean apply = false;
        double sizeReplicated = 0.0;
        int replication = 1;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if (n.getExecType() == OptNode.ExecType.SPARK && n.getParam(OptNode.ParamType.DATA_PARTITIONER).equals(ParForProgramBlock.PDataPartitioner.REMOTE_SPARK.name()) && n.hasNestedParallelism(false) && n.hasNestedPartitionReads(false)) {
            apply = true;
            replication = (int)Math.min(this._N, (long)this._rnk);
            replication = Math.min(replication, 5);
            try (FileSystem fs = IOUtilFunctions.getFileSystem((Configuration)ConfigurationManager.getCachedJobConf());){
                long hdfsCapacityRemain = fs.getStatus().getRemaining();
                long sizeInputs = 0L;
                for (String var : partitionedMatrices.keySet()) {
                    MatrixObject mo = (MatrixObject)vars.get(var);
                    Path fname = new Path(mo.getFileName());
                    if (!fs.exists(fname)) continue;
                    sizeInputs += fs.getContentSummary(fname).getLength();
                }
                replication = (int)Math.min((double)replication, Math.floor(0.9 * (double)hdfsCapacityRemain / (double)sizeInputs));
                replication = Math.max(replication, 1);
                sizeReplicated = (long)replication * sizeInputs;
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Failed to analyze remaining hdfs capacity.", ex);
            }
        }
        if (apply) {
            pfpb.setPartitionReplicationFactor(replication);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set partition replication factor' - result=" + apply + (apply ? " (" + replication + ", " + OptimizerRuleBased.toMB(sizeReplicated) + ")" : "")));
    }

    protected void rewriteSetExportReplicationFactor(OptNode n, LocalVariableMap vars) {
        boolean apply = false;
        int replication = -1;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        if (n.getExecType() == this.getRemoteExecType()) {
            apply = true;
            replication = (int)Math.min(this._N, (long)this._rnk);
            replication = Math.min(replication, 7);
        }
        if (apply) {
            pfpb.setExportReplicationFactor(replication);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set export replication factor' - result=" + apply + (apply ? " (" + replication + ")" : "")));
    }

    protected double getMaxCPOnlyBudget(OptNode n) {
        double mem;
        Hop h;
        OptNode.ExecType et = n.getExecType();
        double ret = 0.0;
        if (n.isLeaf() && et != this.getRemoteExecType() && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getForcedExecType() != LopProperties.ExecType.SPARK && !((mem = this._cost.getLeafNodeEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, n, LopProperties.ExecType.CP)) >= OptimizerUtils.DEFAULT_SIZE)) {
            ret = Math.max(ret, mem);
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                ret = Math.max(ret, this.getMaxCPOnlyBudget(c));
            }
        }
        return ret;
    }

    protected void rewriteSetDegreeOfParallelism(OptNode n, CostEstimator cost, LocalVariableMap vars, double M, boolean flagNested) {
        OptNode.ExecType type = n.getExecType();
        long id = n.getID();
        Object[] map = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
        ParForStatementBlock pfsb = (ParForStatementBlock)map[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)map[1];
        if (type == OptNode.ExecType.CP) {
            int kMax = ConfigurationManager.isParallelParFor() ? (n.isCPOnly() ? this._lkmaxCP : this._lkmaxMR) : 1;
            double mem = OptimizerUtils.isSparkExecutionMode() && !n.isCPOnly() ? this._lm / 2.0 : this._lm;
            double sharedM = 0.0;
            double nonSharedM = M;
            if (OptimizerRuleBased.computeMaxK(M, M, 0.0, mem) < kMax) {
                sharedM = pfsb.getReadOnlyParentMatrixVars().stream().map(s -> vars.get((String)s)).filter(d -> d instanceof MatrixObject).mapToDouble(mo -> OptimizerUtils.estimateSize(((MatrixObject)mo).getDataCharacteristics())).sum();
                nonSharedM = cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, n, true, pfsb.getReadOnlyParentMatrixVars(), CostEstimator.ExcludeType.SHARED_READ);
            }
            kMax = Math.min(kMax, OptimizerRuleBased.computeMaxK(M, nonSharedM, sharedM, mem));
            int parforK = (int)(this._N < (long)(kMax = Math.max(kMax, 1)) ? this._N : (long)kMax);
            if (DMLScript.USE_ACCELERATOR) {
                long perGPUBudget = GPUContextPool.initialGPUMemBudget();
                double maxMemUsage = this.getMaxCPOnlyBudget(n);
                if (maxMemUsage < (double)perGPUBudget) {
                    parforK = GPUContextPool.getDeviceCount();
                    parforK = Math.min(parforK, (int)this._N);
                    LOG.debug((Object)("Setting degree of parallelism + [" + parforK + "] for GPU; per GPU budget :[" + perGPUBudget + "], parfor budget :[" + maxMemUsage + "],  max parallelism per GPU : [" + parforK + "]"));
                }
            }
            pfpb.setDegreeOfParallelism(parforK);
            n.setK(parforK);
            int remainParforK = OptimizerRuleBased.getRemainingParallelismParFor(kMax, parforK);
            int remainOpsK = OptimizerRuleBased.getRemainingParallelismOps(this._lkmaxCP, parforK);
            this.rAssignRemainingParallelism(n, remainParforK, remainOpsK);
        } else {
            int kMax = -1;
            if (flagNested) {
                pfpb.setDegreeOfParallelism(this._rnk);
                n.setK(this._rnk);
                kMax = this._rkmax / this._rnk;
            } else {
                int tmpK = (int)(this._N < (long)this._rk ? this._N : (long)this._rk);
                pfpb.setDegreeOfParallelism(tmpK);
                n.setK(tmpK);
                kMax = this._rkmax / tmpK;
            }
            kMax = Math.min(kMax, (int)Math.floor(this._rm / M));
            if (kMax < 1) {
                kMax = 1;
            }
            kMax = 1;
            this.rAssignRemainingParallelism(n, kMax, 1);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set degree of parallelism' - result=(see EXPLAIN)"));
    }

    private static int computeMaxK(double M, double memNonShared, double memShared, double memBudget) {
        int k1 = (int)Math.floor(memBudget / M);
        int k2 = (int)Math.floor(memBudget - memShared / memNonShared);
        return Math.max(k1, k2);
    }

    protected void rAssignRemainingParallelism(OptNode n, int parforK, int opsK) {
        ArrayList<OptNode> childs = n.getChilds();
        if (childs != null) {
            boolean recompileSB = false;
            for (OptNode c : childs) {
                if (c.getNodeType() == OptNode.NodeType.PARFOR) {
                    int tmpN = Integer.parseInt(c.getParam(OptNode.ParamType.NUM_ITERATIONS));
                    int tmpK = tmpN < parforK ? tmpN : parforK;
                    long id = c.getID();
                    c.setK(tmpK);
                    ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(id);
                    pfpb.setDegreeOfParallelism(tmpK);
                    int remainParforK = OptimizerRuleBased.getRemainingParallelismParFor(parforK, tmpK);
                    int remainOpsK = OptimizerRuleBased.getRemainingParallelismOps(opsK, tmpK);
                    this.rAssignRemainingParallelism(c, remainParforK, remainOpsK);
                    continue;
                }
                if (c.getNodeType() == OptNode.NodeType.HOP) {
                    Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(c.getID());
                    if (ConfigurationManager.isParallelMatrixOperations() && h instanceof MultiThreadedHop && ((MultiThreadedHop)h).isMultiThreadedOpType()) {
                        MultiThreadedHop mhop = (MultiThreadedHop)h;
                        mhop.setMaxNumThreads(opsK);
                        c.setK(opsK);
                        recompileSB = true;
                    } else if (h instanceof MultiThreadedHop) {
                        MultiThreadedHop mhop = (MultiThreadedHop)h;
                        mhop.setMaxNumThreads(1);
                        c.setK(1);
                    }
                    if (!HopRewriteUtils.isNary(h, Types.OpOpN.EVAL)) continue;
                    ProgramBlock pb = OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(n.getID());
                    pb.getProgram().getFunctionProgramBlocks(false).forEach((fname, fvalue) -> ParamservUtils.recompileProgramBlocks(1, fvalue.getChildBlocks()));
                    continue;
                }
                this.rAssignRemainingParallelism(c, parforK, opsK);
            }
            if (recompileSB) {
                try {
                    ProgramBlock pb = OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(n.getID());
                    Recompiler.recompileProgramBlockInstructions(pb);
                }
                catch (Exception ex) {
                    throw new DMLRuntimeException(ex);
                }
            }
        }
    }

    protected static int getRemainingParallelismParFor(int parforK, int tmpK) {
        return (int)Math.ceil((double)(parforK - tmpK + 1) / (double)tmpK);
    }

    protected static int getRemainingParallelismOps(int opsK, int tmpK) {
        return NativeHelper.isNativeLibraryLoaded() ? Math.max(opsK / tmpK, 1) : (int)Math.max(Math.round((double)opsK / (double)tmpK), 1L);
    }

    protected void rewriteSetTaskPartitioner(OptNode pn, boolean flagNested, boolean flagLIX) {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Task partitioner can only be set for a ParFor node."));
        }
        if (flagNested && flagLIX) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Task partitioner decision has conflicting input from rewrites 'nested parallelism' and 'result partitioning'."));
        }
        if (flagNested) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.STATIC);
            this.setTaskPartitioner(pn.getChilds().get(0), ParForProgramBlock.PTaskPartitioner.FACTORING);
        } else if (flagLIX) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.FACTORING_CMAX);
        } else if (pn.getExecType() == OptNode.ExecType.SPARK && pn.hasOnlySimpleChilds()) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.STATIC);
        } else if (this._N / 4L >= (long)pn.getK()) {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.FACTORING);
        } else {
            this.setTaskPartitioner(pn, ParForProgramBlock.PTaskPartitioner.NAIVE);
        }
    }

    protected void setTaskPartitioner(OptNode n, ParForProgramBlock.PTaskPartitioner partitioner) {
        boolean flagLIX;
        long id = n.getID();
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(id);
        pfpb.setTaskPartitioner(partitioner);
        n.addParam(OptNode.ParamType.TASK_PARTITIONER, partitioner.toString());
        boolean bl = flagLIX = partitioner == ParForProgramBlock.PTaskPartitioner.FACTORING_CMAX;
        if (flagLIX) {
            long maxc = n.getMaxC(this._N);
            pfpb.setTaskSize(maxc);
            pfpb.disableJVMReuse();
            n.addParam(OptNode.ParamType.TASK_SIZE, String.valueOf(maxc));
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set task partitioner' - result=" + (Object)((Object)partitioner) + (flagLIX ? "," + n.getParam(OptNode.ParamType.TASK_SIZE) : "")));
    }

    protected void rewriteSetFusedDataPartitioningExecution(OptNode pn, double M, boolean flagLIX, HashMap<String, ParForProgramBlock.PartitionFormat> partitionedMatrices, LocalVariableMap vars) {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Fused data partitioning and execution is only applicable for a ParFor node."));
        }
        boolean apply = false;
        String partitioner = pn.getParam(OptNode.ParamType.DATA_PARTITIONER);
        ParForProgramBlock.PDataPartitioner REMOTE_DP = ParForProgramBlock.PDataPartitioner.REMOTE_SPARK;
        ParForProgramBlock.PExecMode REMOTE_DPE = ParForProgramBlock.PExecMode.REMOTE_SPARK_DP;
        if (pn.getExecType() == OptNode.ExecType.SPARK && partitioner != null && partitioner.equals(REMOTE_DP.toString()) && partitionedMatrices.size() == 1) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
            String moVarname = partitionedMatrices.keySet().iterator().next();
            ParForProgramBlock.PartitionFormat moDpf = partitionedMatrices.get(moVarname);
            MatrixObject mo = (MatrixObject)vars.get(moVarname);
            if (this.rIsAccessByIterationVariable(pn, moVarname, pfpb.getIterVar()) && (moDpf == ParForProgramBlock.PartitionFormat.ROW_WISE && mo.getNumRows() == this._N || moDpf == ParForProgramBlock.PartitionFormat.COLUMN_WISE && mo.getNumColumns() == this._N || moDpf._dpf == ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N && mo.getNumRows() <= this._N * (long)moDpf._N || moDpf._dpf == ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE_N && mo.getNumColumns() <= this._N * (long)moDpf._N)) {
                int k = (int)Math.min(this._N, (long)this._rk2);
                pn.addParam(OptNode.ParamType.DATA_PARTITIONER, REMOTE_DPE.toString() + "(fused)");
                pn.setK(k);
                pfpb.setExecMode(REMOTE_DPE);
                pfpb.setDataPartitioner(ParForProgramBlock.PDataPartitioner.NONE);
                pfpb.enableColocatedPartitionedMatrix(moVarname);
                pfpb.setDegreeOfParallelism(k);
                apply = true;
            }
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set fused data partitioning and execution' - result=" + apply));
    }

    protected boolean rIsAccessByIterationVariable(OptNode n, String varName, String iterVarname) {
        boolean ret = true;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                this.rIsAccessByIterationVariable(cn, varName, iterVarname);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) && n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) != null) {
            ParForProgramBlock.PartitionFormat dpf = ParForProgramBlock.PartitionFormat.valueOf(n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT));
            Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String inMatrix = h.getInput().get(0).getName();
            String indexAccess = null;
            switch (dpf._dpf) {
                case ROW_WISE: {
                    if (!(h.getInput().get(1) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(1).getName();
                    break;
                }
                case ROW_BLOCK_WISE_N: {
                    indexAccess = OptimizerRuleBased.rGetVarFromExpression(h.getInput().get(1));
                    break;
                }
                case COLUMN_WISE: {
                    if (!(h.getInput().get(3) instanceof DataOp)) break;
                    indexAccess = h.getInput().get(3).getName();
                    break;
                }
                case COLUMN_BLOCK_WISE_N: {
                    indexAccess = OptimizerRuleBased.rGetVarFromExpression(h.getInput().get(3));
                    break;
                }
            }
            ret &= inMatrix != null && inMatrix.equals(varName) && indexAccess != null && indexAccess.equals(iterVarname);
        }
        return ret;
    }

    private static String rGetVarFromExpression(Hop current) {
        String var = null;
        for (Hop c : current.getInput()) {
            var = OptimizerRuleBased.rGetVarFromExpression(c);
            if (var == null) continue;
            return var;
        }
        return current instanceof DataOp ? current.getName() : null;
    }

    protected boolean rIsTransposeSafePartition(OptNode n, String varName) {
        boolean ret;
        block3: {
            Hop h;
            String inMatrix;
            block2: {
                ret = true;
                if (n.isLeaf()) break block2;
                for (OptNode cn : n.getChilds()) {
                    this.rIsTransposeSafePartition(cn, varName);
                }
                break block3;
            }
            if (n.getNodeType() != OptNode.NodeType.HOP || !n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) || n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null || !(inMatrix = (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName()).equals(varName)) break block3;
            ArrayList<Hop> parent = h.getParent();
            for (Hop p : parent) {
                ret &= p.isTransposeSafe();
            }
        }
        return ret;
    }

    protected void rewriteSetInPlaceResultIndexing(OptNode pn, CostEstimator cost, LocalVariableMap vars, HashSet<ParForStatementBlock.ResultVar> inPlaceResultVars, ExecutionContext ec) {
        if (pn.getNodeType() != OptNode.NodeType.PARFOR) {
            LOG.warn((Object)((Object)((Object)this.getOptMode()) + " OPT: Set in-place result update is only applicable for a ParFor node."));
        }
        boolean apply = false;
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(pn.getID())[1];
        ArrayList<ParForStatementBlock.ResultVar> retVars = pfpb.getResultVariables();
        double totalMem = -1.0;
        if (this.rHasOnlyInPlaceSafeLeftIndexing(pn, retVars)) {
            double sum = OptimizerRuleBased.computeTotalSizeResultVariables(retVars, vars, pfpb.getDegreeOfParallelism());
            double M = cost.getEstimate(CostEstimator.TestMeasure.MEMORY_USAGE, pn, true, retVars.stream().map(var -> var._name).collect(Collectors.toList()), CostEstimator.ExcludeType.RESULT_LIX);
            totalMem = M + sum;
            if ((pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_SPARK_DP || pfpb.getExecMode() == ParForProgramBlock.PExecMode.REMOTE_SPARK) && totalMem < this._rm) {
                apply = true;
            } else if (pfpb.getExecMode() == ParForProgramBlock.PExecMode.LOCAL && totalMem * (double)pfpb.getDegreeOfParallelism() < this._lm && pn.isCPOnly()) {
                apply = true;
            }
        }
        if (apply) {
            for (ParForStatementBlock.ResultVar var2 : retVars) {
                Data dat = vars.get(var2._name);
                if (!(dat instanceof MatrixObject)) continue;
                ((MatrixObject)dat).setUpdateType(MatrixObject.UpdateType.INPLACE_PINNED);
            }
            inPlaceResultVars.addAll(retVars);
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set in-place result indexing' - result=" + apply + " (" + Arrays.toString(inPlaceResultVars.toArray(new ParForStatementBlock.ResultVar[0])) + ", M=" + OptimizerRuleBased.toMB(totalMem) + ")"));
    }

    protected boolean rHasOnlyInPlaceSafeLeftIndexing(OptNode n, ArrayList<ParForStatementBlock.ResultVar> retVars) {
        Hop h;
        boolean ret = true;
        if (!n.isLeaf()) {
            for (OptNode cn : n.getChilds()) {
                ret &= this.rHasOnlyInPlaceSafeLeftIndexing(cn, retVars);
            }
        } else if (n.getNodeType() == OptNode.NodeType.HOP && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())) instanceof LeftIndexingOp && ParForStatementBlock.ResultVar.contains(retVars, h.getInput().get(0).getName()) && !retVars.stream().anyMatch(rvar -> rvar._isAccum)) {
            ret &= h.getParent().size() == 1 && h.getParent().get(0).getName().equals(h.getInput().get(0).getName());
        }
        return ret;
    }

    private static double computeTotalSizeResultVariables(ArrayList<ParForStatementBlock.ResultVar> retVars, LocalVariableMap vars, int k) {
        double sum = 1.0;
        for (ParForStatementBlock.ResultVar var : retVars) {
            Data dat = vars.get(var._name);
            if (!(dat instanceof MatrixObject)) continue;
            MatrixObject mo = (MatrixObject)dat;
            sum += (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), Math.min(1.0 / (double)k + mo.getSparsity(), 1.0));
        }
        return sum;
    }

    protected double rComputeSumMemoryIntermediates(OptNode n, HashSet<ParForStatementBlock.ResultVar> inplaceResultVars) {
        double sum;
        block3: {
            Hop h;
            block4: {
                block2: {
                    sum = 0.0;
                    if (n.isLeaf()) break block2;
                    for (OptNode cn : n.getChilds()) {
                        sum += this.rComputeSumMemoryIntermediates(cn, inplaceResultVars);
                    }
                    break block3;
                }
                if (n.getNodeType() != OptNode.NodeType.HOP) break block3;
                h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
                if (!n.getParam(OptNode.ParamType.OPSTRING).equals(IndexingOp.OPSTRING) || n.getParam(OptNode.ParamType.DATA_PARTITION_FORMAT) == null) break block4;
                sum += h.getMemEstimate();
                break block3;
            }
            sum += h.getOutputMemEstimate() + h.getIntermediateMemEstimate();
            if (h.getInput() == null) break block3;
            for (Hop cn : h.getInput()) {
                if (!(cn instanceof DataOp) || !((DataOp)cn).isRead() || ParForStatementBlock.ResultVar.contains(inplaceResultVars, cn.getName())) continue;
                sum += cn.getMemEstimate();
            }
        }
        return sum;
    }

    protected void rewriteInjectSparkLoopCheckpointing(OptNode n) {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForStatement fs = (ParForStatement)pfsb.getStatement(0);
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        boolean applied = false;
        try {
            RewriteInjectSparkLoopCheckpointing rewrite = new RewriteInjectSparkLoopCheckpointing(false);
            ProgramRewriter rewriter = new ProgramRewriter(rewrite);
            ProgramRewriteStatus state = new ProgramRewriteStatus();
            rewriter.rRewriteStatementBlockHopDAGs(pfsb, state);
            fs.setBody(rewriter.rRewriteStatementBlocks(fs.getBody(), state, true));
            if (state.getInjectedCheckpoints()) {
                pfpb.setChildBlocks(ProgramRecompiler.generatePartitialRuntimeProgram(pfpb.getProgram(), fs.getBody()));
                applied = true;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'inject spark loop checkpointing' - result=" + applied));
    }

    protected void rewriteInjectSparkRepartition(OptNode n, LocalVariableMap vars) {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        ArrayList<String> ret = new ArrayList<String>();
        if (OptimizerUtils.isSparkExecutionMode() && n.getExecType() == OptNode.ExecType.CP && this._N > 1L) {
            HashSet<String> cand = new HashSet<String>();
            this.rCollectZipmmPartitioningCandidates(n, cand);
            HashSet<String> probe = new HashSet<String>(pfsb.getReadOnlyParentMatrixVars());
            for (String var : cand) {
                if (!probe.contains(var)) continue;
                ret.add(var);
            }
            ArrayList tmp = new ArrayList(ret);
            ret.clear();
            for (String var : tmp) {
                if (!(vars.get(var) instanceof MatrixObject)) continue;
                MatrixObject mo = (MatrixObject)vars.get(var);
                double sp = OptimizerUtils.getSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getNnz());
                double size = OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), sp);
                if (!(size > OptimizerUtils.getLocalMemBudget())) continue;
                ret.add(var);
            }
            if (!ret.isEmpty()) {
                pfpb.setSparkRepartitionVariables(ret);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'inject spark input repartition' - result=" + ret.size() + " (" + Arrays.toString(ret.toArray()) + ")"));
    }

    private void rCollectZipmmPartitioningCandidates(OptNode n, HashSet<String> cand) {
        Hop h;
        if (n.getNodeType() == OptNode.NodeType.HOP && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())) instanceof AggBinaryOp && (((AggBinaryOp)h).getMMultMethod() == AggBinaryOp.MMultMethod.ZIPMM || ((AggBinaryOp)h).getMMultMethod() == AggBinaryOp.MMultMethod.CPMM)) {
            for (Hop in : h.getInput()) {
                if (in instanceof DataOp) {
                    cand.add(in.getName());
                    continue;
                }
                if (!HopRewriteUtils.isTransposeOperation(in) || !(in.getInput().get(0) instanceof DataOp)) continue;
                cand.add(in.getInput().get(0).getName());
            }
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rCollectZipmmPartitioningCandidates(c, cand);
            }
        }
    }

    protected void rewriteSetSparkEagerRDDCaching(OptNode n, LocalVariableMap vars) {
        Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID());
        ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
        ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
        ArrayList<String> ret = new ArrayList<String>();
        if (OptimizerUtils.isSparkExecutionMode() && n.getExecType() == OptNode.ExecType.CP && this._N > 1L) {
            Set<String> cand = pfsb.variablesRead().getVariableNames();
            Collection<String> rpVars = pfpb.getSparkRepartitionVariables();
            for (String var : cand) {
                Data dat = vars.get(var);
                if (dat == null || !(dat instanceof MatrixObject) || ((MatrixObject)dat).getRDDHandle() == null) continue;
                MatrixObject mo = (MatrixObject)dat;
                DataCharacteristics mc = mo.getDataCharacteristics();
                RDDObject rdd = mo.getRDDHandle();
                if (rpVars != null && rpVars.contains(var) || !rdd.rHasCheckpointRDDChilds() || !(this._lm / (double)n.getK() < (double)OptimizerUtils.estimateSizeExactSparsity(mc))) continue;
                ret.add(var);
            }
            if (!ret.isEmpty()) {
                pfpb.setSparkEagerCacheVariables(ret);
            }
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set spark eager rdd caching' - result=" + ret.size() + " (" + Arrays.toString(ret.toArray()) + ")"));
    }

    protected void rewriteRemoveUnnecessaryCompareMatrix(OptNode n, ExecutionContext ec) {
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        ArrayList<ParForStatementBlock.ResultVar> cleanedVars = new ArrayList<ParForStatementBlock.ResultVar>();
        ArrayList<ParForStatementBlock.ResultVar> resultVars = pfpb.getResultVariables();
        String itervar = pfpb.getIterVar();
        for (ParForStatementBlock.ResultVar rvar : resultVars) {
            Data dat = ec.getVariable(rvar._name);
            if (!(dat instanceof MatrixObject) || ((MatrixObject)dat).getNnz() == 0L || !n.hasOnlySimpleChilds() || !this.rContainsResultFullReplace(n, rvar._name, itervar, (MatrixObject)dat) || this.rIsReadInRightIndexing(n, rvar._name) || ((MatrixObject)dat).getNumRows() > Integer.MAX_VALUE || ((MatrixObject)dat).getNumColumns() > Integer.MAX_VALUE) continue;
            MatrixObject mo = (MatrixObject)dat;
            ec.cleanupCacheableData(mo);
            ec.setMatrixOutput(rvar._name, new MatrixBlock((int)mo.getNumRows(), (int)mo.getNumColumns(), false));
            cleanedVars.add(rvar);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove unnecessary compare matrix' - result=" + !cleanedVars.isEmpty() + " (" + ProgramConverter.serializeResultVariables(cleanedVars) + ")"));
    }

    protected boolean rContainsResultFullReplace(OptNode n, String resultVar, String iterVarname, MatrixObject mo) {
        boolean ret = false;
        if (n.getNodeType() == OptNode.NodeType.HOP) {
            ret |= this.isResultFullReplace(n, resultVar, iterVarname, mo);
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                ret |= this.rContainsResultFullReplace(c, resultVar, iterVarname, mo);
            }
        }
        return ret;
    }

    protected boolean isResultFullReplace(OptNode n, String resultVar, String iterVarname, MatrixObject mo) {
        String opStr = n.getParam(OptNode.ParamType.OPSTRING);
        if (opStr == null || !opStr.equals(LeftIndexingOp.OPSTRING)) {
            return false;
        }
        Hop h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
        Hop base = h.getInput().get(0);
        if (!resultVar.equals(base.getName())) {
            return false;
        }
        Hop inpRowL = h.getInput().get(2);
        Hop inpRowU = h.getInput().get(3);
        Hop inpColL = h.getInput().get(4);
        Hop inpColU = h.getInput().get(5);
        if (inpRowL.getName().equals(iterVarname) && inpRowU.getName().equals(iterVarname) && inpColL instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpColL) == 1.0 && inpColU instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpColU) == (double)mo.getNumColumns()) {
            return true;
        }
        return inpColL.getName().equals(iterVarname) && inpColU.getName().equals(iterVarname) && inpRowL instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpRowL) == 1.0 && inpRowU instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)inpRowU) == (double)mo.getNumRows();
    }

    protected boolean rIsReadInRightIndexing(OptNode n, String var) {
        Hop h;
        boolean ret = false;
        if (n.getNodeType() == OptNode.NodeType.HOP && (h = OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())) instanceof IndexingOp && h.getInput().get(0) instanceof DataOp && h.getInput().get(0).getName().equals(var)) {
            ret |= true;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                ret |= this.rIsReadInRightIndexing(c, var);
            }
        }
        return ret;
    }

    protected void rewriteSetResultMerge(OptNode n, LocalVariableMap vars, boolean inLocal) {
        ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
        ParForProgramBlock.PResultMerge REMOTE = ParForProgramBlock.PResultMerge.REMOTE_SPARK;
        ParForProgramBlock.PResultMerge ret = null;
        boolean flagRemoteParFOR = n.getExecType() == this.getRemoteExecType();
        boolean flagLargeResult = this.hasLargeTotalResults(n, pfpb.getResultVariables(), vars, true);
        boolean flagRemoteLeftIndexing = this.hasResultMRLeftIndexing(n, pfpb.getResultVariables(), vars, true);
        boolean flagCellFormatWoCompare = this.determineFlagCellFormatWoCompare(pfpb.getResultVariables(), vars);
        boolean flagOnlyInMemResults = this.hasOnlyInMemoryResults(n, pfpb.getResultVariables(), vars);
        if (flagRemoteParFOR && flagLargeResult) {
            ret = REMOTE;
        } else if (flagOnlyInMemResults) {
            ret = ParForProgramBlock.PResultMerge.LOCAL_MEM;
        } else if (flagRemoteParFOR || flagRemoteLeftIndexing) {
            if (flagCellFormatWoCompare) {
                // empty if block
            }
            ret = REMOTE;
        } else {
            ret = ParForProgramBlock.PResultMerge.LOCAL_AUTOMATIC;
        }
        pfpb.setResultMerge(ret);
        n.addParam(OptNode.ParamType.RESULT_MERGE, ret.toString());
        if (n.getChilds() != null) {
            this.rInvokeSetResultMerge(n.getChilds(), vars, inLocal && !flagRemoteParFOR);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set result merge' - result=" + (Object)((Object)ret)));
    }

    protected boolean determineFlagCellFormatWoCompare(ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars) {
        boolean ret = true;
        for (ParForStatementBlock.ResultVar rVar : resultVars) {
            Data dat = vars.get(rVar._name);
            if (dat == null || !(dat instanceof MatrixObject)) {
                ret = false;
                break;
            }
            MatrixObject mo = (MatrixObject)dat;
            MetaDataFormat meta = (MetaDataFormat)mo.getMetaData();
            long nnz = meta.getDataCharacteristics().getNonZeros();
            if (meta.getFileFormat() != Types.FileFormat.BINARY && nnz == 0L) continue;
            ret = false;
            break;
        }
        return ret;
    }

    protected boolean hasResultMRLeftIndexing(OptNode n, ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars, boolean checkSize) {
        boolean ret;
        block2: {
            block1: {
                long cols;
                LeftIndexingOp hop;
                String varName;
                ret = false;
                if (!n.isLeaf()) break block1;
                String opName = n.getParam(OptNode.ParamType.OPSTRING);
                if (opName == null || !opName.equals(LeftIndexingOp.OPSTRING) || n.getExecType() != this.getRemoteExecType() || !ParForStatementBlock.ResultVar.contains(resultVars, varName = (hop = (LeftIndexingOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName())) break block2;
                ret = true;
                if (!checkSize || !vars.keySet().contains(varName)) break block2;
                MatrixObject mo = (MatrixObject)vars.get(hop.getInput().get(0).getName());
                long rows = mo.getNumRows();
                ret = !OptimizerRuleBased.isInMemoryResultMerge(rows, cols = mo.getNumColumns(), SparkExecutionContext.getBroadcastMemoryBudget());
                break block2;
            }
            for (OptNode c : n.getChilds()) {
                ret |= this.hasResultMRLeftIndexing(c, resultVars, vars, checkSize);
            }
        }
        return ret;
    }

    protected boolean hasLargeTotalResults(OptNode pn, ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars, boolean checkSize) {
        double totalSize = 0.0;
        ParForProgramBlock.PTaskPartitioner tp = ParForProgramBlock.PTaskPartitioner.valueOf(pn.getParam(OptNode.ParamType.TASK_PARTITIONER));
        int k = pn.getK();
        long W = this.estimateNumTasks(tp, this._N, k);
        for (ParForStatementBlock.ResultVar var : resultVars) {
            Data dat = vars.get(var._name);
            if (dat == null || !(dat instanceof MatrixObject)) continue;
            MatrixObject mo = (MatrixObject)dat;
            long rows = mo.getNumRows();
            long cols = mo.getNumColumns();
            long nnz = mo.getNnz();
            if (nnz > 0L) {
                totalSize += (double)(W * OptimizerUtils.estimateSizeExactSparsity(rows, cols, 1.0));
                continue;
            }
            totalSize += (double)OptimizerUtils.estimateSizeExactSparsity(rows, cols, 1.0);
        }
        return totalSize >= this._lm;
    }

    protected long estimateNumTasks(ParForProgramBlock.PTaskPartitioner tp, long N, int k) {
        long W = -1L;
        switch (tp) {
            case NAIVE: 
            case FIXED: {
                W = N;
                break;
            }
            case STATIC: {
                W = N / (long)k;
                break;
            }
            case FACTORING: 
            case FACTORING_CMIN: 
            case FACTORING_CMAX: {
                W = (long)k * (long)(Math.log((double)N / (double)k) / Math.log(2.0));
                break;
            }
            default: {
                W = N;
            }
        }
        return W;
    }

    protected boolean hasOnlyInMemoryResults(OptNode n, ArrayList<ParForStatementBlock.ResultVar> resultVars, LocalVariableMap vars) {
        boolean ret = true;
        if (n.isLeaf()) {
            Data dat;
            LeftIndexingOp hop;
            String varName;
            String opName = n.getParam(OptNode.ParamType.OPSTRING);
            if (opName.equals(LeftIndexingOp.OPSTRING) && ParForStatementBlock.ResultVar.contains(resultVars, varName = (hop = (LeftIndexingOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID())).getInput().get(0).getName()) && vars.keySet().contains(varName) && (dat = vars.get(hop.getInput().get(0).getName())) instanceof MatrixObject) {
                MatrixObject mo = (MatrixObject)dat;
                long rows = mo.getNumRows();
                long cols = mo.getNumColumns();
                double memBudget = OptimizerUtils.getLocalMemBudget();
                ret &= OptimizerRuleBased.isInMemoryResultMerge(rows, cols, memBudget);
            }
        } else {
            for (OptNode c : n.getChilds()) {
                ret &= this.hasOnlyInMemoryResults(c, resultVars, vars);
            }
        }
        return ret;
    }

    protected void rInvokeSetResultMerge(Collection<OptNode> nodes, LocalVariableMap vars, boolean inLocal) {
        for (OptNode n : nodes) {
            if (n.getNodeType() == OptNode.NodeType.PARFOR) {
                this.rewriteSetResultMerge(n, vars, inLocal);
                if (n.getExecType() != this.getRemoteExecType()) continue;
                inLocal = false;
                continue;
            }
            if (n.getChilds() == null) continue;
            this.rInvokeSetResultMerge(n.getChilds(), vars, inLocal);
        }
    }

    public static boolean isInMemoryResultMerge(long rows, long cols, double memBudget) {
        return rows >= 0L && cols >= 0L && (double)MatrixBlock.estimateSizeInMemory(rows, cols, 1.0) < memBudget / 4.0;
    }

    protected void rewriteSetRecompileMemoryBudget(OptNode n) {
        double newLocalMem = this._lm;
        if (n.getExecType() == OptNode.ExecType.CP) {
            int par = n.getTotalK();
            newLocalMem = this._lm / (double)par;
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
            pfpb.setRecompileMemoryBudget(newLocalMem);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'set recompile memory budget' - result=" + OptimizerRuleBased.toMB(newLocalMem)));
    }

    protected void rewriteRemoveRecursiveParFor(OptNode n, LocalVariableMap vars) {
        int count = 0;
        HashSet<ParForProgramBlock> recPBs = new HashSet<ParForProgramBlock>();
        this.rFindRecursiveParFor(n, recPBs, false);
        if (!recPBs.isEmpty()) {
            try {
                ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
                if (recPBs.contains(pfpb)) {
                    this.rFindAndUnfoldRecursiveFunction(n, pfpb, recPBs, vars);
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            count = this.removeRecursiveParFor(n, recPBs);
        }
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove recursive parfor' - result=" + recPBs.size() + "/" + count));
    }

    protected void rFindRecursiveParFor(OptNode n, HashSet<ParForProgramBlock> cand, boolean recContext) {
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                if (c.getNodeType() == OptNode.NodeType.FUNCCALL && c.isRecursive()) {
                    this.rFindRecursiveParFor(c, cand, true);
                    continue;
                }
                this.rFindRecursiveParFor(c, cand, recContext);
            }
        }
        if (recContext && n.getNodeType() == OptNode.NodeType.PARFOR) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(n.getID())[1];
            cand.add(pfpb);
        }
    }

    protected void rFindAndUnfoldRecursiveFunction(OptNode n, ParForProgramBlock parfor, HashSet<ParForProgramBlock> recPBs, LocalVariableMap vars) {
        if (n.getNodeType() == OptNode.NodeType.FUNCCALL && n.isRecursive()) {
            boolean exists = this.rContainsNode(n, parfor);
            if (exists) {
                String fnameKey = n.getParam(OptNode.ParamType.OPSTRING);
                String[] names = fnameKey.split("::");
                String fnamespace = names[0];
                String fname = names[1];
                String fnameNew = FUNCTION_UNFOLD_NAMEPREFIX + fname;
                FunctionOp fop = (FunctionOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
                Program prog = parfor.getProgram();
                DMLProgram dmlprog = parfor.getStatementBlock().getDMLProg();
                FunctionProgramBlock fpb = prog.getFunctionProgramBlock(fnamespace, fname);
                FunctionProgramBlock copyfpb = ProgramConverter.createDeepCopyFunctionProgramBlock(fpb, new HashSet<String>(), new HashSet<String>());
                prog.addFunctionProgramBlock(fnamespace, fnameNew, copyfpb);
                dmlprog.addFunctionStatementBlock(fnamespace, fnameNew, (FunctionStatementBlock)copyfpb.getStatementBlock());
                this.rReplaceFunctionNames(n, fname, fnameNew);
                String fnameNewKey = fnamespace + "::" + fnameNew;
                OptNode nNew = new OptNode(OptNode.NodeType.FUNCCALL);
                OptTreeConverter.getAbstractPlanMapping().putHopMapping(fop, nNew);
                nNew.setExecType(OptNode.ExecType.CP);
                nNew.addParam(OptNode.ParamType.OPSTRING, fnameNewKey);
                long parentID = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
                OptTreeConverter.getAbstractPlanMapping().getOptNode(parentID).exchangeChild(n, nNew);
                HashSet<String> memo = new HashSet<String>();
                memo.add(fnameKey);
                memo.add(fnameNewKey);
                for (int i = 0; i < copyfpb.getChildBlocks().size(); ++i) {
                    ProgramBlock lpb = copyfpb.getChildBlocks().get(i);
                    StatementBlock lsb = lpb.getStatementBlock();
                    nNew.addChild(OptTreeConverter.rCreateAbstractOptNode(lsb, lpb, vars, false, memo));
                }
                recPBs.removeAll(this.rGetAllParForPBs(n, new HashSet<ParForProgramBlock>()));
                recPBs.addAll(this.rGetAllParForPBs(nNew, new HashSet<ParForProgramBlock>()));
                this.rReplaceFunctionNames(nNew, fname, fnameNew);
            }
            return;
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rFindAndUnfoldRecursiveFunction(c, parfor, recPBs, vars);
            }
        }
    }

    protected boolean rContainsNode(OptNode n, ParForProgramBlock parfor) {
        boolean ret;
        block2: {
            ret = false;
            if (n.getNodeType() == OptNode.NodeType.PARFOR) {
                ProgramBlock pfpb = OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(n.getID());
                boolean bl = ret = parfor == pfpb;
            }
            if (ret || n.isLeaf()) break block2;
            for (OptNode c : n.getChilds()) {
                if (ret |= this.rContainsNode(c, parfor)) break;
            }
        }
        return ret;
    }

    protected HashSet<ParForProgramBlock> rGetAllParForPBs(OptNode n, HashSet<ParForProgramBlock> pbs) {
        if (n.getNodeType() == OptNode.NodeType.PARFOR) {
            ParForProgramBlock pfpb = (ParForProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProgramBlock(n.getID());
            pbs.add(pfpb);
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rGetAllParForPBs(c, pbs);
            }
        }
        return pbs;
    }

    protected void rReplaceFunctionNames(OptNode n, String oldName, String newName) {
        if (n.getNodeType() == OptNode.NodeType.FUNCCALL) {
            FunctionOp fop = (FunctionOp)OptTreeConverter.getAbstractPlanMapping().getMappedHop(n.getID());
            String[] names = n.getParam(OptNode.ParamType.OPSTRING).split("::");
            String fnamespace = names[0];
            String fname = names[1];
            if (fname.equals(oldName) || fname.equals(newName)) {
                n.addParam(OptNode.ParamType.OPSTRING, DMLProgram.constructFunctionKey(fnamespace, newName));
                long parentID = OptTreeConverter.getAbstractPlanMapping().getMappedParentID(n.getID());
                BasicProgramBlock pb = (BasicProgramBlock)OptTreeConverter.getAbstractPlanMapping().getMappedProg(parentID)[1];
                ArrayList<Instruction> instArr = pb.getInstructions();
                for (int i = 0; i < instArr.size(); ++i) {
                    FunctionCallCPInstruction fci;
                    Instruction inst = instArr.get(i);
                    if (!(inst instanceof FunctionCallCPInstruction) || !oldName.equals((fci = (FunctionCallCPInstruction)inst).getFunctionName())) continue;
                    instArr.set(i, FunctionCallCPInstruction.parseInstruction(fci.toString().replaceAll(oldName, newName)));
                }
                if (fop.getFunctionName().equals(oldName)) {
                    fop.setFunctionName(newName);
                }
            }
        }
        if (!n.isLeaf()) {
            for (OptNode c : n.getChilds()) {
                this.rReplaceFunctionNames(c, oldName, newName);
            }
        }
    }

    protected int removeRecursiveParFor(OptNode n, HashSet<ParForProgramBlock> recPBs) {
        int count = 0;
        if (!n.isLeaf()) {
            for (OptNode sub : n.getChilds()) {
                if (sub.getNodeType() == OptNode.NodeType.PARFOR) {
                    long id = sub.getID();
                    Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
                    ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
                    ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
                    if (recPBs.contains(pfpb)) {
                        Program prog = pfpb.getProgram();
                        ForProgramBlock fpb = ProgramConverter.createShallowCopyForProgramBlock(pfpb, prog);
                        OptTreeConverter.replaceProgramBlock(n, sub, pfpb, fpb, false);
                        fpb.setStatementBlock(pfsb);
                        sub.setNodeType(OptNode.NodeType.FOR);
                        sub.setK(1);
                        ++count;
                    }
                }
                count += this.removeRecursiveParFor(sub, recPBs);
            }
        }
        return count;
    }

    protected void rewriteRemoveUnnecessaryParFor(OptNode n) {
        int count = this.removeUnnecessaryParFor(n);
        ++this._numEvaluatedPlans;
        LOG.debug((Object)((Object)((Object)this.getOptMode()) + " OPT: rewrite 'remove unnecessary parfor' - result=" + count));
    }

    protected int removeUnnecessaryParFor(OptNode n) {
        int count = 0;
        if (!n.isLeaf()) {
            for (OptNode sub : n.getChilds()) {
                if (sub.getNodeType() == OptNode.NodeType.PARFOR && sub.getK() == 1) {
                    long id = sub.getID();
                    Object[] progobj = OptTreeConverter.getAbstractPlanMapping().getMappedProg(id);
                    ParForStatementBlock pfsb = (ParForStatementBlock)progobj[0];
                    ParForProgramBlock pfpb = (ParForProgramBlock)progobj[1];
                    Program prog = pfpb.getProgram();
                    ForProgramBlock fpb = ProgramConverter.createShallowCopyForProgramBlock(pfpb, prog);
                    OptTreeConverter.replaceProgramBlock(n, sub, pfpb, fpb, false);
                    fpb.setStatementBlock(pfsb);
                    sub.setNodeType(OptNode.NodeType.FOR);
                    sub.setK(1);
                    ++count;
                }
                count += this.removeUnnecessaryParFor(sub);
            }
        }
        return count;
    }

    public static String toMB(double inB) {
        return OptimizerUtils.toMB(inB) + "MB";
    }
}

