/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class CompressedSizeEstimator {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimator.class.getName());
    protected MatrixBlock _data;
    protected final int _numRows;
    protected final int _numCols;
    protected final CompressionSettings _compSettings;

    protected CompressedSizeEstimator(MatrixBlock data, CompressionSettings compSettings) {
        this._data = data;
        this._numRows = compSettings.transposeInput ? this._data.getNumColumns() : this._data.getNumRows();
        this._numCols = compSettings.transposeInput ? this._data.getNumRows() : this._data.getNumColumns();
        this._compSettings = compSettings;
    }

    public CompressedSizeInfo computeCompressedSizeInfos(int k) {
        CompressedSizeInfoColGroup[] sizeInfos = this.estimateIndividualColumnGroupSizes(k);
        return this.computeCompressedSizeInfos(sizeInfos);
    }

    private CompressedSizeInfo computeCompressedSizeInfos(CompressedSizeInfoColGroup[] sizeInfos) {
        ArrayList<Integer> colsC = new ArrayList<Integer>();
        ArrayList<Integer> colsUC = new ArrayList<Integer>();
        HashMap<Integer, Double> compRatios = new HashMap<Integer, Double>();
        double unCompressedDenseSize = ColGroupSizes.estimateInMemorySizeUncompressed(this._numCols, this._numRows, 1.0);
        int nnzUCSum = 0;
        for (int col = 0; col < this._numCols; ++col) {
            double minCompressedSize = sizeInfos[col].getMinSize();
            double compRatio = unCompressedDenseSize / minCompressedSize;
            compRatios.put(col, compRatio);
            if (sizeInfos[col].getBestCompressionType() == ColGroup.CompressionType.UNCOMPRESSED) {
                colsUC.add(col);
                nnzUCSum += sizeInfos[col].getEstNnz();
                continue;
            }
            colsC.add(col);
            compRatios.put(col, compRatio);
        }
        return new CompressedSizeInfo(sizeInfos, colsC, colsUC, compRatios, nnzUCSum);
    }

    private CompressedSizeInfoColGroup[] estimateIndividualColumnGroupSizes(int k) {
        return k > 1 ? this.CompressedSizeInfoColGroup(this._numCols, k) : this.CompressedSizeInfoColGroup(this._numCols);
    }

    public CompressedSizeInfoColGroup estimateCompressedColGroupSize() {
        int[] colIndexes = this.makeColIndexes();
        return this.estimateCompressedColGroupSize(colIndexes);
    }

    public abstract CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] var1);

    public EstimationFactors estimateCompressedColGroupSize(ABitmap ubm) {
        return EstimationFactors.computeSizeEstimationFactors(ubm, this._compSettings.validCompressions.contains((Object)ColGroup.CompressionType.RLE), this._numRows, ubm.getNumColumns());
    }

    private CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen) {
        CompressedSizeInfoColGroup[] ret = new CompressedSizeInfoColGroup[clen];
        for (int col = 0; col < clen; ++col) {
            ret[col] = this.estimateCompressedColGroupSize(new int[]{col});
        }
        return ret;
    }

    private CompressedSizeInfoColGroup[] CompressedSizeInfoColGroup(int clen, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>();
            for (int col = 0; col < clen; ++col) {
                tasks.add(new SizeEstimationTask(this, col));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList ret = new ArrayList();
            for (Future lrtask : rtask) {
                ret.add(lrtask.get());
            }
            pool.shutdown();
            return ret.toArray(new CompressedSizeInfoColGroup[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            return this.CompressedSizeInfoColGroup(clen);
        }
    }

    private int[] makeColIndexes() {
        int[] colIndexes = new int[this._numCols];
        for (int i = 0; i < this._numCols; ++i) {
            colIndexes[i] = i;
        }
        return colIndexes;
    }

    private static class SizeEstimationTask
    implements Callable<CompressedSizeInfoColGroup> {
        private final CompressedSizeEstimator _estimator;
        private final int _col;

        protected SizeEstimationTask(CompressedSizeEstimator estimator, int col) {
            this._estimator = estimator;
            this._col = col;
        }

        @Override
        public CompressedSizeInfoColGroup call() {
            return this._estimator.estimateCompressedColGroupSize(new int[]{this._col});
        }
    }
}

