/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Script;

public class Test
extends Script {
    public Test() {
        String string = "scripts/nn/test/test.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public void top_k2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::top_k2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String top_k2d__docs() {
        String string = "top_k2d = function() {\n  /*\n   * Test for the top_k2d function.\n  */\n";
        return string;
    }

    public String top_k2d__source() {
        String string = "top_k2d = function() {\n  /*\n   * Test for the top_k2d function.\n  */\n  print(\"Testing the top_k2d function.\")\n  # Generate data, of shape (2, 3, 3, 4)\n  k = 2\n  X = matrix(\"0.1 0.4 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.7 0.3 0.2\n\n              0.2 0.5 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.8 0.3 0.2\n\n              0.3 0.4 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.2 0.3 0.2\n\n              0.1 0.4 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.7 0.3 0.2\n\n              0.2 0.5 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.8 0.3 0.2\n\n              0.3 0.4 0.4 0.5\n              0.4 0.1 0.6 0.1\n              0.7 0.2 0.3 0.2\", rows=2, cols=3*3*4)\n\n  expected_values = matrix(\"0.3  0.5  0.4  0.5\n                            0.4  0.1  0.6  0.1\n                            0.7  0.8  0.3  0.2\n\n                            0.2  0.4  0.4  0.5\n                            0.4  0.1  0.6  0.1\n                            0.7  0.7  0.3  0.2\n\n                            0.3  0.5  0.4  0.5\n                            0.4  0.1  0.6  0.1\n                            0.7  0.8  0.3  0.2\n\n                            0.2  0.4  0.4  0.5\n                            0.4  0.1  0.6  0.1\n                            0.7  0.7  0.3  0.2\", rows=2, cols=2*3*4)\n\n  expected_indices = matrix(\"3  2  1  1\n                             1  1  1  1\n                             1  2  1  1\n\n                             2  1  2  2\n                             2  2  2  2\n                             2  1  2  2\n\n                             3  2  1  1\n                             1  1  1  1\n                             1  2  1  1\n\n                             2  1  2  2\n                             2  2  2  2\n                             2  1  2  2\", rows=2, cols=24)\n\n  [values, indices] = util::top_k2d(X, k, 3, 3, 4)\n\n  # Equivalency check\n  check_values = test_util::check_all_equal(values, expected_values)\n  check_indices = test_util::check_all_equal(indices, expected_indices)\n}\n";
        return string;
    }

    public void padding() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::padding();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String padding__docs() {
        String string = "padding = function() {\n  /*\n   * Test for the `pad_image` and `unpad_image` functions.\n   */\n";
        return string;
    }

    public String padding__source() {
        String string = "padding = function() {\n  /*\n   * Test for the `pad_image` and `unpad_image` functions.\n   */\n  print(\"Testing the padding and unpadding functions.\")\n\n  # Generate data\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  pad = 3  # padding\n  x = rand(rows=C, cols=Hin*Win)\n\n  # Pad image\n  x_pad = util::pad_image(x, Hin, Win, pad, pad, 0)\n\n  # Check for padded rows & columns\n  for (c in 1:C) {\n    x_pad_slice = matrix(x_pad[c,], rows=Hin+2*pad, cols=Win+2*pad)\n    for (i in 1:pad) {\n      rowsum = sum(x_pad_slice[i,])\n      colsum = sum(x_pad_slice[,i])\n      if (rowsum != 0)\n        print(\"ERROR: Padding was not applied to row \" + i + \".\")\n      if (colsum != 0)\n        print(\"ERROR: Padding was not applied to column \" + i + \".\")\n    }\n  }\n\n  # Unpad image\n  x1 = util::unpad_image(x_pad, Hin, Win, pad, pad)\n\n  # Equivalency check\n  equivalent = test_util::all_equal(x, x1)\n  if (!equivalent) {\n    print(\"ERROR: Padding and then unpadding does not yield the original image.\")\n  }\n}\n";
        return string;
    }

    public void cross_entropy_loss2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::cross_entropy_loss2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String cross_entropy_loss2d__docs() {
        String string = "cross_entropy_loss2d = function() {\n  /*\n   * Test for the 2D cross-entropy loss function.\n   */\n";
        return string;
    }

    public String cross_entropy_loss2d__source() {
        String string = "cross_entropy_loss2d = function() {\n  /*\n   * Test for the 2D cross-entropy loss function.\n   */\n  print(\"Testing the 2D cross-entropy loss function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num targets\n  Hin = 3  # example height\n  Win = 3  # example width\n  loss_expected = 0.0770996\n\n  # pred data after the softmax\n  pred = matrix(\"9.99909163e-01   4.99988675e-01   4.53958055e-05\n                 9.99909163e-01   4.53958055e-05   4.53958055e-05\n                 9.99909163e-01   4.53958055e-05   4.53958055e-05\n                 4.53958055e-05   4.99988675e-01   4.53958055e-05\n                 4.53958055e-05   9.99909163e-01   4.53958055e-05\n                 4.53958055e-05   9.99909163e-01   4.53958055e-05\n                 4.53958055e-05   2.26994507e-05   9.99909163e-01\n                 4.53958055e-05   4.53958055e-05   9.99909163e-01\n                 4.53958055e-05   4.53958055e-05   9.99909163e-01\n                 9.99909163e-01   4.99988675e-01   4.53958055e-05\n                 9.99909163e-01   4.53958055e-05   4.53958055e-05\n                 9.99909163e-01   4.53958055e-05   4.53958055e-05\n                 4.53958055e-05   4.99988675e-01   4.53958055e-05\n                 4.53958055e-05   9.99909163e-01   4.53958055e-05\n                 4.53958055e-05   9.99909163e-01   4.53958055e-05\n                 4.53958055e-05   2.26994507e-05   9.99909163e-01\n                 4.53958055e-05   4.53958055e-05   9.99909163e-01\n                 4.53958055e-05   4.53958055e-05   9.99909163e-01\", rows=N, cols=C*Hin*Win)\n  y = matrix(\"1 0 0\n              1 0 0\n              1 0 0\n              0 1 0\n              0 1 0\n              0 1 0\n              0 0 1\n              0 0 1\n              0 0 1\n              1 0 0\n              1 0 0\n              1 0 0\n              0 1 0\n              0 1 0\n              0 1 0\n              0 0 1\n              0 0 1\n              0 0 1\", rows=N, cols=C*Hin*Win)\n\n  loss = cross_entropy_loss2d::forward(pred, y, C)\n\n  # Equivalency check\n  rel_error = test_util::check_rel_error(loss, loss_expected, 1e-3, 1e-4)\n}\n";
        return string;
    }

    public void compare_tanh_builtin_backward_with_old() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::compare_tanh_builtin_backward_with_old();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String compare_tanh_builtin_backward_with_old__docs() {
        String string = "compare_tanh_builtin_backward_with_old = function() {\n  /*\n   * Test for the `tanh` backward function.\n   */\n";
        return string;
    }

    public String compare_tanh_builtin_backward_with_old__source() {
        String string = "compare_tanh_builtin_backward_with_old = function() {\n  /*\n   * Test for the `tanh` backward function.\n   */\n  print(\"Testing the tanh backward function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  X = rand(rows=N, cols=C, pdf=\"normal\")\n  dout = rand(rows=N, cols=C, pdf=\"normal\")\n\n  sigma2X = sigmoid::forward(2*X)\n  out = 2*sigma2X - 1\n  out_ref = (1-out^2) * dout\n\n  out = tanh::backward(dout, X)\n\n  # Equivalency check\n  for (i in 1:nrow(out)) {\n    for (j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]), as.scalar(out_ref[i,j]),\n                                             1e-10, 1e-12)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_transpose() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::conv2d_transpose();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_transpose__docs() {
        String string = "conv2d_transpose = function() {\n  /*\n   * Test for the 2D transpose convolution function.\n   */\n";
        return string;
    }

    public String conv2d_transpose__source() {
        String string = "conv2d_transpose = function() {\n  /*\n   * Test for the 2D transpose convolution function.\n   */\n  print(\"Testing the 2D transpose convolution function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 2  # input height\n  Win = 2  # input width\n  F = 2  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 0\n  out_pad = 0  # padding added to output\n  X = matrix(seq(1,N*C*Hin*Win), rows=N, cols=C*Hin*Win) / (N*C*Hin*Win) * 2 - 1  # normalized\n\n  # Create layer\n  W = matrix(seq(1,C*F*Hf*Wf), rows=C, cols=F*Hf*Wf) / (C*F*Hf*Wf) * 2 - 1  # normalized\n  b = matrix(seq(1,F), rows=F, cols=1) / F^2  # non-zero & non-one\n\n  # Forward\n  [out, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                pad, pad, out_pad, out_pad)\n\n  # Equivalency check\n  target = matrix(\"1.21296299  2.03703713  1.91666663  1.02777779\n                   1.83333337  3.18518519  2.98148131  1.52777767\n                   1.5         2.57407403  2.37037039  1.24999988\n                   0.78703707  1.25925922  1.17592585  0.69444442\n\n                   0.87962961  1.20370364  1.08333337  0.77777773\n                   1.08333337  1.60185182  1.39814818  0.94444442\n                   0.75        0.99074072  0.78703701  0.66666657\n                   0.62037039  0.75925928  0.67592591  0.6111111\n\n\n                   0.32407406  0.37037039  0.47222221  0.36111113\n                   0.38888881  0.51851851  0.75925928  0.52777779\n                   0.72222215  1.24074078  1.48148155  0.91666669\n                   0.56481475  0.92592585  1.06481469  0.69444442\n\n                   0.99074078  1.53703713  1.63888896  1.11111116\n                   1.63888884  2.93518519  3.17592597  1.94444442\n                   1.97222221  3.65740728  3.89814806  2.33333325\n                   1.39814818  2.42592597  2.56481481  1.61111116\", rows=N, cols=F*Hout*Wout)\n\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n                                             as.scalar(target[i,j]), 1e-3, 1e-4)\n    }\n  }\n}\n";
        return string;
    }

    public void threshold() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::threshold();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String threshold__docs() {
        String string = "threshold = function() {\n  /*\n   * Test for the threshold function.\n   */\n";
        return string;
    }

    public String threshold__source() {
        String string = "threshold = function() {\n  /*\n   * Test for the threshold function.\n   */\n  print(\"Testing the threshold function.\")\n\n  # Generate data\n  X = matrix(\"0.31 0.24 0.87\n              0.45 0.66 0.65\n              0.24 0.91 0.13\", rows=3, cols=3)\n  thresh = 0.5\n  target_matrix = matrix(\"0.0 0.0 1.0\n                          0.0 1.0 1.0\n                          0.0 1.0 0.0\", rows=3, cols=3)\n\n  # Get the indicator matrix\n  indicator_matrix = util::threshold(X, thresh)\n\n  # Equivalency check\n  out = test_util::check_all_equal(indicator_matrix, target_matrix)\n}\n";
        return string;
    }

    public void batch_norm2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::batch_norm2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String batch_norm2d__docs() {
        String string = "batch_norm2d = function() {\n  /*\n   * Test for the 2D (spatial) batch normalization function.\n   */\n";
        return string;
    }

    public String batch_norm2d__source() {
        String string = "batch_norm2d = function() {\n  /*\n   * Test for the 2D (spatial) batch normalization function.\n   */\n  print(\"Testing the 2D (spatial) batch normalization function.\")\n\n  # Generate data\n  N = 2  # Number of examples\n  C = 3  # num channels\n  Hin = 4  # input height\n  Win = 5  # input width\n  mode = 'train'  # execution mode\n  mu = 0.9  # momentum of moving averages\n  eps = 1e-5  # smoothing term\n  X = matrix(\"70  29 23 55 72\n              42  98 68 48 39\n              34  73 44  6 40\n              74  18 18 53 53\n\n              63  85 72 61 72\n              32  36 23 29 63\n               9  43 43 49 43\n              31  43 89 94 50\n\n              62  12 32 41 87\n              25  48 99 52 61\n              12  83 60 55 34\n              30  42 68 88 51\n\n\n              67  59 62 67 84\n               8  76 24 19 57\n              10  89 63 72  2\n              59  56 16 15 70\n\n              32  69 55 39 93\n              84  36  4 30 40\n              70 100 36 76 59\n              69  15 40 24 34\n\n              51  67 11 13 32\n              66  85 55 85 38\n              32  35 17 83 34\n              55  58 52  0 99\", rows=N, cols=C*Hin*Win)\n\n  # Create layer\n  [gamma, beta, ema_mean, ema_var] = batch_norm2d::init(C)\n\n  # Forward\n  [out, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n      batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n\n  # Equivalency check\n  target = matrix(\"0.86215019 -0.76679718 -1.00517964  0.26619387  0.94161105\n                  -0.25030172  1.97460198  0.78268933 -0.01191914 -0.36949289\n                  -0.56814504  0.98134136 -0.17084086 -1.68059683 -0.32976246\n                   1.02107191 -1.20383179 -1.20383179  0.18673301  0.18673301\n\n                   0.50426388  1.41921711  0.87856293  0.42108631  0.87856293\n                  -0.78498828 -0.61863315 -1.15928721 -0.90975463  0.50426388\n                  -1.74153018 -0.32751167 -0.32751167 -0.07797909 -0.32751167\n                  -0.82657707 -0.32751167  1.58557224  1.79351616 -0.0363903\n\n                   0.4607178  -1.49978399 -0.71558321 -0.36269283  1.44096887\n                  -0.99005347 -0.08822262  1.91148913  0.06861746  0.42150795\n                  -1.49978399  1.28412855  0.38229787  0.18624771 -0.63716316\n                  -0.79400325 -0.32348287  0.69597805  1.48017895  0.0294075\n\n\n                   0.74295878  0.42511559  0.54430676  0.74295878  1.41837597\n                  -1.60113597  1.10053277 -0.96544927 -1.16410136  0.34565473\n                  -1.52167511  1.61702824  0.5840373   0.94161105 -1.83951855\n                   0.42511559  0.30592418 -1.28329265 -1.32302308  0.86215019\n\n                  -0.78498828  0.75379658  0.17155361 -0.4938668   1.75192738\n                   1.37762833 -0.61863315 -1.9494741  -0.86816585 -0.45227802\n                   0.79538536  2.04304862 -0.61863315  1.04491806  0.33790874\n                   0.75379658 -1.49199748 -0.45227802 -1.11769855 -0.70181072\n\n                   0.0294075   0.65676796 -1.53899395 -1.46057391 -0.71558321\n                   0.61755812  1.36254871  0.18624771  1.36254871 -0.48032296\n                  -0.71558321 -0.59795308 -1.30373383  1.28412855 -0.63716316\n                   0.18624771  0.30387771  0.06861746 -1.97030437  1.91148913\",\n                  rows=1, cols=N*C*Hin*Win)\n  out = matrix(out, rows=1, cols=N*C*Hin*Win)\n  for (i in 1:length(out)) {\n    rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                           as.scalar(target[1,i]), 1e-3, 1e-4)\n  }\n}\n";
        return string;
    }

    public void compare_tanh_builtin_forward_with_old() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::compare_tanh_builtin_forward_with_old();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String compare_tanh_builtin_forward_with_old__docs() {
        String string = "compare_tanh_builtin_forward_with_old = function() {\n  /*\n   * Test for the `tanh` forward function.\n   */\n";
        return string;
    }

    public String compare_tanh_builtin_forward_with_old__source() {
        String string = "compare_tanh_builtin_forward_with_old = function() {\n  /*\n   * Test for the `tanh` forward function.\n   */\n  print(\"Testing the tanh forward function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  X = rand(rows=N, cols=C, pdf=\"normal\")\n\n  out = tanh::forward(X)\n\n  sigma2X = sigmoid::forward(2*X)\n  out_ref = 2*sigma2X - 1\n\n  # Equivalency check\n  for (i in 1:nrow(out)) {\n    for (j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]), as.scalar(out_ref[i,j]),\n                                             1e-10, 1e-12)\n    }\n  }\n}\n";
        return string;
    }

    public void batch_norm1d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::batch_norm1d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String batch_norm1d__docs() {
        String string = "batch_norm1d = function() {\n  /*\n   * Test for the 1D batch normalization function.\n   */\n";
        return string;
    }

    public String batch_norm1d__source() {
        String string = "batch_norm1d = function() {\n  /*\n   * Test for the 1D batch normalization function.\n   */\n  print(\"Testing the 1D batch normalization function.\")\n\n  # Generate data\n  N = 4  # Number of examples\n  D = 4  # Number of features\n  mode = 'train'  # execution mode\n  mu = 0.9  # momentum of moving averages\n  eps = 1e-5  # smoothing term\n  X = matrix(seq(1,16), rows=N, cols=D)\n\n  # Create layer\n  [gamma, beta, ema_mean, ema_var] = batch_norm1d::init(D)\n\n  # Forward\n  [out, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n      batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n\n  # Equivalency check\n  target = matrix(\"-1.34160721 -1.34160721 -1.34160733 -1.34160709\n                   -0.44720244 -0.44720244 -0.44720244 -0.44720232\n                    0.44720244  0.44720232  0.44720244  0.44720244\n                    1.34160733  1.34160721  1.34160733  1.34160733\", rows=1, cols=N*D)\n  out = matrix(out, rows=1, cols=N*D)\n  for (i in 1:length(out)) {\n    rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                           as.scalar(target[1,i]), 1e-3, 1e-4)\n  }\n}\n";
        return string;
    }

    public void conv2d_transpose_depthwise() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::conv2d_transpose_depthwise();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_transpose_depthwise__docs() {
        String string = "conv2d_transpose_depthwise = function() {\n  /*\n   * Test for the 2D depthwise transpose convolution function.\n   */\n";
        return string;
    }

    public String conv2d_transpose_depthwise__source() {
        String string = "conv2d_transpose_depthwise = function() {\n  /*\n   * Test for the 2D depthwise transpose convolution function.\n   */\n  print(\"Testing the 2D depthwise transpose convolution function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 4  # num channels\n  Hin = 2  # input height\n  Win = 2  # input width\n  M = 2  # depth of each filter\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 0\n  out_pad = 0  # padding added to output\n  X = matrix(seq(1,N*C*Hin*Win), rows=N, cols=C*Hin*Win) / (N*C*Hin*Win) * 2 - 1  # normalized\n\n  # Create layer\n  W = matrix(seq(1,C/M*M*Hf*Wf), rows=C/M, cols=M*Hf*Wf) / (C/M*M*Hf*Wf) * 2 - 1  # normalized\n  b = matrix(seq(1,C/M), rows=C/M, cols=1) / (C/M)^2  # non-zero & non-one\n\n  # Forward\n  [out, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                          stride, stride, pad, pad,\n                                                          out_pad, out_pad)\n\n  # Equivalency check\n  target = matrix(\"1.44097221  2.45486116  2.28125     1.1875\n                   2.1875      3.80555558  3.48611116  1.72916663\n                   1.6875      2.84722233  2.52777767  1.27083325\n                   0.80902779  1.24652779  1.10069442  0.625\n\n                   0.37152776  0.24652773  0.18402778  0.35416669\n                   0.21527778 -0.02777781 -0.12500003  0.22916666\n                   0.04861115 -0.31944442 -0.41666669  0.10416666\n                   0.32291669  0.20486113  0.1701389   0.375\n\n\n                   0.05208334 -0.21180555 -0.16319445  0.02083334\n                  -0.25694442 -0.8611111  -0.7361111  -0.27083331\n                  -0.09027778 -0.4861111  -0.3611111  -0.0625\n                   0.08680556 -0.08680557 -0.01041669  0.125\n\n                   0.98263896  1.57986116  1.73958337  1.1875\n                   1.77083337  3.30555558  3.65277791  2.22916675\n                   2.27083325  4.34722233  4.69444466  2.77083349\n                   1.60069442  2.87152767  3.05902767  1.875     \", rows=N, cols=C/M*Hout*Wout)\n\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n                                             as.scalar(target[i,j]), 1e-3, 1e-4)\n    }\n  }\n}\n";
        return string;
    }

    public void elu() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::elu();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String elu__docs() {
        String string = "elu = function() {\n  /*\n   * Test for ELU function.\n   */\n";
        return string;
    }

    public String elu__source() {
        String string = "elu = function() {\n  /*\n   * Test for ELU function.\n   */\n  print(\"Testing ELU function.\")\n\n  X = matrix(\"0.3923 -0.2236 -0.3195 -1.2050  1.0445 -0.6332  0.5731  0.5409 -0.3919 -1.0427\", rows = 10, cols = 1)\n\n  print(\" - Testing forward\")\n  out = elu::forward(X, 1)\n  out_ref = matrix(\"0.3923 -0.2003 -0.2735 -0.7003  1.0445 -0.4691  0.5731  0.5409 -0.3242 -0.6475\", rows = 10, cols = 1)\n\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n          as.scalar(out_ref[i,j]), 1e-3, 1e-3)\n    }\n  }\n\n  print(\" - Testing backward\")\n  out = elu::backward(X, X, 1)\n  out_ref = matrix(\"0.3923 -0.1788 -0.2321 -0.3611  1.0445 -0.3362  0.5731  0.5409 -0.2648 -0.3676\", rows = 10, cols = 1)\n\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n          as.scalar(out_ref[i,j]), 1e-3, 1e-3)\n    }\n  }\n}\n";
        return string;
    }

    public void cross_entropy_loss() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::cross_entropy_loss();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String cross_entropy_loss__docs() {
        String string = "cross_entropy_loss = function() {\n  /*\n   * Test for the cross-entropy loss function.\n   *\n   * Here we make sure that the cross-entropy loss function does\n   * not propagate `infinity` values in the case that a prediction is\n`  * exactly equal to 0.\n   */\n";
        return string;
    }

    public String cross_entropy_loss__source() {
        String string = "cross_entropy_loss = function() {\n  /*\n   * Test for the cross-entropy loss function.\n   *\n   * Here we make sure that the cross-entropy loss function does\n   * not propagate `infinity` values in the case that a prediction is\n`  * exactly equal to 0.\n   */\n  print(\"Testing the cross-entropy loss function with zero-valued predictions.\")\n\n  # Generate data\n  N = 3 # num examples\n  K = 10 # num targets\n  pred = matrix(0, rows=N, cols=K)\n  y = rand(rows=N, cols=K, min=0, max=1, pdf=\"uniform\")\n  y = y / rowSums(y)  # normalized probs\n\n  loss = cross_entropy_loss::forward(pred, y)\n\n  inf = 1/0\n  if (loss == inf) {\n    print(\"ERROR: The cross-entropy loss function ouptuts infinity for all-zero predictions.\")\n  }\n}\n";
        return string;
    }

    public void tanh() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::tanh();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String tanh__docs() {
        String string = "tanh = function() {\n  /*\n   * Test for the `tanh` forward function.\n   */\n";
        return string;
    }

    public String tanh__source() {
        String string = "tanh = function() {\n  /*\n   * Test for the `tanh` forward function.\n   */\n  print(\"Testing the tanh forward function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  X = rand(rows=N, cols=C, pdf=\"normal\")\n\n  out = tanh::forward(X)\n  out_ref = (exp(X) - exp(-X)) / (exp(X) + exp(-X))\n\n  # Equivalency check\n  for (i in 1:nrow(out)) {\n    for (j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]), as.scalar(out_ref[i,j]),\n                                             1e-10, 1e-12)\n    }\n  }\n}\n";
        return string;
    }

    public void max_pool2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::max_pool2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String max_pool2d__docs() {
        String string = "max_pool2d = function() {\n  /*\n   * Test for the 2D max pooling functions.\n   */\n";
        return string;
    }

    public String max_pool2d__source() {
        String string = "max_pool2d = function() {\n  /*\n   * Test for the 2D max pooling functions.\n   */\n  print(\"Testing the 2D max pooling functions.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 8  # input height\n  Win = 8  # input width\n  Hf = 2  # filter height\n  Wf = 2  # filter width\n  stride = 2\n  X = rand(rows=N, cols=C*Hin*Win, pdf=\"normal\")\n\n  for (padh in 0:3) {\n    for (padw in 0:3) {\n      print(\" - Testing w/ padh=\"+padh+\" & padw=\"+padw+\".\")\n      #while(FALSE){}  # force correct printing\n      #print(\"   - Testing forward\")\n      [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, padh, padw)\n      [out_simple, Hout_simple, Wout_simple] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf,\n                                                                          stride, stride,\n                                                                          padh, padw)\n      [out_builtin, Hout_builtin, Wout_builtin] = max_pool2d_builtin::forward(X, C, Hin, Win,\n                                                                              Hf, Wf,\n                                                                              stride, stride,\n                                                                              padh, padw)\n\n      # Equivalency check\n      out = matrix(out, rows=1, cols=N*C*Hout*Wout)\n      out_simple = matrix(out_simple, rows=1, cols=N*C*Hout*Wout)\n      out_builtin = matrix(out_builtin, rows=1, cols=N*C*Hout*Wout)\n      for (i in 1:length(out)) {\n        rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                               as.scalar(out_simple[1,i]), 1e-10, 1e-12)\n        rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                               as.scalar(out_builtin[1,i]), 1e-10, 1e-12)\n      }\n\n      #print(\"   - Testing backward\")\n      dout = rand(rows=N, cols=C*Hout*Wout, pdf=\"normal\")\n      dX = max_pool2d::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, stride, stride,\n                                padh, padw)\n      dX_simple = max_pool2d_simple::backward(dout, Hout_simple, Wout_simple, X, C, Hin, Win,\n                                              Hf, Wf, stride, stride, padh, padw)\n      dX_builtin = max_pool2d_builtin::backward(dout, Hout_builtin, Wout_builtin, X, C, Hin, Win,\n                                                Hf, Wf, stride, stride, padh, padw)\n\n      # Equivalency check\n      dX = matrix(dX, rows=1, cols=N*C*Hin*Win)\n      dX_simple = matrix(dX_simple, rows=1, cols=N*C*Hin*Win)\n      dX_builtin = matrix(dX_builtin, rows=1, cols=N*C*Hin*Win)\n      for (i in 1:length(dX)) {\n        rel_error = test_util::check_rel_error(as.scalar(dX[1,i]),\n                                               as.scalar(dX_simple[1,i]), 1e-10, 1e-12)\n        rel_error = test_util::check_rel_error(as.scalar(dX[1,i]),\n                                               as.scalar(dX_builtin[1,i]), 1e-10, 1e-12)\n      }\n    }\n  }\n\n  # ---\n  print(\" - Testing for correct behavior against known answer w/ pad=0.\")\n  # generate data\n  # -- channel 1\n  #  1  2  3  4\n  #  5  6  7  8\n  #  9 10 11 12\n  # 13 14 15 16\n  # -- channel 2\n  #  1  5  9 13\n  #  2  6 10 14\n  #  3  7 11 15\n  #  4  8 12 16\n  C = 2  # num channels\n  Hin = 4  # input height\n  Win = 4  # input width\n  X = matrix(seq(1,16,1), rows=Hin, cols=Win)\n  X = matrix(rbind(X, t(X)), rows=1, cols=C*Hin*Win)  # C=2\n  X = rbind(X, X)  # n=2\n  pad = 0\n\n  # forward\n  [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  [out_simple, Hout_simple, Wout_simple] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf,\n                                                                      stride, stride, pad, pad)\n  [out_builtin, Hout_builtin, Wout_builtin] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf,\n                                                                          stride, stride, pad, pad)\n\n  # equivalency check\n  # -- channel 1\n  #   6  8\n  #  14 16\n  # -- channel 2\n  #  6  14\n  #  8  16\n  target = matrix(\"6 8 14 16 6 14 8 16\", rows=1, cols=C*Hout*Wout)\n  target = rbind(target, target)  # n=2\n  tmp = test_util::check_all_equal(out, target)\n  tmp = test_util::check_all_equal(out_simple, target)\n  tmp = test_util::check_all_equal(out_builtin, target)\n\n  print(\" - Testing for correct behavior against known answer w/ pad=1.\")\n  # generate data\n  # -- channel 1\n  #  0  0  0  0  0  0\n  #  0  1  2  3  4  0\n  #  0  5  6  7  8  0\n  #  0  9 10 11 12  0\n  #  0 13 14 15 16  0\n  #  0  0  0  0  0  0\n  # -- channel 2\n  #  0  0  0  0  0  0\n  #  0  1  5  9 13  0\n  #  0  2  6 10 14  0\n  #  0  3  7 11 15  0\n  #  0  4  8 12 16  0\n  #  0  0  0  0  0  0\n  pad = 1\n\n  # forward\n  [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  [out_simple, Hout_simple, Wout_simple] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf,\n                                                                      stride, stride, pad, pad)\n  [out_builtin, Hout_builtin, Wout_builtin] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf,\n                                                                          stride, stride, pad, pad)\n\n  # equivalency check\n  # -- channel 1\n  #  1  3  4\n  #  9 11 12\n  # 13 15 16\n  # -- channel 2\n  #  1  9 13\n  #  3 11 15\n  #  4 12 16\n  target = matrix(\"1 3 4 9 11 12 13 15 16 1 9 13 3 11 15 4 12 16\", rows=1, cols=C*Hout*Wout)\n  target = rbind(target, target)  # n=2\n  tmp = test_util::check_all_equal(out, target)\n  tmp = test_util::check_all_equal(out_simple, target)\n  tmp = test_util::check_all_equal(out_builtin, target)\n\n  print(\" - Testing for correct behavior against known answer w/ all negative matrix w/ pad=0.\")\n  # generate data\n  # -- channel 1\n  #  -1  -2  -3  -4\n  #  -5  -6  -7  -8\n  #  -9 -10 -11 -12\n  # -13 -14 -15 -16\n  # -- channel 2\n  #  -1  -5  -9 -13\n  #  -2  -6 -10 -14\n  #  -3  -7 -11 -15\n  #  -4  -8 -12 -16\n  X = X * -1\n  pad = 0\n\n  # forward\n  [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  [out_simple, Hout_simple, Wout_simple] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf,\n                                                                      stride, stride, pad, pad)\n  [out_builtin, Hout_builtin, Wout_builtin] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf,\n                                                                          stride, stride, pad, pad)\n\n  # equivalency check\n  # -- channel 1\n  #  -1  -3\n  #  -9 -11\n  # -- channel 2\n  #  -1  -9\n  #  -3 -11\n  target = matrix(\"-1 -3 -9 -11 -1 -9 -3 -11\", rows=1, cols=C*Hout*Wout)\n  target = rbind(target, target)  # n=2\n  tmp = test_util::check_all_equal(out, target)\n  tmp = test_util::check_all_equal(out_simple, target)\n  tmp = test_util::check_all_equal(out_builtin, target)\n\n\n  print(\" - Testing for correct behavior against known answer w/ all negative matrix w/ pad=1.\")\n  # generate data\n  # -- channel 1\n  #  0   0   0   0   0  0\n  #  0  -1  -2  -3  -4  0\n  #  0  -5  -6  -7  -8  0\n  #  0  -9 -10 -11 -12  0\n  #  0 -13 -14 -15 -16  0\n  #  0   0   0   0   0  0\n  # -- channel 2\n  #  0   0   0   0   0  0\n  #  0  -1  -5  -9 -13  0\n  #  0  -2  -6 -10 -14  0\n  #  0  -3  -7 -11 -15  0\n  #  0  -4  -8 -12 -16  0\n  #  0   0   0   0   0  0\n  pad = 1\n\n  # forward\n  [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  [out_simple, Hout_simple, Wout_simple] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf,\n                                                                      stride, stride, pad, pad)\n  [out_builtin, Hout_builtin, Wout_builtin] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf,\n                                                                          stride, stride, pad, pad)\n\n  # equivalency check\n  # -- channel 1\n  #  0  0  0\n  #  0 -6  0\n  #  0  0  0\n  # -- channel 2\n  #  0  0  0\n  #  0 -6  0\n  #  0  0  0\n  target = matrix(\"-1 -2 -4 -5 -6 -8 -13 -14 -16 -1 -5 -13 -2 -6 -14 -4 -8 -16\",\n                  rows=1, cols=C*Hout*Wout)\n  target = rbind(target, target)  # n=2\n  tmp = test_util::check_all_equal(out, target)\n  tmp = test_util::check_all_equal(out_simple, target)\n  tmp = test_util::check_all_equal(out_builtin, target)\n}\n";
        return string;
    }

    public void im2col() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::im2col();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String im2col__docs() {
        String string = "im2col = function() {\n  /*\n   * Test for the `im2col` and `col2im` functions.\n   */\n";
        return string;
    }

    public String im2col__source() {
        String string = "im2col = function() {\n  /*\n   * Test for the `im2col` and `col2im` functions.\n   */\n  print(\"Testing the im2col and col2im functions.\")\n\n\t# Generate data\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 2\n  pad = (Hin * stride - Hin + Hf - stride) / 2\n  Hout = as.integer(floor((Hin + 2*pad - Hf)/stride + 1))\n  Wout = as.integer(floor((Win + 2*pad - Wf)/stride + 1))\n  x = rand(rows=C, cols=Hin*Win)\n\n  # pad\n  x_pad = util::pad_image(x, Hin, Win, pad, pad, 0)\n\n  # im2col\n  x_cols = util::im2col(x_pad, Hin+2*pad, Win+2*pad, Hf, Wf, stride, stride)\n\n  if (ncol(x_cols) != Hout*Wout) {\n    print(\"ERROR: im2col does not yield the correct output size: \"\n          + ncol(x_cols)+\" (actual) vs. \"+Hout*Wout+\" (correct).\")\n  }\n\n  # col2im\n  x_pad2 = util::col2im(x_cols, C, Hin+2*pad, Win+2*pad, Hf, Wf, stride, stride, \"none\")\n\n  # Equivalency check\n  equivalent = test_util::all_equal(x_pad, x_pad2)\n  if (!equivalent) {\n    print(\"ERROR: im2col and then col2im does not yield the original image.\")\n  }\n}\n";
        return string;
    }

    public void top_k_row() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::top_k_row();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String top_k_row__docs() {
        String string = "top_k_row = function() {\n  /*\n   * Test for the top_k_row function.\n   */\n";
        return string;
    }

    public String top_k_row__source() {
        String string = "top_k_row = function() {\n  /*\n   * Test for the top_k_row function.\n   */\n  print(\"Testing the top_k_row function.\")\n\n  #Generate data\n  X = matrix(\"2 3 2 1 19 20 31 12 3 4 5 60 9 2\n              3 6 15 18 6 12 1 17 3 0 4 19 1 6\", rows=2, cols=14)\n  r = 2\n  k = 3\n  expected_values = matrix(\"19\n                            18\n                            17\", rows=1, cols=3)\n  expected_indices = matrix(\"12\n                             4\n                             8\", rows=1, cols=3)\n\n  # Test the top 3 for the second row.\n  [values, indices] = util::top_k_row(X, 2, 3)\n  check_values = test_util::check_all_equal(values, expected_values)\n  check_indices = test_util::check_all_equal(indices, expected_indices)\n}\n";
        return string;
    }

    public void top_k() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::top_k();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String top_k__docs() {
        String string = "top_k = function() {\n   /*\n    * Test for the top_k function.\n   */\n";
        return string;
    }

    public String top_k__source() {
        String string = "top_k = function() {\n   /*\n    * Test for the top_k function.\n   */\n   print(\"Testing the top_k function.\")\n\n   # Generate data\n   X = matrix(\"0.1 0.3 0.2 0.4\n               0.1 0.3 0.3 0.2\", rows=2, cols=4)\n   expected_values_top1 = matrix(\"0.4\n                                  0.3\", rows=2, cols=1)\n   expected_indices_top1 = matrix(\"4\n                                   2\", rows=2, cols=1)\n   expected_values_top2 = matrix(\"0.4 0.3\n                                  0.3 0.3\", rows=2, cols=2)\n   expected_indices_top2 = matrix(\"4 2\n                                   2 3\", rows=2, cols=2)\n   expected_values_topAll = matrix(\"0.4 0.3 0.2 0.1\n                                    0.3 0.3 0.2 0.1\", rows=2, cols=4)\n   expected_indices_topAll = matrix(\"4 2 3 1\n                                     2 3 4 1\", rows=2, cols=4)\n\n   # test top_1\n   print(\" - Testing top_1.\")\n   [values_top1, indices_top1] = util::top_k(X, 1)\n   check_values_top1 = test_util::check_all_equal(values_top1, expected_values_top1)\n   check_indices_top1 = test_util::check_all_equal(indices_top1, expected_indices_top1)\n\n   # test top_2\n   print(\" - Testing top_2.\")\n   [values_top2, indices_top2] = util::top_k(X, 2)\n   check_values_top2 = test_util::check_all_equal(values_top2, expected_values_top2)\n   check_indices_top2 = test_util::check_all_equal(indices_top2, expected_indices_top2)\n\n   # test top_All\n   print(\" - Testing top_All.\")\n   [values_topAll, indices_topAll] = util::top_k(X, 4)\n   check_values_topAll = test_util::check_all_equal(values_topAll, expected_values_topAll)\n   check_indices_topAll = test_util::check_all_equal(indices_topAll, expected_indices_topAll)\n}\n";
        return string;
    }

    public void softmax2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::softmax2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String softmax2d__docs() {
        String string = "softmax2d = function() {\n  /*\n   * Test for 2D softmax function.\n   */\n";
        return string;
    }

    public String softmax2d__source() {
        String string = "softmax2d = function() {\n  /*\n   * Test for 2D softmax function.\n   */\n  print(\"Testing the 2D softmax function.\")\n\n  N = 2  # num example\n  C = 3  # num class\n  Hin = 3  # example height\n  Win = 3  # example width\n  X = matrix(\"10.0  10.0  0.0\n              10.0  0.0   0.0\n              10.0  0.0   0.0\n              0.0   10.0  0.0\n              0.0   10.0  0.0\n              0.0   10.0  0.0\n              0.0   0.0   10.0\n              0.0   0.0   10.0\n              0.0   0.0   10.0\n              10.0  10.0  0.0\n              10.0  0.0   0.0\n              10.0  0.0   0.0\n              0.0   10.0  0.0\n              0.0   10.0  0.0\n              0.0   10.0  0.0\n              0.0   0.0   10.0\n              0.0   0.0   10.0\n              0.0   0.0   10.0\", rows=N, cols=C*Hin*Win)\n\n  probs_expected = matrix(\"9.99909163e-01   4.99988675e-01   4.53958055e-05\n                          9.99909163e-01   4.53958055e-05   4.53958055e-05\n                          9.99909163e-01   4.53958055e-05   4.53958055e-05\n                          4.53958055e-05   4.99988675e-01   4.53958055e-05\n                          4.53958055e-05   9.99909163e-01   4.53958055e-05\n                          4.53958055e-05   9.99909163e-01   4.53958055e-05\n                          4.53958055e-05   2.26994507e-05   9.99909163e-01\n                          4.53958055e-05   4.53958055e-05   9.99909163e-01\n                          4.53958055e-05   4.53958055e-05   9.99909163e-01\n                          9.99909163e-01   4.99988675e-01   4.53958055e-05\n                          9.99909163e-01   4.53958055e-05   4.53958055e-05\n                          9.99909163e-01   4.53958055e-05   4.53958055e-05\n                          4.53958055e-05   4.99988675e-01   4.53958055e-05\n                          4.53958055e-05   9.99909163e-01   4.53958055e-05\n                          4.53958055e-05   9.99909163e-01   4.53958055e-05\n                          4.53958055e-05   2.26994507e-05   9.99909163e-01\n                          4.53958055e-05   4.53958055e-05   9.99909163e-01\n                          4.53958055e-05   4.53958055e-05   9.99909163e-01\", rows=N, cols=C*Hin*Win)\n  probs = softmax2d::forward(X, C)\n\n  # Equivalency check\n  for (i in 1:nrow(probs)) {\n    for (j in 1:ncol(probs)) {\n      rel_error = test_util::check_rel_error(as.scalar(probs[i,j]), as.scalar(probs_expected[i,j]),\n                                             1e-5, 1e-6)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::conv2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d__docs() {
        String string = "conv2d = function() {\n  /*\n   * Test for the 2D convolution functions.\n   */\n";
        return string;
    }

    public String conv2d__source() {
        String string = "conv2d = function() {\n  /*\n   * Test for the 2D convolution functions.\n   */\n  print(\"Testing the 2D convolution functions.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  F = 2  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = rand(rows=N, cols=C*Hin*Win, pdf=\"normal\")\n\n  # Create layer\n  [W, b] = conv2d::init(F, C, Hf, Wf)\n\n  # Forward\n  [out, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  [out_simple, Hout_simple, Wout_simple] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf,\n                                                                  stride, stride, pad, pad)\n  [out_builtin, Hout_builtin, Wout_builtin] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf,\n                                                                      stride, stride, pad, pad)\n\n  # Equivalency check\n  out = matrix(out, rows=1, cols=N*F*Hout*Wout)\n  out_simple = matrix(out_simple, rows=1, cols=N*F*Hout*Wout)\n  out_builtin = matrix(out_builtin, rows=1, cols=N*F*Hout*Wout)\n  for (i in 1:length(out)) {\n    rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                           as.scalar(out_simple[1,i]), 1e-10, 1e-12)\n    rel_error = test_util::check_rel_error(as.scalar(out[1,i]),\n                                           as.scalar(out_builtin[1,i]), 1e-10, 1e-12)\n  }\n}\n";
        return string;
    }

    public void transpose_NCHW_to_CNHW() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::transpose_NCHW_to_CNHW();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String transpose_NCHW_to_CNHW__docs() {
        String string = "transpose_NCHW_to_CNHW = function() {\n  /*\n   * Test for `transpose_NCHW_to_CNHW` function.\n   */\n";
        return string;
    }

    public String transpose_NCHW_to_CNHW__source() {
        String string = "transpose_NCHW_to_CNHW = function() {\n  /*\n   * Test for `transpose_NCHW_to_CNHW` function.\n   */\n  print(\"Testing transpose_NCHW_to_CNHW function.\")\n\n  # Generate data\n  N = 2\n  C = 3\n  H = 4\n  W = 5\n  X = matrix(seq(1, N*C*H*W), rows=N, cols=C*H*W)\n\n  out = util::transpose_NCHW_to_CNHW(X, C)\n\n  target =\n    matrix(\"1   2   3   4   5   6   7   8   9   10  11  12  13  14  15  16  17  18  19  20\n            61  62  63  64  65  66  67  68  69  70  71  72  73  74  75  76  77  78  79  80\n            21  22  23  24  25  26  27  28  29  30  31  32  33  34  35  36  37  38  39  40\n            81  82  83  84  85  86  87  88  89  90  91  92  93  94  95  96  97  98  99 100\n            41  42  43  44  45  46  47  48  49  50  51  52  53  54  55  56  57  58  59  60\n            101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120\",\n           rows=C, cols=N*H*W)\n\n  # Equivalency check\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n                                             as.scalar(target[i,j]), 1e-10, 1e-12)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_depthwise() {
        String string = "source('scripts/nn/test/test.dml') as mlcontextns;mlcontextns::conv2d_depthwise();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_depthwise__docs() {
        String string = "conv2d_depthwise = function() {\n  /*\n   * Test for the 2D depthwise convolution function.\n   */\n";
        return string;
    }

    public String conv2d_depthwise__source() {
        String string = "conv2d_depthwise = function() {\n  /*\n   * Test for the 2D depthwise convolution function.\n   */\n  print(\"Testing the 2D depthwise convolution function.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 3  # input height\n  Win = 3  # input width\n  M = 2  # num filters per input channel (i.e. depth multiplier)\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = matrix(seq(1,N*C*Hin*Win), rows=N, cols=C*Hin*Win) / (N*C*Hin*Win) * 2 - 1  # normalized\n\n  # Create layer\n  W = matrix(seq(1,C*M*Hf*Wf), rows=C, cols=M*Hf*Wf) / (C*M*Hf*Wf) * 2 - 1  # normalized\n  b = matrix(seq(1,C*M), rows=C*M, cols=1) / (C*M)^2  # non-zero & non-one\n\n  # Forward\n  [out, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                pad, pad)\n\n  # Equivalency check\n  target = matrix(\"2.13040113  3.20447516  2.16743827\n                   3.30324078  4.94212961  3.30324078\n                   2.16743827  3.20447516  2.13040113\n\n                   0.52623457  0.85030866  0.67438275\n                   1.11574078  1.75462961  1.2824074\n                   0.89660496  1.35030866  0.97067899\n\n                  -0.30015433 -0.42052469 -0.15200615\n                  -0.15509261 -0.1828704   0.01157404\n                   0.07021603  0.07947529  0.1442901\n\n                  -0.90432101 -1.27469134 -0.64506173\n                  -0.8425926  -1.12037039 -0.50925928\n                  -0.20061731 -0.2746914  -0.01543214\n\n\n                  -0.31404325 -0.62885809 -0.49922845\n                  -0.86342597 -1.55787039 -1.19675934\n                  -0.94367278 -1.62885797 -1.20293212\n\n                   0.0817901   0.01697529  0.00771603\n                  -0.05092596 -0.2453704  -0.21759261\n                  -0.21450615 -0.48302469 -0.36265433\n\n                   1.25540125  1.74614203  1.1813271\n                   1.67824078  2.31712961  1.51157403\n                   0.95910496  1.24614203  0.81095684\n\n                   2.65123463  3.8919754   2.68827152\n                   3.99074078  5.87962961  3.99074078\n                   2.68827152  3.8919754   2.65123463\", rows=N, cols=C*M*Hout*Wout)\n\n  for (i in 1:nrow(out)) {\n    for(j in 1:ncol(out)) {\n      rel_error = test_util::check_rel_error(as.scalar(out[i,j]),\n                                             as.scalar(target[i,j]), 1e-3, 1e-4)\n    }\n  }\n}\n";
        return string;
    }
}

