/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.redirect;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfigurationContext;
import org.pac4j.oidc.exceptions.OidcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRedirectionActionBuilder
implements RedirectionActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRedirectionActionBuilder.class);
    protected OidcClient client;

    public OidcRedirectionActionBuilder(OidcClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        OidcConfigurationContext configContext = new OidcConfigurationContext(webContext, this.client.getConfiguration());
        Map<String, String> params = this.buildParams(webContext);
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(webContext);
        params.put("redirect_uri", computedCallbackUrl);
        this.addStateAndNonceParameters(ctx, params);
        Integer maxAge = configContext.getMaxAge();
        if (maxAge != null) {
            params.put("max_age", maxAge.toString());
        }
        if (configContext.isForceAuthn().booleanValue()) {
            params.put("prompt", "login");
            params.put("max_age", "0");
        }
        if (configContext.isPassive().booleanValue()) {
            params.put("prompt", "none");
        }
        String location = this.buildAuthenticationRequestUrl(params);
        LOGGER.debug("Authentication request url: {}", (Object)location);
        return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)location));
    }

    protected Map<String, String> buildParams(WebContext webContext) {
        OidcConfigurationContext configContext = new OidcConfigurationContext(webContext, this.client.getConfiguration());
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("scope", configContext.getScope().replace(",", " "));
        authParams.put("response_type", configContext.getResponseType());
        authParams.put("response_mode", configContext.getResponseMode());
        authParams.putAll(configContext.getCustomParams());
        authParams.put("client_id", configContext.getConfiguration().getClientId());
        return new HashMap<String, String>(authParams);
    }

    protected void addStateAndNonceParameters(CallContext ctx, Map<String, String> params) {
        CodeChallengeMethod pkceMethod;
        WebContext webContext = ctx.webContext();
        SessionStore sessionStore = ctx.sessionStore();
        if (this.client.getConfiguration().isWithState()) {
            State state = new State(this.client.getConfiguration().getStateGenerator().generateValue(ctx));
            params.put("state", state.getValue());
            sessionStore.set(webContext, this.client.getStateSessionAttributeName(), (Object)state);
        }
        if (this.client.getConfiguration().isUseNonce()) {
            Nonce nonce = new Nonce();
            params.put("nonce", nonce.getValue());
            sessionStore.set(webContext, this.client.getNonceSessionAttributeName(), (Object)nonce.getValue());
        }
        if ((pkceMethod = this.client.getConfiguration().findPkceMethod()) != null) {
            CodeVerifier verifier = new CodeVerifier(this.client.getConfiguration().getCodeVerifierGenerator().generateValue(ctx));
            sessionStore.set(webContext, this.client.getCodeVerifierSessionAttributeName(), (Object)verifier);
            params.put("code_challenge", CodeChallenge.compute((CodeChallengeMethod)pkceMethod, (CodeVerifier)verifier).getValue());
            params.put("code_challenge_method", pkceMethod.getValue());
        }
    }

    protected String buildAuthenticationRequestUrl(Map<String, String> params) {
        String queryString;
        try {
            Map<String, List> parameters = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList((String)e.getValue())));
            queryString = AuthenticationRequest.parse(parameters).toQueryString();
            queryString = queryString.replaceAll("\\+", "%20");
        }
        catch (Exception e2) {
            throw new OidcException(e2);
        }
        return ((OIDCProviderMetadata)this.client.getConfiguration().getOpMetadataResolver().load()).getAuthorizationEndpointURI().toString() + "?" + queryString;
    }
}

