/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;

public class Saml2ClientBuilder
extends AbstractBuilder {
    public Saml2ClientBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateSaml2Client(Collection<Client> clients) {
        for (int i = 0; i <= 100; ++i) {
            String wantsResponsesSigned;
            String wantsAssertionsSigned;
            String responseBindingType;
            String passive;
            String nameIdAttribute;
            String mappedAttributes;
            String authnRequestSigned;
            String issuerFormat;
            String comparisonType;
            String authnContextClassRefs;
            String attributeAsId;
            String forceAuth;
            String assertionConsumerServiceIndex;
            String acceptedSkew;
            String keystorePassword = this.getProperty("saml.keystorePassword", i);
            String privateKeyPassword = this.getProperty("saml.privateKeyPassword", i);
            String keystorePath = this.getProperty("saml.keystorePath", i);
            String identityProviderMetadataPath = this.getProperty("saml.identityProviderMetadataPath", i);
            if (!StringUtils.isNotBlank((CharSequence)keystorePassword) || !StringUtils.isNotBlank((CharSequence)privateKeyPassword) || !StringUtils.isNotBlank((CharSequence)keystorePath) || !StringUtils.isNotBlank((CharSequence)identityProviderMetadataPath)) continue;
            String maximumAuthenticationLifetime = this.getProperty("saml.maximumAuthenticationLifetime", i);
            String serviceProviderEntityId = this.getProperty("saml.serviceProviderEntityId", i);
            String serviceProviderMetadataPath = this.getProperty("saml.serviceProviderMetadataPath", i);
            String destinationBindingType = this.getProperty("saml.authnRequestBindingType", i);
            String keystoreAlias = this.getProperty("saml.keystoreAlias", i);
            SAML2Configuration cfg = new SAML2Configuration(keystorePath, keystorePassword, privateKeyPassword, identityProviderMetadataPath);
            if (StringUtils.isNotBlank((CharSequence)maximumAuthenticationLifetime)) {
                cfg.setMaximumAuthenticationLifetime((long)Integer.parseInt(maximumAuthenticationLifetime));
            }
            if (StringUtils.isNotBlank((CharSequence)serviceProviderEntityId)) {
                cfg.setServiceProviderEntityId(serviceProviderEntityId);
            }
            if (StringUtils.isNotBlank((CharSequence)serviceProviderMetadataPath)) {
                cfg.setServiceProviderMetadataPath(serviceProviderMetadataPath);
            }
            if (StringUtils.isNotBlank((CharSequence)destinationBindingType)) {
                cfg.setAuthnRequestBindingType(destinationBindingType);
            }
            if (StringUtils.isNotBlank((CharSequence)keystoreAlias)) {
                cfg.setKeyStoreAlias(keystoreAlias);
            }
            if (StringUtils.isNotBlank((CharSequence)(acceptedSkew = this.getProperty("saml.acceptedSkew", i)))) {
                cfg.setAcceptedSkew(Long.parseLong(acceptedSkew));
            }
            if (StringUtils.isNotBlank((CharSequence)(assertionConsumerServiceIndex = this.getProperty("saml.assertionConsumerServiceIndex", i)))) {
                cfg.setAssertionConsumerServiceIndex(Integer.parseInt(assertionConsumerServiceIndex));
            }
            if (StringUtils.isNotBlank((CharSequence)(forceAuth = this.getProperty("saml.forceAuth", i)))) {
                cfg.setForceAuth(Boolean.parseBoolean(forceAuth));
            }
            if (StringUtils.isNotBlank((CharSequence)(attributeAsId = this.getProperty("saml.attributeAsId", i)))) {
                cfg.setAttributeAsId(attributeAsId);
            }
            if (StringUtils.isNotBlank((CharSequence)(authnContextClassRefs = this.getProperty("saml.authnContextClassRefs", i)))) {
                cfg.setAuthnContextClassRefs(Arrays.stream(authnContextClassRefs.split(",")).collect(Collectors.toList()));
            }
            if (StringUtils.isNotBlank((CharSequence)(comparisonType = this.getProperty("saml.comparisonType", i)))) {
                cfg.setComparisonType(comparisonType);
            }
            if (StringUtils.isNotBlank((CharSequence)(issuerFormat = this.getProperty("saml.issuerFormat", i)))) {
                cfg.setIssuerFormat(issuerFormat);
            }
            if (StringUtils.isNotBlank((CharSequence)(authnRequestSigned = this.getProperty("saml.authnRequestSigned", i)))) {
                cfg.setAuthnRequestSigned(Boolean.parseBoolean(authnRequestSigned));
            }
            if (StringUtils.isNotBlank((CharSequence)(mappedAttributes = this.getProperty("saml.mappedAttributes", i)))) {
                Map<String, String> mapped = Arrays.stream(mappedAttributes.split(",")).collect(Collectors.toMap(key -> key.split(":")[0], value -> value.split(":")[1]));
                cfg.setMappedAttributes(mapped);
            }
            if (StringUtils.isNotBlank((CharSequence)(nameIdAttribute = this.getProperty("saml.nameIdAttribute", i)))) {
                cfg.setNameIdAttribute(nameIdAttribute);
            }
            if (StringUtils.isNotBlank((CharSequence)(passive = this.getProperty("saml.passive", i)))) {
                cfg.setPassive(Boolean.parseBoolean(passive));
            }
            if (StringUtils.isNotBlank((CharSequence)(responseBindingType = this.getProperty("saml.responseBindingType", i)))) {
                cfg.setResponseBindingType(responseBindingType);
            }
            if (StringUtils.isNotBlank((CharSequence)(wantsAssertionsSigned = this.getProperty("saml.wantsAssertionsSigned", i)))) {
                cfg.setWantsAssertionsSigned(Boolean.parseBoolean(wantsAssertionsSigned));
            }
            if (StringUtils.isNotBlank((CharSequence)(wantsResponsesSigned = this.getProperty("saml.wantsResponsesSigned", i)))) {
                cfg.setWantsResponsesSigned(Boolean.parseBoolean(wantsResponsesSigned));
            }
            SAML2Client saml2Client = new SAML2Client(cfg);
            String clientName = StringUtils.defaultString((String)this.getProperty("client.name", i), (String)this.concat(saml2Client.getName(), i));
            saml2Client.setName(clientName);
            clients.add((Client)saml2Client);
        }
    }
}

