/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.client;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.delegation.DelegationAutoRedirectTypes;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCookieProperties;
import org.apereo.cas.pac4j.client.DelegatedClientIdentityProviderRedirectionStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.DelegatedClientIdentityProviderConfiguration;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.DelegationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.execution.RequestContext;

public class DefaultDelegatedClientIdentityProviderRedirectionStrategy
implements DelegatedClientIdentityProviderRedirectionStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedClientIdentityProviderRedirectionStrategy.class);
    protected final ServicesManager servicesManager;
    protected final CasCookieBuilder delegatedAuthenticationCookieBuilder;
    protected final CasConfigurationProperties casProperties;
    protected final ConfigurableApplicationContext applicationContext;

    public Optional<DelegatedClientIdentityProviderConfiguration> select(RequestContext context, WebApplicationService service, Set<DelegatedClientIdentityProviderConfiguration> providers) {
        for (DelegatedClientIdentityProviderConfiguration provider : providers) {
            HttpServletRequest request;
            String cookieValue;
            RegisteredService registeredService;
            RegisteredServiceDelegatedAuthenticationPolicy delegatedPolicy;
            if (service != null && (delegatedPolicy = (registeredService = this.servicesManager.findServiceBy((Service)service)).getAccessStrategy().getDelegatedAuthenticationPolicy()) != null) {
                if (delegatedPolicy.isExclusiveToProvider(provider.getName())) {
                    LOGGER.trace("Registered service [{}] is exclusively allowed to use provider [{}]", (Object)registeredService, (Object)provider);
                    provider.setAutoRedirectType(DelegationAutoRedirectTypes.SERVER);
                    return Optional.of(provider);
                }
                if (StringUtils.isNotBlank((CharSequence)delegatedPolicy.getSelectionStrategy())) {
                    return (Optional)ApplicationContextProvider.getScriptResourceCacheManager().map(Unchecked.function(cacheMgr -> {
                        String strategy = SpringExpressionLanguageValueResolver.getInstance().resolve(delegatedPolicy.getSelectionStrategy());
                        ExecutableCompiledScript script = cacheMgr.resolveScriptableResource(strategy, new String[]{String.valueOf(registeredService.getId()), registeredService.getName()});
                        Map args = CollectionUtils.wrap((String)"requestContext", (Object)context, (String)"service", (Object)service, (String)"registeredService", (Object)registeredService, (String)"providers", (Object)providers, (String)"applicationContext", (Object)this.applicationContext, (String)"logger", (Object)LOGGER);
                        script.setBinding(args);
                        DelegatedClientIdentityProviderConfiguration result = (DelegatedClientIdentityProviderConfiguration)script.execute(args.values().toArray(), DelegatedClientIdentityProviderConfiguration.class, false);
                        return Optional.ofNullable(result);
                    })).orElseThrow(() -> new RuntimeException("No groovy script cache manager"));
                }
            }
            if (DelegationWebflowUtils.getDelegatedAuthenticationProviderPrimary(context) == null && provider.getAutoRedirectType() != DelegationAutoRedirectTypes.NONE) {
                LOGGER.trace("Provider [{}] is configured to auto-redirect", (Object)provider);
                return Optional.of(provider);
            }
            Pac4jDelegatedAuthenticationCookieProperties cookieProps = this.casProperties.getAuthn().getPac4j().getCookie();
            if (!cookieProps.isEnabled() || !StringUtils.equalsIgnoreCase((CharSequence)(cookieValue = this.delegatedAuthenticationCookieBuilder.retrieveCookieValue(request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context))), (CharSequence)provider.getName())) continue;
            LOGGER.trace("Provider [{}] is chosen via cookie value preference as primary", (Object)provider);
            provider.setAutoRedirectType(DelegationAutoRedirectTypes.SERVER);
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    @Generated
    public DefaultDelegatedClientIdentityProviderRedirectionStrategy(ServicesManager servicesManager, CasCookieBuilder delegatedAuthenticationCookieBuilder, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        this.servicesManager = servicesManager;
        this.delegatedAuthenticationCookieBuilder = delegatedAuthenticationCookieBuilder;
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
    }
}

