/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import java.io.Serializable;
import java.util.Optional;
import org.apereo.cas.aup.AcceptableUsagePolicyStatus;
import org.apereo.cas.aup.AcceptableUsagePolicyTerms;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public interface AcceptableUsagePolicyRepository
extends Serializable {
    public static final BeanCondition CONDITION_AUP_ENABLED = BeanCondition.on((String)"cas.acceptable-usage-policy.core.enabled").isTrue().evenIfMissing();
    public static final String BEAN_NAME = "acceptableUsagePolicyRepository";

    public static AcceptableUsagePolicyRepository noOp() {
        return new AcceptableUsagePolicyRepository(){
            private static final long serialVersionUID = 8784500942988440997L;

            @Override
            public AcceptableUsagePolicyStatus verify(RequestContext requestContext) {
                Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
                return AcceptableUsagePolicyStatus.skipped(authn.getPrincipal());
            }

            @Override
            public boolean submit(RequestContext requestContext) {
                return false;
            }

            @Override
            public Optional<AcceptableUsagePolicyTerms> fetchPolicy(RequestContext requestContext) {
                return Optional.empty();
            }
        };
    }

    public AcceptableUsagePolicyStatus verify(RequestContext var1) throws Throwable;

    public boolean submit(RequestContext var1) throws Throwable;

    public Optional<AcceptableUsagePolicyTerms> fetchPolicy(RequestContext var1);
}

