/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Strings;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.rest.api.service.wa.WAConfigService;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.provisioning.api.data.WAConfigDataBinder;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class WAConfigLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final ServiceOps serviceOps;
    protected final WAConfigDataBinder binder;
    protected final WAConfigDAO waConfigDAO;
    protected final SecurityProperties securityProperties;

    public WAConfigLogic(ServiceOps serviceOps, WAConfigDataBinder binder, WAConfigDAO waConfigDAO, SecurityProperties securityProperties) {
        this.serviceOps = serviceOps;
        this.binder = binder;
        this.waConfigDAO = waConfigDAO;
        this.securityProperties = securityProperties;
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<Attr> list() {
        return this.waConfigDAO.findAll().stream().map(arg_0 -> ((WAConfigDataBinder)this.binder).get(arg_0)).toList();
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_GET')")
    @Transactional(readOnly=true)
    public Attr get(String key) {
        return this.waConfigDAO.findById(key).map(arg_0 -> ((WAConfigDataBinder)this.binder).get(arg_0)).orElseThrow(() -> new NotFoundException("WAConfigEntry " + key));
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_SET')")
    public void set(Attr value) {
        this.waConfigDAO.save((Entity)this.binder.set(value));
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_DELETE')")
    public void delete(String key) {
        this.waConfigDAO.deleteById(key);
    }

    protected void registeredServices(HttpClient client, String serviceAddress) {
        String target = Strings.CS.appendIfMissing(serviceAddress, (CharSequence)"/", new CharSequence[0]) + "actuator/registeredServices";
        client.sendAsync(HttpRequest.newBuilder(URI.create(target)).header("Authorization", DefaultBasicAuthSupplier.getBasicAuthHeader((String)this.securityProperties.getAnonymousUser(), (String)this.securityProperties.getAnonymousKey())).GET().build(), HttpResponse.BodyHandlers.discarding()).thenAcceptAsync(response -> LOG.info("Pushed to {} with HTTP status: {}", (Object)target, (Object)response.statusCode()));
    }

    protected void refresh(HttpClient client, String serviceAddress) {
        String target = Strings.CS.appendIfMissing(serviceAddress, (CharSequence)"/", new CharSequence[0]) + "actuator/refresh";
        client.sendAsync(HttpRequest.newBuilder(URI.create(target)).header("Authorization", DefaultBasicAuthSupplier.getBasicAuthHeader((String)this.securityProperties.getAnonymousUser(), (String)this.securityProperties.getAnonymousKey())).POST(HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding()).thenAcceptAsync(response -> LOG.info("Pushed to {} with HTTP status: {}", (Object)target, (Object)response.statusCode()));
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_PUSH')")
    public void pushToWA(WAConfigService.PushSubject subject, List<String> services) {
        try (HttpClient client = HttpClient.newHttpClient();){
            this.serviceOps.list(NetworkService.Type.WA).stream().filter(wa -> CollectionUtils.isEmpty((Collection)services) || services.contains(wa.getAddress())).forEach(wa -> {
                switch (subject) {
                    case clientApps: {
                        this.registeredServices(client, wa.getAddress());
                        break;
                    }
                    default: {
                        this.refresh(client, wa.getAddress());
                    }
                }
            });
        }
        catch (KeymasterException e) {
            throw new NotFoundException("Could not find any WA instance", (Exception)((Object)e));
        }
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

