/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.kstream.internals.AbstractConfigurableStoreFactory;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class SubscriptionStoreFactory<K>
extends AbstractConfigurableStoreFactory {
    private final String name;
    private final Serde<SubscriptionWrapper<K>> subscriptionWrapperSerde;
    private final Map<String, String> logConfig = new HashMap<String, String>();
    private boolean loggingEnabled = true;

    public SubscriptionStoreFactory(String name, Serde<SubscriptionWrapper<K>> subscriptionWrapperSerde) {
        super(null);
        this.name = name;
        this.subscriptionWrapperSerde = subscriptionWrapperSerde;
    }

    @Override
    public StateStore build() {
        StoreBuilder builder = Stores.timestampedKeyValueStoreBuilder(this.dslStoreSuppliers().keyValueStore(new DslKeyValueParams(this.name, true)), new Serdes.BytesSerde(), this.subscriptionWrapperSerde);
        builder = this.loggingEnabled ? builder.withLoggingEnabled(this.logConfig) : builder.withLoggingDisabled();
        builder = builder.withCachingDisabled();
        return builder.build();
    }

    @Override
    public long retentionPeriod() {
        throw new IllegalStateException("retentionPeriod is not supported when not a window store");
    }

    @Override
    public long historyRetention() {
        throw new IllegalStateException("historyRetention is not supported when not a versioned store");
    }

    @Override
    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isWindowStore() {
        return false;
    }

    @Override
    public boolean isVersionedStore() {
        return false;
    }

    @Override
    public Map<String, String> logConfig() {
        return this.logConfig;
    }

    @Override
    public StoreFactory withCachingDisabled() {
        return this;
    }

    @Override
    public StoreFactory withLoggingDisabled() {
        this.loggingEnabled = false;
        return this;
    }

    @Override
    public boolean isCompatibleWith(StoreFactory other) {
        return other instanceof SubscriptionStoreFactory && ((SubscriptionStoreFactory)other).name.equals(this.name);
    }
}

