/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.flowable.editor.constants.EditorJsonConstants;
import org.flowable.editor.constants.StencilConstants;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public final class JsonConverterUtil
implements EditorJsonConstants,
StencilConstants {
    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = JsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode, false);
    }

    public static boolean getPropertyValueAsBoolean(String name, JsonNode objectNode, boolean defaultValue) {
        boolean result = defaultValue;
        String stringValue = JsonConverterUtil.getPropertyValueAsString(name, objectNode);
        if ("Yes".equalsIgnoreCase(stringValue) || "true".equalsIgnoreCase(stringValue)) {
            result = true;
        } else if ("No".equalsIgnoreCase(stringValue) || "false".equalsIgnoreCase(stringValue)) {
            result = false;
        }
        return result;
    }

    public static List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode propertyNode = JsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !"null".equalsIgnoreCase(propertyNode.asText())) {
            String[] valueList;
            String propertyValue = propertyNode.asText();
            for (String value : valueList = propertyValue.split(",")) {
                resultList.add(value.trim());
            }
        }
        return resultList;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }

    protected static List<JsonLookupResult> getBpmnProcessModelChildShapesPropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes) {
        ArrayList<JsonLookupResult> result = new ArrayList<JsonLookupResult>();
        JsonConverterUtil.internalGetBpmnProcessChildShapePropertyValues(editorJsonNode, propertyName, allowedStencilTypes, result);
        return result;
    }

    protected static void internalGetBpmnProcessChildShapePropertyValues(JsonNode editorJsonNode, String propertyName, List<String> allowedStencilTypes, List<JsonLookupResult> result) {
        JsonNode childShapesNode = editorJsonNode.get("childShapes");
        if (childShapesNode != null && childShapesNode.isArray()) {
            ArrayNode childShapesArrayNode = (ArrayNode)childShapesNode;
            for (JsonNode childShapeNode : childShapesArrayNode) {
                JsonNode properties;
                String childShapeNodeStencilId = BpmnJsonConverterUtil.getStencilId(childShapeNode);
                boolean readPropertiesNode = allowedStencilTypes.contains(childShapeNodeStencilId);
                if (readPropertiesNode && (properties = childShapeNode.get("properties")) != null && properties.has(propertyName)) {
                    JsonNode nameNode = properties.get("name");
                    JsonNode propertyNode = properties.get(propertyName);
                    result.add(new JsonLookupResult(BpmnJsonConverterUtil.getElementId(childShapeNode), nameNode != null ? nameNode.asText() : null, propertyNode));
                }
                if (!childShapeNode.has("childShapes")) continue;
                JsonConverterUtil.internalGetBpmnProcessChildShapePropertyValues(childShapeNode, propertyName, allowedStencilTypes, result);
            }
        }
    }

    public static List<JsonLookupResult> getBpmnProcessModelFormReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("UserTask");
        allowedStencilTypes.add("StartNoneEvent");
        return JsonConverterUtil.getBpmnProcessModelChildShapesPropertyValues(editorJsonNode, "formreference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getBpmnProcessModelDecisionTableReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("DecisionTask");
        return JsonConverterUtil.getBpmnProcessModelChildShapesPropertyValues(editorJsonNode, "decisiontaskdecisiontablereference", allowedStencilTypes);
    }

    public static List<JsonLookupResult> getBpmnProcessModelDecisionServiceReferences(JsonNode editorJsonNode) {
        ArrayList<String> allowedStencilTypes = new ArrayList<String>();
        allowedStencilTypes.add("DecisionTask");
        return JsonConverterUtil.getBpmnProcessModelChildShapesPropertyValues(editorJsonNode, "decisiontaskdecisionservicereference", allowedStencilTypes);
    }

    public static List<JsonNode> getAppModelReferencedProcessModels(JsonNode appModelJson) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        if (appModelJson.has("models")) {
            ArrayNode modelsArrayNode = (ArrayNode)appModelJson.get("models");
            Iterator modelArrayIterator = modelsArrayNode.iterator();
            while (modelArrayIterator.hasNext()) {
                result.add((JsonNode)modelArrayIterator.next());
            }
        }
        return result;
    }

    public static Set<String> getAppModelReferencedModelIds(JsonNode appModelJson) {
        if (appModelJson.has("models")) {
            return JsonConverterUtil.gatherStringPropertyFromJsonNodes((Iterable<JsonNode>)appModelJson.get("models"), "id");
        }
        return Collections.emptySet();
    }

    public static Set<Long> gatherLongPropertyFromJsonNodes(Iterable<JsonNode> jsonNodes, String propertyName) {
        HashSet<Long> result = new HashSet<Long>();
        for (JsonNode node : jsonNodes) {
            long propertyValue;
            if (!node.has(propertyName) || (propertyValue = node.get(propertyName).asLong()) <= 0L) continue;
            result.add(propertyValue);
        }
        return result;
    }

    public static Set<String> gatherStringPropertyFromJsonNodes(Iterable<JsonNode> jsonNodes, String propertyName) {
        HashSet<String> result = new HashSet<String>();
        for (JsonNode node : jsonNodes) {
            String propertyValue;
            if (!node.has(propertyName) || (propertyValue = node.get(propertyName).asText()) == null) continue;
            result.add(propertyValue);
        }
        return result;
    }

    public static List<JsonNode> filterOutJsonNodes(List<JsonLookupResult> lookupResults) {
        ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>(lookupResults.size());
        for (JsonLookupResult lookupResult : lookupResults) {
            jsonNodes.add(lookupResult.getJsonNode());
        }
        return jsonNodes;
    }

    private JsonConverterUtil() {
    }

    public static class JsonLookupResult {
        private String id;
        private String name;
        private JsonNode jsonNode;

        public JsonLookupResult(String id, String name, JsonNode jsonNode) {
            this(name, jsonNode);
            this.id = id;
        }

        public JsonLookupResult(String name, JsonNode jsonNode) {
            this.name = name;
            this.jsonNode = jsonNode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JsonNode getJsonNode() {
            return this.jsonNode;
        }

        public void setJsonNode(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }
    }
}

