/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.ldaptive.pool.QueueType;

public class Queue<T>
implements Iterable<T> {
    private final QueueType queueType;
    private final Deque<T> queue;

    public Queue(QueueType type) {
        this.queueType = type;
        this.queue = new LinkedList<T>();
    }

    public void add(T t) {
        if (QueueType.LIFO == this.queueType) {
            this.queue.addFirst(t);
        } else if (QueueType.FIFO == this.queueType) {
            this.queue.addLast(t);
        } else {
            throw new IllegalStateException("Unknown queue type: " + this.queueType);
        }
    }

    public T remove() {
        return this.queue.removeFirst();
    }

    public boolean remove(T t) {
        return this.queue.remove(t);
    }

    public T element() {
        return this.queue.getFirst();
    }

    public boolean contains(T t) {
        return this.queue.contains(t);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::queueType=" + this.queueType + ", queue=" + this.queue + "]";
    }
}

