/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.job.service.impl.persistence.entity.AbstractJobServiceEntity;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;

public abstract class AbstractJobEntityImpl
extends AbstractJobServiceEntity
implements AbstractRuntimeJobEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Date createTime;
    protected Date duedate;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String category;
    protected String jobType;
    protected String elementId;
    protected String elementName;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String correlationId;
    protected boolean isExclusive = true;
    protected int retries;
    protected int maxIterations;
    protected String repeat;
    protected Date endDate;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected ByteArrayRef customValuesByteArrayRef;
    protected ByteArrayRef exceptionByteArrayRef;
    protected String exceptionMessage;
    protected String tenantId = "";

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("retries", this.retries);
        persistentState.put("createTime", this.createTime);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("jobHandlerType", this.jobHandlerType);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("category", this.category);
        persistentState.put("jobType", this.jobType);
        persistentState.put("elementId", this.elementId);
        persistentState.put("elementName", this.elementName);
        persistentState.put("correlationId", this.correlationId);
        if (this.customValuesByteArrayRef != null) {
            persistentState.put("customValuesByteArrayRef", this.customValuesByteArrayRef);
        }
        if (this.exceptionByteArrayRef != null && this.exceptionByteArrayRef.getId() != null) {
            persistentState.put("exceptionByteArrayRef", this.exceptionByteArrayRef);
        }
        return persistentState;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    @Override
    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    @Override
    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getElementId() {
        return this.elementId;
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    @Override
    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    @Override
    public void setScopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getJobType() {
        return this.jobType;
    }

    @Override
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public String getRepeat() {
        return this.repeat;
    }

    @Override
    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    @Override
    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    @Override
    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    @Override
    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public ByteArrayRef getCustomValuesByteArrayRef() {
        return this.customValuesByteArrayRef;
    }

    @Override
    public void setCustomValuesByteArrayRef(ByteArrayRef customValuesByteArrayRef) {
        this.customValuesByteArrayRef = customValuesByteArrayRef;
    }

    @Override
    public String getCustomValues() {
        return this.getJobByteArrayRefAsString(this.customValuesByteArrayRef);
    }

    @Override
    public void setCustomValues(String customValues) {
        if (this.customValuesByteArrayRef == null) {
            this.customValuesByteArrayRef = new ByteArrayRef();
        }
        this.customValuesByteArrayRef.setValue("jobCustomValues", customValues, this.getEngineType());
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getExceptionStacktrace() {
        return this.getJobByteArrayRefAsString(this.exceptionByteArrayRef);
    }

    @Override
    public void setExceptionStacktrace(String exception) {
        if (this.exceptionByteArrayRef == null) {
            this.exceptionByteArrayRef = new ByteArrayRef();
        }
        this.exceptionByteArrayRef.setValue("stacktrace", exception, this.getEngineType());
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtils.abbreviate((String)exceptionMessage, (int)2000);
    }

    @Override
    public ByteArrayRef getExceptionByteArrayRef() {
        return this.exceptionByteArrayRef;
    }

    @Override
    public void setExceptionByteArrayRef(ByteArrayRef exceptionByteArrayRef) {
        this.exceptionByteArrayRef = exceptionByteArrayRef;
    }

    private String getJobByteArrayRefAsString(ByteArrayRef jobByteArrayRef) {
        if (jobByteArrayRef == null) {
            return null;
        }
        return jobByteArrayRef.asString(this.getEngineType());
    }

    protected String getEngineType() {
        if (StringUtils.isNotEmpty((CharSequence)this.scopeType)) {
            return this.scopeType;
        }
        return "bpmn";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName().replace("Impl", "")).append("[").append("id=").append(this.id).append(", jobHandlerType=").append(this.jobHandlerType).append(", jobType=").append(this.jobType);
        if (this.category != null) {
            sb.append(", category=").append(this.category);
        }
        if (this.elementId != null) {
            sb.append(", elementId=").append(this.elementId);
        }
        if (this.correlationId != null) {
            sb.append(", correlationId=").append(this.correlationId);
        }
        if (this.executionId != null) {
            sb.append(", processInstanceId=").append(this.processInstanceId).append(", executionId=").append(this.executionId);
        } else if (this.scopeId != null) {
            sb.append(", scopeId=").append(this.scopeId).append(", subScopeId=").append(this.subScopeId).append(", scopeType=").append(this.scopeType);
        }
        if (this.processDefinitionId != null) {
            sb.append(", processDefinitionId=").append(this.processDefinitionId);
        } else if (this.scopeDefinitionId != null) {
            if (this.scopeId == null) {
                sb.append(", scopeType=").append(this.scopeType);
            }
            sb.append(", scopeDefinitionId=").append(this.scopeDefinitionId);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            sb.append(", tenantId=").append(this.tenantId);
        }
        sb.append("]");
        return sb.toString();
    }
}

