/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.api.JobNotFoundException;
import org.flowable.job.service.InternalJobCompatibilityManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.FailedJobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteJobCmd.class);
    protected String jobId;
    protected JobServiceConfiguration jobServiceConfiguration;

    public ExecuteJobCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobId = jobId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Object execute(CommandContext commandContext) {
        InternalJobCompatibilityManager internalJobCompatibilityManager;
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("JobId is null");
        }
        Job job = (Job)this.jobServiceConfiguration.getJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing job {}", (Object)job.getId());
        }
        if ((internalJobCompatibilityManager = this.jobServiceConfiguration.getInternalJobCompatibilityManager()) != null && internalJobCompatibilityManager.isFlowable5Job(job)) {
            internalJobCompatibilityManager.executeV5Job(job);
            return null;
        }
        commandContext.addCloseListener((CommandContextCloseListener)new FailedJobListener(this.jobServiceConfiguration.getCommandExecutor(), job, this.jobServiceConfiguration));
        this.jobServiceConfiguration.getJobManager().execute((JobInfo)job);
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

