/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;

public abstract class AbstractCSVSpec
implements Serializable {
    private static final long serialVersionUID = 2253975790270165334L;
    private static final String PARAM_COLUMNSEPARATOR = "columnSeparator";
    private static final String PARAM_ARRAYELEMENTSEPARATOR = "arrayElementSeparator";
    private static final String PARAM_QUOTECHAR = "quoteChar";
    private static final String PARAM_ESCAPECHAR = "escapeChar";
    private static final String PARAM_LINESEPARATOR = "lineSeparator";
    private static final String PARAM_NULLVALUE = "nullValue";
    private static final String PARAM_ALLOWCOMMENTS = "allowComments";
    private static final String PARAM_MATCHING_RULE = "matchingRule";
    private static final String PARAM_UNMATCHING_RULE = "unmatchingRule";
    protected String anyTypeKey;
    protected char columnSeparator = (char)44;
    protected String arrayElementSeparator = ";";
    protected char quoteChar = (char)34;
    protected Character escapeChar;
    protected String lineSeparator = "\n";
    protected String nullValue = "";
    protected Boolean allowComments;
    protected UnmatchingRule unmatchingRule = UnmatchingRule.PROVISION;
    protected MatchingRule matchingRule = MatchingRule.UPDATE;
    protected List<String> provisioningActions = new ArrayList<String>();

    @Parameter(name="anyTypeKey", description="any object type", schema=@Schema(implementation=String.class))
    public String getAnyTypeKey() {
        return this.anyTypeKey;
    }

    @NotNull
    @QueryParam(value="anyTypeKey")
    public void setAnyTypeKey(String anyTypeKey) {
        this.anyTypeKey = anyTypeKey;
    }

    @Parameter(name="columnSeparator", description="separator for column values", schema=@Schema(implementation=char.class, defaultValue=","))
    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    @QueryParam(value="columnSeparator")
    public void setColumnSeparator(char columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    @Parameter(name="arrayElementSeparator", description="separator for array elements within a column", schema=@Schema(implementation=String.class, defaultValue=";"))
    public String getArrayElementSeparator() {
        return this.arrayElementSeparator;
    }

    @QueryParam(value="arrayElementSeparator")
    public void setArrayElementSeparator(String arrayElementSeparator) {
        this.arrayElementSeparator = arrayElementSeparator;
    }

    @Parameter(name="quoteChar", description="character used for quoting values that contain quote characters or linefeeds", schema=@Schema(implementation=char.class, defaultValue="\""))
    public char getQuoteChar() {
        return this.quoteChar;
    }

    @QueryParam(value="quoteChar")
    public void setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    @Parameter(name="escapeChar", description="if any, used to escape values; most commonly defined as backslash", schema=@Schema(implementation=Character.class))
    public Character getEscapeChar() {
        return this.escapeChar;
    }

    @QueryParam(value="escapeChar")
    public void setEscapeChar(Character escapeChar) {
        this.escapeChar = escapeChar;
    }

    @Parameter(name="lineSeparator", description="character used to separate data rows", schema=@Schema(implementation=String.class, defaultValue="\\u000a"))
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @QueryParam(value="lineSeparator")
    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Parameter(name="nullValue", description="when asked to write null, this string value will be used instead", schema=@Schema(implementation=String.class, defaultValue=""))
    public String getNullValue() {
        return this.nullValue;
    }

    @QueryParam(value="nullValue")
    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    @Parameter(name="allowComments", description="are hash comments, e.g. lines where the first non-whitespace character is '#' allowed? if so, they will be skipped without processing", schema=@Schema(implementation=boolean.class, defaultValue="false"))
    public Boolean getAllowComments() {
        return this.allowComments == null ? Boolean.FALSE : this.allowComments;
    }

    @QueryParam(value="allowComments")
    @DefaultValue(value="false")
    public void setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
    }

    @Parameter(name="unmatchingRule", required=true, schema=@Schema(implementation=UnmatchingRule.class, defaultValue="PROVISION"))
    public UnmatchingRule getUnmatchingRule() {
        return this.unmatchingRule;
    }

    @QueryParam(value="unmatchingRule")
    public void setUnmatchingRule(UnmatchingRule unmatchingRule) {
        this.unmatchingRule = unmatchingRule;
    }

    @Parameter(name="matchingRule", required=true, schema=@Schema(implementation=MatchingRule.class, defaultValue="UPDATE"))
    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    @QueryParam(value="matchingRule")
    public void setMatchingRule(MatchingRule matchingRule) {
        this.matchingRule = matchingRule;
    }

    public List<String> getProvisioningActions() {
        return this.provisioningActions;
    }

    @QueryParam(value="provisioningActions")
    public void setProvisioningActions(List<String> provisioningActions) {
        this.provisioningActions = provisioningActions;
    }

    protected static abstract class Builder<T extends AbstractCSVSpec, B extends Builder<T, B>> {
        protected T instance;

        protected Builder() {
        }

        protected abstract T newInstance();

        protected T getInstance() {
            if (this.instance == null) {
                this.instance = this.newInstance();
            }
            return this.instance;
        }

        public B columnSeparator(char columnSeparator) {
            ((AbstractCSVSpec)this.getInstance()).setColumnSeparator(columnSeparator);
            return (B)this;
        }

        public B arrayElementSeparator(String arrayElementSeparator) {
            ((AbstractCSVSpec)this.getInstance()).setArrayElementSeparator(arrayElementSeparator);
            return (B)this;
        }

        public B quoteChar(char quoteChar) {
            ((AbstractCSVSpec)this.getInstance()).setQuoteChar(quoteChar);
            return (B)this;
        }

        public B escapeChar(char escapeChar) {
            ((AbstractCSVSpec)this.getInstance()).setEscapeChar(Character.valueOf(escapeChar));
            return (B)this;
        }

        public B lineSeparator(String lineSeparatorChar) {
            ((AbstractCSVSpec)this.getInstance()).setLineSeparator(lineSeparatorChar);
            return (B)this;
        }

        public B nullValue(String nullValue) {
            ((AbstractCSVSpec)this.getInstance()).setNullValue(nullValue);
            return (B)this;
        }

        public B allowComments(boolean allowComments) {
            ((AbstractCSVSpec)this.getInstance()).setAllowComments(allowComments);
            return (B)this;
        }

        public B unmatchingRule(UnmatchingRule unmatchingRule) {
            ((AbstractCSVSpec)this.getInstance()).setUnmatchingRule(unmatchingRule);
            return (B)this;
        }

        public B matchingRule(MatchingRule matchingRule) {
            ((AbstractCSVSpec)this.getInstance()).setMatchingRule(matchingRule);
            return (B)this;
        }

        public B provisioningAction(String provisioningActions) {
            ((AbstractCSVSpec)this.getInstance()).getProvisioningActions().add(provisioningActions);
            return (B)this;
        }

        public T build() {
            return this.getInstance();
        }
    }
}

