/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.job;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobNamer {
    private static final Logger LOG = LoggerFactory.getLogger(JobNamer.class);

    private static Optional<String> getKeyFromJobName(String name, String pattern, int prefixLength) {
        String result = null;
        Matcher jobMatcher = Pattern.compile(pattern).matcher(name);
        if (jobMatcher.matches()) {
            try {
                result = name.substring(prefixLength);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unparsable id: {}", (Object)name.substring(prefixLength), (Object)e);
            }
        }
        return Optional.ofNullable(result);
    }

    public static Optional<String> getTaskKeyFromJobName(String name) {
        return JobNamer.getKeyFromJobName(name, "taskJob[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 7);
    }

    public static Optional<String> getReportKeyFromJobName(String name) {
        return JobNamer.getKeyFromJobName(name, "reportJob[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 9);
    }

    public static String getJobName(Task<?> task) {
        return "taskJob" + task.getKey();
    }

    public static String getJobName(Report report) {
        return "reportJob" + report.getKey();
    }

    private JobNamer() {
    }
}

