/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.support.QueryValidation;

public class LessThan<O, A extends Comparable<A>>
extends SimpleQuery<O, A> {
    private final A value;
    private final boolean valueInclusive;

    public LessThan(Attribute<O, A> attribute, A value, boolean valueInclusive) {
        super(attribute);
        this.value = (Comparable)QueryValidation.checkQueryValueNotNull(value);
        this.valueInclusive = valueInclusive;
    }

    public A getValue() {
        return this.value;
    }

    public boolean isValueInclusive() {
        return this.valueInclusive;
    }

    public String toString() {
        if (this.valueInclusive) {
            return "lessThanOrEqualTo(" + LessThan.asLiteral(super.getAttributeName()) + ", " + LessThan.asLiteral(this.value) + ")";
        }
        return "lessThan(" + LessThan.asLiteral(super.getAttributeName()) + ", " + LessThan.asLiteral(this.value) + ")";
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Comparable attributeValue = (Comparable)attribute.getValue(object, queryOptions);
        if (this.valueInclusive) {
            return this.value.compareTo((Comparable)attributeValue) >= 0;
        }
        return this.value.compareTo((Comparable)attributeValue) > 0;
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Iterable<A> attributeValues = attribute.getValues(object, queryOptions);
        if (this.valueInclusive) {
            for (Comparable attributeValue : attributeValues) {
                if (this.value.compareTo((Comparable)attributeValue) < 0) continue;
                return true;
            }
        } else {
            for (Comparable attributeValue : attributeValues) {
                if (this.value.compareTo((Comparable)attributeValue) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LessThan)) {
            return false;
        }
        LessThan lessThan = (LessThan)o;
        if (!this.attribute.equals(lessThan.attribute)) {
            return false;
        }
        if (this.valueInclusive != lessThan.valueInclusive) {
            return false;
        }
        return this.value.equals(lessThan.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.valueInclusive ? 1 : 0);
        return result;
    }
}

