/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.policy;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;

@Entity
@Table(name="PasswordPolicy")
public class JPAPasswordPolicy
extends AbstractPolicy
implements PasswordPolicy,
PersistenceCapable {
    private static final long serialVersionUID = 9138550910385232849L;
    public static final String TABLE = "PasswordPolicy";
    @NotNull
    private Boolean allowNullPassword = false;
    private int historyLength;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="PasswordPolicyRule", joinColumns={@JoinColumn(name="policy_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"policy_id", "implementation_id"})})
    private List<JPAImplementation> rules = new ArrayList<JPAImplementation>();
    private static int pcInheritedFieldCount = AbstractPolicy.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public boolean isAllowNullPassword() {
        return JPAPasswordPolicy.pcGetallowNullPassword(this);
    }

    public void setAllowNullPassword(boolean allowNullPassword) {
        JPAPasswordPolicy.pcSetallowNullPassword(this, allowNullPassword);
    }

    public int getHistoryLength() {
        return JPAPasswordPolicy.pcGethistoryLength(this);
    }

    public void setHistoryLength(int historyLength) {
        JPAPasswordPolicy.pcSethistoryLength(this, historyLength);
    }

    public boolean add(Implementation rule) {
        this.checkType(rule, JPAImplementation.class);
        this.checkImplementationType(rule, "PASSWORD_RULE");
        return JPAPasswordPolicy.pcGetrules(this).contains((JPAImplementation)rule) || JPAPasswordPolicy.pcGetrules(this).add((JPAImplementation)rule);
    }

    public List<? extends Implementation> getRules() {
        return JPAPasswordPolicy.pcGetrules(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractPolicy.class;
        pcFieldNames = new String[]{"allowNullPassword", "historyLength", "rules"};
        pcFieldTypes = new Class[]{Boolean.class, Integer.TYPE, List.class};
        pcFieldFlags = new byte[]{26, 26, 10};
        PCRegistry.register(JPAPasswordPolicy.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAPasswordPolicy", (PersistenceCapable)new JPAPasswordPolicy());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.allowNullPassword = null;
        this.historyLength = 0;
        this.rules = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAPasswordPolicy jPAPasswordPolicy = new JPAPasswordPolicy();
        if (bl) {
            jPAPasswordPolicy.pcClearFields();
        }
        jPAPasswordPolicy.pcStateManager = stateManager;
        jPAPasswordPolicy.pcCopyKeyFieldsFromObjectId(object);
        return jPAPasswordPolicy;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAPasswordPolicy jPAPasswordPolicy = new JPAPasswordPolicy();
        if (bl) {
            jPAPasswordPolicy.pcClearFields();
        }
        jPAPasswordPolicy.pcStateManager = stateManager;
        return jPAPasswordPolicy;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractPolicy.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowNullPassword = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.historyLength = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.rules = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.allowNullPassword);
                return;
            }
            case 1: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.historyLength);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.rules);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAPasswordPolicy jPAPasswordPolicy, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAPasswordPolicy, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.allowNullPassword = jPAPasswordPolicy.allowNullPassword;
                return;
            }
            case 1: {
                this.historyLength = jPAPasswordPolicy.historyLength;
                return;
            }
            case 2: {
                this.rules = jPAPasswordPolicy.rules;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAPasswordPolicy jPAPasswordPolicy = (JPAPasswordPolicy)object;
        if (jPAPasswordPolicy.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAPasswordPolicy, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAPasswordPolicy.class;
    }

    private static final Boolean pcGetallowNullPassword(JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            return jPAPasswordPolicy.allowNullPassword;
        }
        int n = pcInheritedFieldCount + 0;
        jPAPasswordPolicy.pcStateManager.accessingField(n);
        return jPAPasswordPolicy.allowNullPassword;
    }

    private static final void pcSetallowNullPassword(JPAPasswordPolicy jPAPasswordPolicy, Boolean bl) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            jPAPasswordPolicy.allowNullPassword = bl;
            return;
        }
        jPAPasswordPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPasswordPolicy, pcInheritedFieldCount + 0, (Object)jPAPasswordPolicy.allowNullPassword, (Object)bl, 0);
    }

    private static final int pcGethistoryLength(JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            return jPAPasswordPolicy.historyLength;
        }
        int n = pcInheritedFieldCount + 1;
        jPAPasswordPolicy.pcStateManager.accessingField(n);
        return jPAPasswordPolicy.historyLength;
    }

    private static final void pcSethistoryLength(JPAPasswordPolicy jPAPasswordPolicy, int n) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            jPAPasswordPolicy.historyLength = n;
            return;
        }
        jPAPasswordPolicy.pcStateManager.settingIntField((PersistenceCapable)jPAPasswordPolicy, pcInheritedFieldCount + 1, jPAPasswordPolicy.historyLength, n, 0);
    }

    private static final List pcGetrules(JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            return jPAPasswordPolicy.rules;
        }
        int n = pcInheritedFieldCount + 2;
        jPAPasswordPolicy.pcStateManager.accessingField(n);
        return jPAPasswordPolicy.rules;
    }

    private static final void pcSetrules(JPAPasswordPolicy jPAPasswordPolicy, List list) {
        if (jPAPasswordPolicy.pcStateManager == null) {
            jPAPasswordPolicy.rules = list;
            return;
        }
        jPAPasswordPolicy.pcStateManager.settingObjectField((PersistenceCapable)jPAPasswordPolicy, pcInheritedFieldCount + 2, jPAPasswordPolicy.rules, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

