/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.HashSet;
import java.util.Optional;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.ItemContainer;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.ExternalResourceCheck;
import org.identityconnectors.framework.common.objects.ObjectClass;

public class ExternalResourceValidator
extends AbstractValidator<ExternalResourceCheck, ExternalResource> {
    private static boolean areItemsValid(ItemContainer itemContainer, ConstraintValidatorContext context) {
        if (itemContainer.getItems().stream().anyMatch(item -> item.getIntAttrName() == null || item.getExtAttrName() == null || item.getPurpose() == null)) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidMapping, "intAttrName, extAttrName and purpose must be specified for each item")).addPropertyNode("items").addConstraintViolation();
            return false;
        }
        if (itemContainer.getConnObjectKeyItem().isEmpty()) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean isValid(OrgUnit orgUnit, ConstraintValidatorContext context) {
        if (orgUnit == null) {
            return true;
        }
        return ExternalResourceValidator.areItemsValid((ItemContainer)orgUnit, context);
    }

    private static boolean isValid(Mapping mapping, ConstraintValidatorContext context) {
        if (mapping == null) {
            return true;
        }
        boolean isValid = true;
        long passwords = mapping.getItems().stream().filter(Item::isPassword).count();
        if (passwords > 1L) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidMapping, "One password mapping is allowed at most")).addPropertyNode("password.size").addConstraintViolation();
            isValid = false;
        }
        return isValid && ExternalResourceValidator.areItemsValid((ItemContainer)mapping, context);
    }

    public boolean isValid(ExternalResource resource, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (resource.getKey() == null || !Entity.ID_PATTERN.matcher(resource.getKey()).matches()) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidKey, resource.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        HashSet anyTypes = new HashSet();
        HashSet objectClasses = new HashSet();
        boolean validMappings = resource.getProvisions().stream().allMatch(provision -> {
            anyTypes.add(provision.getAnyType());
            Optional.ofNullable(provision.getObjectClass()).ifPresent(objectClasses::add);
            return ExternalResourceValidator.isValid(provision.getMapping(), context);
        });
        validMappings &= ExternalResourceValidator.isValid(resource.getOrgUnit(), context);
        if (anyTypes.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different " + AnyType.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        if (objectClasses.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(ExternalResourceValidator.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different" + ObjectClass.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        return validMappings;
    }
}

