/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.ConnPoolConf;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.persistence.api.utils.URIUtils;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.ConnInstanceCheck;

public class ConnInstanceValidator
extends AbstractValidator<ConnInstanceCheck, ConnInstance> {
    public boolean isValid(ConnInstance connInstance, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (ConnInstanceValidator.isHtml(connInstance.getDisplayName())) {
            context.buildConstraintViolationWithTemplate(ConnInstanceValidator.getTemplate(EntityViolationType.InvalidName, connInstance.getDisplayName())).addPropertyNode("displayName").addConstraintViolation();
            isValid = false;
        }
        try {
            URIUtils.buildForConnId((String)connInstance.getLocation());
        }
        catch (Exception e) {
            LOG.error("While validating {}", (Object)connInstance.getLocation(), (Object)e);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(ConnInstanceValidator.getTemplate(EntityViolationType.InvalidConnInstanceLocation, e.getMessage())).addPropertyNode("location").addConstraintViolation();
            isValid = false;
        }
        if (isValid && connInstance.getPoolConf() != null) {
            try {
                ConnPoolConfUtils.getObjectPoolConfiguration((ConnPoolConf)connInstance.getPoolConf()).validate();
            }
            catch (Exception e) {
                LOG.error("Invalid pool configuration", (Throwable)e);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(ConnInstanceValidator.getTemplate(EntityViolationType.InvalidConnPoolConf, e.getMessage())).addPropertyNode("poolConf").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }
}

