/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.content;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractContentLoaderHandler
extends DefaultHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractContentLoaderHandler.class);
    private static final String CONF_DIR = "syncope.conf.dir";
    private final String rootElement;
    protected final boolean continueOnError;
    protected final Map<String, String> fetches = new HashMap<String, String>();
    protected final StringSubstitutor paramSubstitutor;

    protected AbstractContentLoaderHandler(String rootElement, boolean continueOnError, Environment env) {
        this.rootElement = rootElement;
        this.continueOnError = continueOnError;
        this.paramSubstitutor = new StringSubstitutor(key -> {
            String value = env.getProperty(key, this.fetches.get(key));
            if (value != null && CONF_DIR.equals(key)) {
                value = value.replace('\\', '/');
            }
            return StringUtils.isBlank((CharSequence)value) ? null : value;
        });
    }

    protected abstract void fetch(Attributes var1);

    protected abstract void create(String var1, Attributes var2);

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (this.rootElement.equals(qName)) {
            return;
        }
        if ("fetch".equalsIgnoreCase(qName)) {
            this.fetch(atts);
        } else {
            this.create(qName, atts);
        }
    }
}

