/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommandIntegrationTest;
import kafka.cluster.Broker;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.None$;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class ConfigCommandTest {
    private static final String ZK_CONNECT = "localhost:2181";
    private static final DummyAdminZkClient DUMMY_ADMIN_ZK_CLIENT = new DummyAdminZkClient(null);
    private static final List<String> ZOOKEEPER_BOOTSTRAP = Arrays.asList("--zookeeper", "localhost:2181");
    private static final List<String> BROKER_BOOTSTRAP = Arrays.asList("--bootstrap-server", "localhost:9092");
    private static final List<String> CONTROLLER_BOOTSTRAP = Arrays.asList("--bootstrap-controller", "localhost:9093");
    private final List<String> userEntityOpts = Arrays.asList("--entity-type", "users", "--entity-name", "admin");
    private final List<String> clientEntityOpts = Arrays.asList("--entity-type", "clients", "--entity-name", "admin");
    private final List<String> addScramOpts = Arrays.asList("--add-config", "SCRAM-SHA-256=[iterations=8192,password=foo-secret]");
    private final List<String> deleteScramOpts = Arrays.asList("--delete-config", "SCRAM-SHA-256");
    private List<String> connectOpts;
    private final KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);

    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        ConfigCommandTest.assertNonZeroStatusExit("--blah");
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandWithTopicsEntity() {
        ConfigCommandTest.assertNonZeroStatusExit(ConfigCommandTest.toArray(ZOOKEEPER_BOOTSTRAP, Arrays.asList("--entity-type", "topics", "--describe")));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandWithClientsEntity() {
        ConfigCommandTest.assertNonZeroStatusExit(ConfigCommandTest.toArray(ZOOKEEPER_BOOTSTRAP, Arrays.asList("--entity-type", "clients", "--describe")));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandWithIpsEntity() {
        ConfigCommandTest.assertNonZeroStatusExit(ConfigCommandTest.toArray(ZOOKEEPER_BOOTSTRAP, Arrays.asList("--entity-type", "ips", "--describe")));
    }

    @Test
    public void shouldExitWithNonZeroStatusAlterUserQuotaWithoutEntityName() {
        ConfigCommandTest.assertNonZeroStatusExit(ConfigCommandTest.toArray(BROKER_BOOTSTRAP, Arrays.asList("--entity-type", "users", "--alter", "--add-config", "consumer_byte_rate=20000")));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        ConfigCommandTest.assertNonZeroStatusExit("--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe");
    }

    @Test
    public void shouldExitWithNonZeroStatusIfBothBootstrapServerAndBootstrapControllerGiven() {
        ConfigCommandTest.assertNonZeroStatusExit(ConfigCommandTest.toArray(BROKER_BOOTSTRAP, CONTROLLER_BOOTSTRAP, Arrays.asList("--describe", "--broker-defaults")));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandWithZkTlsConfigFile() {
        ConfigCommandTest.assertNonZeroStatusExit("--bootstrap-server", "invalid host", "--entity-type", "users", "--zk-tls-config-file", "zk_tls_config.properties", "--describe");
    }

    public static void assertNonZeroStatusExit(String ... args) {
        AtomicReference exitStatus = new AtomicReference();
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        try {
            ConfigCommand.main((String[])args);
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertNotNull(exitStatus.get());
        Assertions.assertEquals((int)1, (Integer)((Integer)exitStatus.get()));
    }

    @Test
    public void shouldFailParseArgumentsForClientsEntityTypeUsingZookeeper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testArgumentParse(ZOOKEEPER_BOOTSTRAP, "clients"));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "clients");
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "clients");
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse(ZOOKEEPER_BOOTSTRAP, "users");
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "users");
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "users");
    }

    @Test
    public void shouldFailParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testArgumentParse(ZOOKEEPER_BOOTSTRAP, "topics"));
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "topics");
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "topics");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse(ZOOKEEPER_BOOTSTRAP, "brokers");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "brokers");
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "brokers");
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "broker-loggers");
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "broker-loggers");
    }

    @Test
    public void shouldFailParseArgumentsForIpEntityTypeUsingZookeeper() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testArgumentParse(ZOOKEEPER_BOOTSTRAP, "ips"));
    }

    @Test
    public void shouldParseArgumentsForIpEntityTypeWithBrokerBootstrap() {
        this.testArgumentParse(BROKER_BOOTSTRAP, "ips");
    }

    @Test
    public void shouldParseArgumentsForIpEntityTypeWithControllerBootstrap() {
        this.testArgumentParse(CONTROLLER_BOOTSTRAP, "ips");
    }

    public void testArgumentParse(List<String> bootstrapArguments, String entityType) {
        String shortFlag = "--" + entityType.substring(0, entityType.length() - 1);
        String connectOpts1 = bootstrapArguments.get(0);
        String connectOpts2 = bootstrapArguments.get(1);
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--describe"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--describe"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config-file", "/tmp/new.properties"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config", "a=b,c=d"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config-file", "/tmp/new.properties"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--delete-config", "a,b,c"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand.parseConfigsToBeAdded((ConfigCommand.ConfigCommandOptions)createOpts);
        Assertions.assertEquals((int)2, (int)addedProps.size());
        Assertions.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assertions.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand.parseConfigsToBeDeleted((ConfigCommand.ConfigCommandOptions)createOpts);
        Assertions.assertEquals((int)1, (int)deletedProps.size());
        Assertions.assertEquals((Object)"a", (Object)deletedProps.apply(0));
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config", "a._-c=b,c=,d=e,f="));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand.parseConfigsToBeAdded((ConfigCommand.ConfigCommandOptions)createOpts);
        Assertions.assertEquals((int)4, (int)addedProps2.size());
        Assertions.assertEquals((Object)"b", (Object)addedProps2.getProperty("a._-c"));
        Assertions.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assertions.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assertions.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
        ConfigCommand.ConfigCommandOptions inValidCreateOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config", "a;c=b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.parseConfigsToBeAdded((ConfigCommand.ConfigCommandOptions)inValidCreateOpts));
        ConfigCommand.ConfigCommandOptions inValidCreateOpts2 = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(connectOpts1, connectOpts2, shortFlag, "1", "--alter", "--add-config", "a,=b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.parseConfigsToBeAdded((ConfigCommand.ConfigCommandOptions)inValidCreateOpts2));
    }

    @Test
    public void shouldFailIfAddAndAddFile() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d", "--add-config-file", "/tmp/new.properties"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void testParseConfigsToBeAddedForAddConfigFile() throws IOException {
        String fileContents = "a=b\nc = d\njson = {\"key\": \"val\"}\nnested = [[1, 2], [3, 4]]";
        File file = TestUtils.tempFile((String)fileContents);
        List<String> addConfigFileArgs = Arrays.asList("--add-config-file", file.getPath());
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter"), addConfigFileArgs));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand.parseConfigsToBeAdded((ConfigCommand.ConfigCommandOptions)createOpts);
        Assertions.assertEquals((int)4, (int)addedProps.size());
        Assertions.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assertions.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Assertions.assertEquals((Object)"{\"key\": \"val\"}", (Object)addedProps.getProperty("json"));
        Assertions.assertEquals((Object)"[[1, 2], [3, 4]]", (Object)addedProps.getProperty("nested"));
    }

    public void testExpectedEntityTypeNames(List<String> expectedTypes, List<String> expectedNames, List<String> connectOpts, String ... args) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList(connectOpts.get(0), connectOpts.get(1), "--describe"), Arrays.asList(args)));
        createOpts.checkArgs();
        Assertions.assertEquals((Object)createOpts.entityTypes().toSeq(), ConfigCommandIntegrationTest.seq(expectedTypes));
        Assertions.assertEquals((Object)createOpts.entityNames().toSeq(), ConfigCommandIntegrationTest.seq(expectedNames));
    }

    public void doTestOptionEntityTypeNames(boolean zkConfig) {
        List<String> connectOpts;
        List<String> list = connectOpts = zkConfig ? Arrays.asList("--zookeeper", ZK_CONNECT) : Arrays.asList("--bootstrap-server", "localhost:9092");
        if (!zkConfig) {
            this.testExpectedEntityTypeNames(Collections.singletonList("topics"), Collections.singletonList("A"), connectOpts, "--entity-type", "topics", "--entity-name", "A");
            this.testExpectedEntityTypeNames(Collections.singletonList("ips"), Collections.singletonList("1.2.3.4"), connectOpts, "--entity-name", "1.2.3.4", "--entity-type", "ips");
            this.testExpectedEntityTypeNames(Arrays.asList("users", "clients"), Arrays.asList("A", ""), connectOpts, "--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default");
            this.testExpectedEntityTypeNames(Arrays.asList("users", "clients"), Arrays.asList("", "B"), connectOpts, "--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients");
            this.testExpectedEntityTypeNames(Collections.singletonList("topics"), Collections.singletonList("A"), connectOpts, "--topic", "A");
            this.testExpectedEntityTypeNames(Collections.singletonList("ips"), Collections.singletonList("1.2.3.4"), connectOpts, "--ip", "1.2.3.4");
            this.testExpectedEntityTypeNames(Arrays.asList("clients", "users"), Arrays.asList("B", "A"), connectOpts, "--client", "B", "--user", "A");
            this.testExpectedEntityTypeNames(Arrays.asList("clients", "users"), Arrays.asList("B", ""), connectOpts, "--client", "B", "--user-defaults");
            this.testExpectedEntityTypeNames(Arrays.asList("clients", "users"), Collections.singletonList("A"), connectOpts, "--entity-type", "clients", "--entity-type", "users", "--entity-name", "A");
            this.testExpectedEntityTypeNames(Collections.singletonList("topics"), Collections.emptyList(), connectOpts, "--entity-type", "topics");
            this.testExpectedEntityTypeNames(Collections.singletonList("ips"), Collections.emptyList(), connectOpts, "--entity-type", "ips");
        }
        this.testExpectedEntityTypeNames(Collections.singletonList("brokers"), Collections.singletonList("0"), connectOpts, "--entity-name", "0", "--entity-type", "brokers");
        this.testExpectedEntityTypeNames(Collections.singletonList("brokers"), Collections.singletonList("0"), connectOpts, "--broker", "0");
        this.testExpectedEntityTypeNames(Collections.singletonList("users"), Collections.emptyList(), connectOpts, "--entity-type", "users");
        this.testExpectedEntityTypeNames(Collections.singletonList("brokers"), Collections.emptyList(), connectOpts, "--entity-type", "brokers");
    }

    @Test
    public void testOptionEntityTypeNamesUsingZookeeper() {
        this.doTestOptionEntityTypeNames(true);
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.doTestOptionEntityTypeNames(false);
    }

    @Test
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldFailIfMixedEntityTypeFlags() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldFailIfInvalidHost() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A,B", "--entity-type", "ips", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldFailIfInvalidHostUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "A,B", "--entity-type", "ips", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldFailIfUnresolvableHost() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "RFC2606.invalid", "--entity-type", "ips", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldFailIfUnresolvableHostUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "RFC2606.invalid", "--entity-type", "ips", "--describe"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)createOpts).checkArgs());
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"});
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        class TestAdminZkClient
        extends AdminZkClient {
            public TestAdminZkClient(KafkaZkClient zkClient) {
                super(zkClient, None$.empty());
            }

            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assertions.assertEquals((Object)"my-client-id", (Object)clientId);
                Assertions.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assertions.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        }
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)new TestAdminZkClient(zkClient));
    }

    @Test
    public void shouldAddIpConfigsUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", ZK_CONNECT, "--entity-name", "1.2.3.4", "--entity-type", "ips", "--alter", "--add-config", "a=b,c=d"});
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        class TestAdminZkClient
        extends AdminZkClient {
            public TestAdminZkClient(KafkaZkClient zkClient) {
                super(zkClient, None$.empty());
            }

            public void changeIpConfig(String ip, Properties configChange) {
                Assertions.assertEquals((Object)"1.2.3.4", (Object)ip);
                Assertions.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assertions.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        }
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)new TestAdminZkClient(zkClient));
    }

    private Map.Entry<List<String>, java.util.Map<String, String>> argsAndExpectedEntity(Optional<String> entityName, String entityType) {
        String command;
        switch (entityType) {
            case "user": {
                command = "users";
                break;
            }
            case "client-id": {
                command = "clients";
                break;
            }
            case "ip": {
                command = "ips";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command: " + entityType);
            }
        }
        return entityName.map(name -> {
            if (name.isEmpty()) {
                return new AbstractMap.SimpleImmutableEntry<List<String>, java.util.Map<String, String>>(Arrays.asList("--entity-type", command, "--entity-default"), Collections.singletonMap(entityType, null));
            }
            return new AbstractMap.SimpleImmutableEntry<List<String>, java.util.Map<String, String>>(Arrays.asList("--entity-type", command, "--entity-name", name), Collections.singletonMap(entityType, name));
        }).orElse(new AbstractMap.SimpleImmutableEntry(Collections.emptyList(), Collections.emptyMap()));
    }

    private void verifyAlterCommandFails(String expectedErrorMessage, List<String> alterOpts) {
        Admin mockAdminClient = (Admin)Mockito.mock(Admin.class);
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--alter"), alterOpts));
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)opts));
        Assertions.assertTrue((boolean)e.getMessage().contains(expectedErrorMessage), (String)("Unexpected exception: " + e));
    }

    @Test
    public void shouldNotAlterNonQuotaIpConfigsUsingBootstrapServer() {
        List<String> ipEntityOpts = Arrays.asList("--entity-type", "ips", "--entity-name", "127.0.0.1");
        String invalidProp = "some_config";
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(ipEntityOpts, Arrays.asList("--add-config", "connection_creation_rate=10000,some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(ipEntityOpts, Arrays.asList("--add-config", "some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(ipEntityOpts, Arrays.asList("--delete-config", "connection_creation_rate=10000,some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(ipEntityOpts, Arrays.asList("--delete-config", "some_config=10")));
    }

    private void verifyDescribeQuotas(List<String> describeArgs, final ClientQuotaFilter expectedFilter) {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--describe"), describeArgs));
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.complete(Collections.emptyMap());
        final DescribeClientQuotasResult describeResult = (DescribeClientQuotasResult)Mockito.mock(DescribeClientQuotasResult.class);
        Mockito.when((Object)describeResult.entities()).thenReturn((Object)describeFuture);
        final AtomicBoolean describedConfigs = new AtomicBoolean();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
                Assertions.assertTrue((boolean)filter.strict());
                Assertions.assertEquals(new HashSet(expectedFilter.components()), new HashSet(filter.components()));
                describedConfigs.set(true);
                return describeResult;
            }
        };
        ConfigCommand.describeConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)describeOpts);
        Assertions.assertTrue((boolean)describedConfigs.get());
    }

    @Test
    public void testDescribeIpConfigs() {
        String entityType = "ip";
        String knownHost = "1.2.3.4";
        ClientQuotaFilter defaultIpFilter = ClientQuotaFilter.containsOnly(Collections.singletonList(ClientQuotaFilterComponent.ofDefaultEntity((String)entityType)));
        ClientQuotaFilter singleIpFilter = ClientQuotaFilter.containsOnly(Collections.singletonList(ClientQuotaFilterComponent.ofEntity((String)entityType, (String)knownHost)));
        ClientQuotaFilter allIpsFilter = ClientQuotaFilter.containsOnly(Collections.singletonList(ClientQuotaFilterComponent.ofEntityType((String)entityType)));
        this.verifyDescribeQuotas(Arrays.asList("--entity-default", "--entity-type", "ips"), defaultIpFilter);
        this.verifyDescribeQuotas(Collections.singletonList("--ip-defaults"), defaultIpFilter);
        this.verifyDescribeQuotas(Arrays.asList("--entity-type", "ips", "--entity-name", knownHost), singleIpFilter);
        this.verifyDescribeQuotas(Arrays.asList("--ip", knownHost), singleIpFilter);
        this.verifyDescribeQuotas(Arrays.asList("--entity-type", "ips"), allIpsFilter);
    }

    public void verifyAlterQuotas(List<String> alterOpts, final ClientQuotaEntity expectedAlterEntity, java.util.Map<String, Double> expectedProps, final Set<ClientQuotaAlteration.Op> expectedAlterOps) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--alter"), alterOpts));
        final AtomicBoolean describedConfigs = new AtomicBoolean();
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.complete(Collections.singletonMap(expectedAlterEntity, expectedProps));
        final DescribeClientQuotasResult describeResult = (DescribeClientQuotasResult)Mockito.mock(DescribeClientQuotasResult.class);
        Mockito.when((Object)describeResult.entities()).thenReturn((Object)describeFuture);
        final Set expectedFilterComponents = expectedAlterEntity.entries().entrySet().stream().map(e -> {
            String entityType = (String)e.getKey();
            String entityName = (String)e.getValue();
            return entityName == null ? ClientQuotaFilterComponent.ofDefaultEntity((String)((String)e.getKey())) : ClientQuotaFilterComponent.ofEntity((String)entityType, (String)entityName);
        }).collect(Collectors.toSet());
        final AtomicBoolean alteredConfigs = new AtomicBoolean();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        final AlterClientQuotasResult alterResult = (AlterClientQuotasResult)Mockito.mock(AlterClientQuotasResult.class);
        Mockito.when((Object)alterResult.all()).thenReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
                Assertions.assertTrue((boolean)filter.strict());
                Assertions.assertEquals((Object)expectedFilterComponents, new HashSet(filter.components()));
                describedConfigs.set(true);
                return describeResult;
            }

            public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
                Assertions.assertFalse((boolean)options.validateOnly());
                Assertions.assertEquals((int)1, (int)entries.size());
                ClientQuotaAlteration alteration = entries.iterator().next();
                Assertions.assertEquals((Object)expectedAlterEntity, (Object)alteration.entity());
                Collection ops = alteration.ops();
                Assertions.assertEquals((Object)expectedAlterOps, new HashSet(ops));
                alteredConfigs.set(true);
                return alterResult;
            }
        };
        ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)createOpts);
        Assertions.assertTrue((boolean)describedConfigs.get());
        Assertions.assertTrue((boolean)alteredConfigs.get());
    }

    @Test
    public void testAlterIpConfig() {
        Map.Entry<List<String>, java.util.Map<String, String>> singleIpArgsAndEntity = this.argsAndExpectedEntity(Optional.of("1.2.3.4"), "ip");
        Map.Entry<List<String>, java.util.Map<String, String>> defaultIpArgsAndEntity = this.argsAndExpectedEntity(Optional.of(""), "ip");
        List<String> deleteArgs = Arrays.asList("--delete-config", "connection_creation_rate");
        HashSet<ClientQuotaAlteration.Op> deleteAlterationOps = new HashSet<ClientQuotaAlteration.Op>(Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null)));
        java.util.Map<String, Double> propsToDelete = Collections.singletonMap("connection_creation_rate", 50.0);
        List<String> addArgs = Arrays.asList("--add-config", "connection_creation_rate=100");
        HashSet<ClientQuotaAlteration.Op> addAlterationOps = new HashSet<ClientQuotaAlteration.Op>(Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Double.valueOf(100.0))));
        this.verifyAlterQuotas(ConfigCommandTest.concat(singleIpArgsAndEntity.getKey(), deleteArgs), new ClientQuotaEntity(singleIpArgsAndEntity.getValue()), propsToDelete, deleteAlterationOps);
        this.verifyAlterQuotas(ConfigCommandTest.concat(singleIpArgsAndEntity.getKey(), addArgs), new ClientQuotaEntity(singleIpArgsAndEntity.getValue()), Collections.emptyMap(), addAlterationOps);
        this.verifyAlterQuotas(ConfigCommandTest.concat(defaultIpArgsAndEntity.getKey(), deleteArgs), new ClientQuotaEntity(defaultIpArgsAndEntity.getValue()), propsToDelete, deleteAlterationOps);
        this.verifyAlterQuotas(ConfigCommandTest.concat(defaultIpArgsAndEntity.getKey(), addArgs), new ClientQuotaEntity(defaultIpArgsAndEntity.getValue()), Collections.emptyMap(), addAlterationOps);
    }

    private void verifyAlterUserClientQuotas(String user, String client) {
        List<String> alterArgs = Arrays.asList("--add-config", "consumer_byte_rate=20000,producer_byte_rate=10000", "--delete-config", "request_percentage");
        java.util.Map<String, Double> propsToDelete = Collections.singletonMap("request_percentage", 50.0);
        HashSet<ClientQuotaAlteration.Op> alterationOps = new HashSet<ClientQuotaAlteration.Op>(Arrays.asList(new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(20000.0)), new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(10000.0)), new ClientQuotaAlteration.Op("request_percentage", null)));
        Map.Entry<List<String>, java.util.Map<String, String>> userArgsAndEntity = this.argsAndExpectedEntity(Optional.ofNullable(user), "user");
        Map.Entry<List<String>, java.util.Map<String, String>> clientArgsAndEntry = this.argsAndExpectedEntity(Optional.ofNullable(client), "client-id");
        this.verifyAlterQuotas(ConfigCommandTest.concat(alterArgs, userArgsAndEntity.getKey(), clientArgsAndEntry.getKey()), new ClientQuotaEntity(ConfigCommandTest.concat(userArgsAndEntity.getValue(), clientArgsAndEntry.getValue())), propsToDelete, alterationOps);
    }

    @Test
    public void shouldAddClientConfig() {
        this.verifyAlterUserClientQuotas("test-user-1", "test-client-1");
        this.verifyAlterUserClientQuotas("test-user-2", "");
        this.verifyAlterUserClientQuotas("test-user-3", null);
        this.verifyAlterUserClientQuotas("", "test-client-2");
        this.verifyAlterUserClientQuotas("", "");
        this.verifyAlterUserClientQuotas("", null);
        this.verifyAlterUserClientQuotas(null, "test-client-3");
        this.verifyAlterUserClientQuotas(null, "");
    }

    @Test
    public void shouldNotAlterNonQuotaNonScramUserOrClientConfigUsingBootstrapServer() {
        String invalidProp = "some_config";
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.userEntityOpts, Arrays.asList("-add-config", "consumer_byte_rate=20000,producer_byte_rate=10000,some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.userEntityOpts, Arrays.asList("--add-config", "consumer_byte_rate=20000,producer_byte_rate=10000,some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.clientEntityOpts, Arrays.asList("--add-config", "some_config=10")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.userEntityOpts, Arrays.asList("--delete-config", "consumer_byte_rate,some_config")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.userEntityOpts, Arrays.asList("--delete-config", "SCRAM-SHA-256,some_config")));
        this.verifyAlterCommandFails(invalidProp, ConfigCommandTest.concat(this.clientEntityOpts, Arrays.asList("--delete-config", "some_config")));
    }

    @Test
    public void shouldNotAlterScramClientConfigUsingBootstrapServer() {
        this.verifyAlterCommandFails("SCRAM-SHA-256", ConfigCommandTest.concat(this.clientEntityOpts, this.addScramOpts));
        this.verifyAlterCommandFails("SCRAM-SHA-256", ConfigCommandTest.concat(this.clientEntityOpts, this.deleteScramOpts));
    }

    @Test
    public void shouldNotCreateUserScramCredentialConfigWithUnderMinimumIterationsUsingBootstrapServer() {
        this.verifyAlterCommandFails("SCRAM-SHA-256", ConfigCommandTest.concat(this.userEntityOpts, Arrays.asList("--add-config", "SCRAM-SHA-256=[iterations=100,password=foo-secret]")));
    }

    @Test
    public void shouldNotAlterUserScramCredentialAndClientQuotaConfigsSimultaneouslyUsingBootstrapServer() {
        String expectedErrorMessage = "SCRAM-SHA-256";
        List<String> secondUserEntityOpts = Arrays.asList("--entity-type", "users", "--entity-name", "admin1");
        List<String> addQuotaOpts = Arrays.asList("--add-config", "consumer_byte_rate=20000");
        List<String> deleteQuotaOpts = Arrays.asList("--delete-config", "consumer_byte_rate");
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, this.addScramOpts, this.userEntityOpts, deleteQuotaOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, this.addScramOpts, secondUserEntityOpts, deleteQuotaOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, this.deleteScramOpts, this.userEntityOpts, addQuotaOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, this.deleteScramOpts, secondUserEntityOpts, addQuotaOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, deleteQuotaOpts, this.userEntityOpts, this.addScramOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(secondUserEntityOpts, deleteQuotaOpts, this.userEntityOpts, this.addScramOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(this.userEntityOpts, addQuotaOpts, this.userEntityOpts, this.deleteScramOpts));
        this.verifyAlterCommandFails(expectedErrorMessage, ConfigCommandTest.concat(secondUserEntityOpts, addQuotaOpts, this.userEntityOpts, this.deleteScramOpts));
    }

    public void verifyUserScramCredentialsNotDescribed(List<String> requestOpts) {
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        describeFuture.complete(Collections.singletonMap(new ClientQuotaEntity(Collections.singletonMap("", "")), Collections.singletonMap("request_percentage", 50.0)));
        final DescribeClientQuotasResult describeClientQuotasResult = (DescribeClientQuotasResult)Mockito.mock(DescribeClientQuotasResult.class);
        Mockito.when((Object)describeClientQuotasResult.entities()).thenReturn((Object)describeFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
                return describeClientQuotasResult;
            }

            public DescribeUserScramCredentialsResult describeUserScramCredentials(List<String> users, DescribeUserScramCredentialsOptions options) {
                throw new IllegalStateException("Incorrectly described SCRAM credentials when specifying --entity-default with --bootstrap-server");
            }
        };
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--describe"), requestOpts));
        ConfigCommand.describeConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)opts);
    }

    @Test
    public void shouldNotDescribeUserScramCredentialsWithEntityDefaultUsingBootstrapServer() {
        String expectedMsg = "The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.";
        List<String> defaultUserOpt = Collections.singletonList("--user-defaults");
        List<String> verboseDefaultUserOpts = Arrays.asList("--entity-type", "users", "--entity-default");
        this.verifyAlterCommandFails(expectedMsg, ConfigCommandTest.concat(verboseDefaultUserOpts, this.addScramOpts));
        this.verifyAlterCommandFails(expectedMsg, ConfigCommandTest.concat(verboseDefaultUserOpts, this.deleteScramOpts));
        this.verifyUserScramCredentialsNotDescribed(verboseDefaultUserOpts);
        this.verifyAlterCommandFails(expectedMsg, ConfigCommandTest.concat(defaultUserOpt, this.addScramOpts));
        this.verifyAlterCommandFails(expectedMsg, ConfigCommandTest.concat(defaultUserOpt, this.deleteScramOpts));
        this.verifyUserScramCredentialsNotDescribed(defaultUserOpt);
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"));
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)new AdminZkClient(zkClient, None$.empty()){

            public void changeTopicConfig(String topic, Properties configChange) {
                Assertions.assertEquals((Object)"my-topic", (Object)topic);
                Assertions.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assertions.assertEquals((Object)"d", (Object)configChange.get("c"));
            }
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldAlterTopicConfig(boolean file) {
        String filePath = "";
        HashMap<String, String> addedConfigs = new HashMap<String, String>();
        addedConfigs.put("delete.retention.ms", "1000000");
        addedConfigs.put("min.insync.replicas", "2");
        if (file) {
            File f = kafka.utils.TestUtils.tempPropertiesFile((Map<String, String>)JavaConverters.mapAsScalaMap(addedConfigs));
            filePath = f.getPath();
        }
        final String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", file ? "--add-config-file" : "--add-config", file ? filePath : addedConfigs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")), "--delete-config", "unclean.leader.election.enable"));
        final AtomicBoolean alteredConfigs = new AtomicBoolean();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        List<ConfigEntry> configEntries = Arrays.asList(this.newConfigEntry("min.insync.replicas", "1"), this.newConfigEntry("unclean.leader.election.enable", "1"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        final AlterConfigsResult alterResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)alterResult.all()).thenReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertFalse((boolean)options.includeSynonyms(), (String)"Config synonyms requested unnecessarily");
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource res = resources.iterator().next();
                Assertions.assertEquals((Object)res.type(), (Object)ConfigResource.Type.TOPIC);
                Assertions.assertEquals((Object)res.name(), (Object)resourceName);
                return describeResult;
            }

            public synchronized AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assertions.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)entry.getKey().type());
                Assertions.assertEquals((int)3, (int)alterConfigOps.size());
                HashSet<AlterConfigOp> expectedConfigOps = new HashSet<AlterConfigOp>(Arrays.asList(new AlterConfigOp(ConfigCommandTest.this.newConfigEntry("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.this.newConfigEntry("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.this.newConfigEntry("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)));
                Assertions.assertEquals((int)expectedConfigOps.size(), (int)alterConfigOps.size());
                expectedConfigOps.forEach(expectedOp -> {
                    Optional<AlterConfigOp> actual = alterConfigOps.stream().filter(op -> Objects.equals(op.configEntry().name(), expectedOp.configEntry().name())).findFirst();
                    Assertions.assertTrue((boolean)actual.isPresent());
                    Assertions.assertEquals((Object)expectedOp.opType(), (Object)actual.get().opType());
                    Assertions.assertEquals((Object)expectedOp.configEntry().name(), (Object)actual.get().configEntry().name());
                    Assertions.assertEquals((Object)expectedOp.configEntry().value(), (Object)actual.get().configEntry().value());
                });
                alteredConfigs.set(true);
                return alterResult;
            }
        };
        ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)alterOpts);
        Assertions.assertTrue((boolean)alteredConfigs.get());
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    public ConfigEntry newConfigEntry(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, Collections.emptyList());
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"));
        final ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertTrue((boolean)options.includeSynonyms(), (String)"Synonyms not requested");
                Assertions.assertEquals(Collections.singleton(resource), new HashSet<ConfigResource>(resources));
                return describeResult;
            }
        };
        ConfigCommand.describeConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)describeOpts);
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    @Test
    public void shouldNotAllowAddBrokerQuotaConfigWhileBrokerUpUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"));
        KafkaZkClient mockZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Broker mockBroker = (Broker)Mockito.mock(Broker.class);
        Mockito.when((Object)mockZkClient.getBroker(1)).thenReturn((Object)Option.apply((Object)mockBroker));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk((KafkaZkClient)mockZkClient, (ConfigCommand.ConfigCommandOptions)alterOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldNotAllowDescribeBrokerWhileBrokerUpUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--describe"));
        KafkaZkClient mockZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Broker mockBroker = (Broker)Mockito.mock(Broker.class);
        Mockito.when((Object)mockZkClient.getBroker(1)).thenReturn((Object)Option.apply((Object)mockBroker));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.describeConfigWithZk((KafkaZkClient)mockZkClient, (ConfigCommand.ConfigCommandOptions)describeOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldSupportDescribeBrokerBeforeBrokerUpUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--describe"));
        KafkaZkClient mockZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)mockZkClient.getBroker(1)).thenReturn((Object)None$.empty());
        class TestAdminZkClient
        extends AdminZkClient {
            public TestAdminZkClient(KafkaZkClient zkClient) {
                super(zkClient, None$.empty());
            }

            public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
                Assertions.assertEquals((Object)"brokers", (Object)rootEntityType);
                Assertions.assertEquals((Object)"1", (Object)sanitizedEntityName);
                return new Properties();
            }
        }
        ConfigCommand.describeConfigWithZk((KafkaZkClient)mockZkClient, (ConfigCommand.ConfigCommandOptions)describeOpts, (AdminZkClient)new TestAdminZkClient(null));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", Arrays.asList(new ConfigEntry("kafka.log.LogCleaner", "INFO"), new ConfigEntry("kafka.server.ReplicaManager", "INFO"), new ConfigEntry("kafka.server.KafkaApi", "INFO")));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        String[] optsList = new String[]{"--zookeeper", ZK_CONNECT, "--entity-type", "brokers", "--describe"};
        new ConfigCommand.ConfigCommandOptions(optsList).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        String[] optsList = new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"};
        new ConfigCommand.ConfigCommandOptions(optsList).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        String[] optsList = new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--entity-name", "1", "--describe", "--all"};
        new ConfigCommand.ConfigCommandOptions(optsList).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        String[] optsList = new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "topics", "--entity-name", "foo", "--describe", "--all"};
        new ConfigCommand.ConfigCommandOptions(optsList).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        String[] optsList = new String[]{"--zookeeper", ZK_CONNECT, "--entity-type", "brokers", "--entity-name", "1", "--describe", "--all"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigCommand.ConfigCommandOptions(optsList).checkArgs());
    }

    @Test
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        String[] optsList = new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand.BrokerLoggerConfigType(), "--entity-default", "--describe"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigCommand.ConfigCommandOptions(optsList).checkArgs());
    }

    @Test
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        String[] optsList = new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigCommand.ConfigCommandOptions(optsList).checkArgs());
    }

    @Test
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.verifyAlterBrokerLoggerConfig(node, "1", "1", Collections.singletonList(new ConfigEntry("kafka.server.KafkaApi", "INFO"))));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", Collections.singletonList("--entity-default"));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", Arrays.asList("--entity-name", "1"));
    }

    public void verifyAlterBrokerConfig(Node node, final String resourceName, List<String> resourceOpts) {
        String[] optsList = ConfigCommandTest.toArray(Arrays.asList("--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--alter", "--add-config", "message.max.bytes=10,leader.replication.throttled.rate=10"), resourceOpts);
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(optsList);
        final HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put("num.io.threads", "5");
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        final AlterConfigsResult alterResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)alterResult.all()).thenReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertFalse((boolean)options.includeSynonyms(), (String)"Config synonyms requested unnecessarily");
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource res = resources.iterator().next();
                Assertions.assertEquals((Object)ConfigResource.Type.BROKER, (Object)res.type());
                Assertions.assertEquals((Object)resourceName, (Object)res.name());
                return describeResult;
            }

            public synchronized AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource res = entry.getKey();
                Config config = entry.getValue();
                Assertions.assertEquals((Object)ConfigResource.Type.BROKER, (Object)res.type());
                config.entries().forEach(e -> brokerConfigs.put(e.name(), e.value()));
                return alterResult;
            }
        };
        ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)alterOpts);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("message.max.bytes", "10");
        expected.put("num.io.threads", "5");
        expected.put("leader.replication.throttled.rate", "10");
        Assertions.assertEquals(expected, brokerConfigs);
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    @Test
    public void shouldDescribeConfigBrokerWithoutEntityName() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"));
        String brokerDefaultEntityName = "";
        final ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.BROKER, "1");
        final ConfigResource resourceDefault = new ConfigResource(ConfigResource.Type.BROKER, brokerDefaultEntityName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Config emptyConfig = new Config(Collections.emptyList());
        HashMap<ConfigResource, Config> resultMap = new HashMap<ConfigResource, Config>();
        resultMap.put(resourceCustom, emptyConfig);
        resultMap.put(resourceDefault, emptyConfig);
        future.complete(resultMap);
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertTrue((boolean)options.includeSynonyms(), (String)"Synonyms not requested");
                ConfigResource resource = resources.iterator().next();
                Assertions.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assertions.assertTrue((Objects.equals(resourceCustom.name(), resource.name()) || Objects.equals(resourceDefault.name(), resource.name()) ? 1 : 0) != 0);
                Assertions.assertEquals((int)1, (int)resources.size());
                return describeResult;
            }
        };
        ConfigCommand.describeConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)describeOpts);
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult, (VerificationMode)Mockito.times((int)2))).all();
    }

    private void verifyAlterBrokerLoggerConfig(Node node, final String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        String[] optsList = ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi");
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(optsList);
        final AtomicBoolean alteredConfigs = new AtomicBoolean();
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(describeConfigEntries)));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        final AlterConfigsResult alterResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)alterResult.all()).thenReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource res = resources.iterator().next();
                Assertions.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)res.type());
                Assertions.assertEquals((Object)resourceName, (Object)res.name());
                return describeResult;
            }

            public synchronized AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource res = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assertions.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)res.type());
                Assertions.assertEquals((int)3, (int)alterConfigOps.size());
                List<AlterConfigOp> expectedConfigOps = Arrays.asList(new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE));
                Assertions.assertEquals((int)expectedConfigOps.size(), (int)alterConfigOps.size());
                Iterator<AlterConfigOp> alterConfigOpsIter = alterConfigOps.iterator();
                for (AlterConfigOp expectedConfigOp : expectedConfigOps) {
                    Assertions.assertEquals((Object)expectedConfigOp, (Object)alterConfigOpsIter.next());
                }
                alteredConfigs.set(true);
                return alterResult;
            }
        };
        ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)alterOpts);
        Assertions.assertTrue((boolean)alteredConfigs.get());
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"));
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        class TestAdminZkClient
        extends AdminZkClient {
            public TestAdminZkClient(KafkaZkClient zkClient) {
                super(zkClient, None$.empty());
            }

            public void changeTopicConfig(String topic, Properties configChange) {
                Assertions.assertEquals((Object)"my-topic", (Object)topic);
                Assertions.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assertions.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assertions.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }
        }
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)new TestAdminZkClient(zkClient));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), (ConfigCommand.ConfigCommandOptions)createOpts));
    }

    @Test
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
    }

    @Test
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        final String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        List configEntries = Collections.emptyList();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource res = resources.iterator().next();
                Assertions.assertEquals((Object)res.type(), (Object)ConfigResource.Type.TOPIC);
                Assertions.assertEquals((Object)res.name(), (Object)resourceName);
                return describeResult;
            }
        };
        Assertions.assertThrows(InvalidConfigurationException.class, () -> ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)createOpts));
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    @Test
    public void shouldNotDeleteBrokerConfigWhileBrokerUpUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"));
        KafkaZkClient mockZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Broker mockBroker = (Broker)Mockito.mock(Broker.class);
        Mockito.when((Object)mockZkClient.getBroker(1)).thenReturn((Object)Option.apply((Object)mockBroker));
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            class TestAdminZkClient
            extends AdminZkClient {
                public TestAdminZkClient(KafkaZkClient zkClient) {
                    super(zkClient, None$.empty());
                }

                public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
                    Properties properties = new Properties();
                    properties.put("a", "b");
                    properties.put("c", "d");
                    properties.put("e", "f");
                    return properties;
                }

                public void changeBrokerConfig(Seq<Object> brokers, Properties configChange) {
                    Assertions.assertEquals((Object)"f", (Object)configChange.get("e"));
                    Assertions.assertEquals((int)1, (int)configChange.size());
                }
            }
            ConfigCommand.alterConfigWithZk((KafkaZkClient)mockZkClient, (ConfigCommand.ConfigCommandOptions)createOpts, (AdminZkClient)new TestAdminZkClient(null));
        });
    }

    private ConfigCommand.ConfigCommandOptions createOpts(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config));
    }

    private ConfigCommand.ConfigCommandOptions deleteOpts(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism));
    }

    @Test
    public void testScramCredentials() {
        final HashMap credentials = new HashMap();
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        class CredentialChange
        extends AdminZkClient {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;

            public CredentialChange(String user, Set<String> mechanisms, int iterations) {
                super(null, None$.empty());
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return credentials.getOrDefault(entityName, new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange, boolean isUserClientId) {
                Assertions.assertEquals((Object)this.user, (Object)sanitizedEntityName);
                Assertions.assertEquals(this.mechanisms, configChange.keySet());
                for (String mechanism : this.mechanisms) {
                    String value = configChange.getProperty(mechanism);
                    Assertions.assertEquals((int)-1, (int)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    if (this.iterations != scramCredential.iterations()) {
                        System.out.println("CredentialChange.changeUserOrUserClientIdConfig");
                    }
                    Assertions.assertEquals((int)this.iterations, (int)scramCredential.iterations());
                    credentials.put(this.user, configChange);
                }
            }
        }
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)optsA, (AdminZkClient)new CredentialChange("userA", Collections.singleton("SCRAM-SHA-256"), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)optsB, (AdminZkClient)new CredentialChange("userB", new HashSet<String>(Arrays.asList("SCRAM-SHA-256", "SCRAM-SHA-512")), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts("userB", "SCRAM-SHA-256");
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)del256, (AdminZkClient)new CredentialChange("userB", Collections.singleton("SCRAM-SHA-512"), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts("userB", "SCRAM-SHA-512");
        ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)del512, (AdminZkClient)new CredentialChange("userB", Collections.emptySet(), 4096));
    }

    @Test
    public void testQuotaConfigEntityUsingZookeeperNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.doTestQuotaConfigEntity(true));
    }

    private ConfigCommand.ConfigCommandOptions createOpts(String entityType, Optional<String> entityName, List<String> otherArgs) {
        List<String> optArray = Arrays.asList(this.connectOpts.get(0), this.connectOpts.get(1), "--entity-type", entityType);
        List nameArray = entityName.map(s -> Arrays.asList("--entity-name", s)).orElse(Collections.emptyList());
        return new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(optArray, nameArray, otherArgs));
    }

    private void checkEntity(String entityType, Optional<String> entityName, String expectedEntityName, List<String> otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand.parseEntity((ConfigCommand.ConfigCommandOptions)opts);
        Assertions.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assertions.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private void checkInvalidArgs(String entityType, Optional<String> entityName, List<String> otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts(entityType, entityName, otherArgs);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)opts).checkArgs());
    }

    private void checkInvalidEntity(String entityType, Optional<String> entityName, List<String> otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts(entityType, entityName, otherArgs);
        opts.checkArgs();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.parseEntity((ConfigCommand.ConfigCommandOptions)opts));
    }

    public void doTestQuotaConfigEntity(boolean zkConfig) {
        this.connectOpts = zkConfig ? Arrays.asList("--zookeeper", ZK_CONNECT) : Arrays.asList("--bootstrap-server", "localhost:9092");
        List<String> describeOpts = Collections.singletonList("--describe");
        List<String> alterOpts = Arrays.asList("--alter", "--add-config", "a=b,c=d");
        String clientId = "client-1";
        for (List opts : Arrays.asList(describeOpts, alterOpts)) {
            this.checkEntity("clients", Optional.of(clientId), clientId, opts);
            this.checkEntity("clients", Optional.of(""), "<default>", opts);
        }
        this.checkEntity("clients", Optional.empty(), "", describeOpts);
        this.checkInvalidArgs("clients", Optional.empty(), alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assertions.assertEquals((int)-1, (int)sanitizedPrincipal.indexOf(61));
        Assertions.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        for (List opts : Arrays.asList(describeOpts, alterOpts)) {
            this.checkEntity("users", Optional.of(principal), sanitizedPrincipal, opts);
            this.checkEntity("users", Optional.of(""), "<default>", opts);
        }
        this.checkEntity("users", Optional.empty(), "", describeOpts);
        this.checkInvalidArgs("users", Optional.empty(), alterOpts);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        Function<String, List> clientIdOpts = name -> Arrays.asList("--entity-type", "clients", "--entity-name", name);
        for (List opts : Arrays.asList(describeOpts, alterOpts)) {
            this.checkEntity("users", Optional.of(principal), userClient, ConfigCommandTest.concat(opts, clientIdOpts.apply(clientId)));
            this.checkEntity("users", Optional.of(principal), sanitizedPrincipal + "/clients/" + "<default>", ConfigCommandTest.concat(opts, clientIdOpts.apply("")));
            this.checkEntity("users", Optional.of(""), "<default>/clients/" + clientId, ConfigCommandTest.concat(describeOpts, clientIdOpts.apply(clientId)));
            this.checkEntity("users", Optional.of(""), "<default>/clients/<default>", ConfigCommandTest.concat(opts, clientIdOpts.apply("")));
        }
        this.checkEntity("users", Optional.of(principal), sanitizedPrincipal + "/clients", ConfigCommandTest.concat(describeOpts, Arrays.asList("--entity-type", "clients")));
        this.checkInvalidEntity("users", Optional.of(principal), ConfigCommandTest.concat(alterOpts, Arrays.asList("--entity-type", "clients")));
        this.checkInvalidEntity("users", Optional.empty(), ConfigCommandTest.concat(alterOpts, clientIdOpts.apply(clientId)));
        this.checkInvalidArgs("users", Optional.empty(), ConfigCommandTest.concat(alterOpts, Arrays.asList("--entity-type", "clients")));
    }

    @Test
    public void testQuotaConfigEntity() {
        this.doTestQuotaConfigEntity(false);
    }

    @Test
    public void testUserClientQuotaOptsUsingZookeeperNotAllowed() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.doTestUserClientQuotaOpts(true));
    }

    private void checkEntity(String expectedEntityType, String expectedEntityName, String ... args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(this.connectOpts, Arrays.asList(args)));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand.parseEntity((ConfigCommand.ConfigCommandOptions)opts);
        Assertions.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assertions.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private void doTestUserClientQuotaOpts(boolean zkConfig) {
        this.connectOpts = zkConfig ? Arrays.asList("--zookeeper", ZK_CONNECT) : Arrays.asList("--bootstrap-server", "localhost:9092");
        this.checkEntity("users", Sanitizer.sanitize((String)"<default>"), "--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("clients", Sanitizer.sanitize((String)"<default>"), "--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", "--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", "--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", "--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/client1", "--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe");
        this.checkEntity("users", "/clients", "--entity-type", "clients", "--entity-type", "users", "--describe");
        this.checkEntity("users", Sanitizer.sanitize((String)"CN=user1") + "/clients/" + Sanitizer.sanitize((String)"client1?@%"), "--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d");
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.doTestUserClientQuotaOpts(false);
    }

    public void checkEntities(List<String> opts, java.util.Map<String, List<String>> expectedFetches, List<String> expectedEntityNames) {
        ConfigCommand.ConfigEntity entity = ConfigCommand.parseEntity((ConfigCommand.ConfigCommandOptions)new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(opts, Collections.singletonList("--describe"))));
        expectedFetches.forEach((name, values) -> Mockito.when((Object)this.zkClient.getAllEntitiesWithConfig(name)).thenReturn(ConfigCommandIntegrationTest.seq(values)));
        Seq entities0 = entity.getAllEntities(this.zkClient);
        ArrayList entities = new ArrayList();
        entities0.foreach(e -> {
            entities.add(e);
            return null;
        });
        Assertions.assertEquals(expectedEntityNames, entities.stream().map(ConfigCommand.ConfigEntity::fullSanitizedName).collect(Collectors.toList()));
    }

    @Test
    public void testQuotaDescribeEntities() {
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = sanitizedPrincipal + "/clients/" + clientId;
        List<String> opts = Arrays.asList("--entity-type", "clients", "--entity-name", clientId);
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList(clientId));
        opts = Arrays.asList("--entity-type", "clients", "--entity-default");
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList("<default>"));
        opts = Arrays.asList("--entity-type", "clients");
        this.checkEntities(opts, Collections.singletonMap("clients", Collections.singletonList(clientId)), Collections.singletonList(clientId));
        opts = Arrays.asList("--entity-type", "users", "--entity-name", principal);
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList(sanitizedPrincipal));
        opts = Arrays.asList("--entity-type", "users", "--entity-default");
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList("<default>"));
        opts = Arrays.asList("--entity-type", "users");
        this.checkEntities(opts, Collections.singletonMap("users", Arrays.asList("<default>", sanitizedPrincipal)), Arrays.asList("<default>", sanitizedPrincipal));
        opts = Arrays.asList("--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId);
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList(userClient));
        opts = Arrays.asList("--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default");
        this.checkEntities(opts, Collections.emptyMap(), Collections.singletonList(sanitizedPrincipal + "/clients/<default>"));
        opts = Arrays.asList("--entity-type", "users", "--entity-name", principal, "--entity-type", "clients");
        this.checkEntities(opts, Collections.singletonMap("users/" + sanitizedPrincipal + "/clients", Collections.singletonList("client-4")), Collections.singletonList(sanitizedPrincipal + "/clients/client-4"));
        opts = Arrays.asList("--entity-type", "users", "--entity-default", "--entity-type", "clients");
        this.checkEntities(opts, Collections.singletonMap("users/<default>/clients", Collections.singletonList("client-5")), Collections.singletonList("<default>/clients/client-5"));
        opts = Arrays.asList("--entity-type", "users", "--entity-type", "clients");
        java.util.Map<String, List<String>> userMap = Collections.singletonMap("users/" + sanitizedPrincipal + "/clients", Collections.singletonList("client-2"));
        java.util.Map<String, List<String>> defaultUserMap = Collections.singletonMap("users/<default>/clients", Collections.singletonList("client-3"));
        this.checkEntities(opts, ConfigCommandTest.concat(Collections.singletonMap("users", Arrays.asList("<default>", sanitizedPrincipal)), defaultUserMap, userMap), Arrays.asList("<default>/clients/client-3", sanitizedPrincipal + "/clients/client-2"));
    }

    @Test
    public void shouldAlterClientMetricsConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterClientMetricsConfig(node, "1", Arrays.asList("--entity-name", "1"));
    }

    private void verifyAlterClientMetricsConfig(Node node, final String resourceName, List<String> resourceOpts) {
        List<String> optsList = ConfigCommandTest.concat(Arrays.asList("--bootstrap-server", "localhost:9092", "--entity-type", "client-metrics", "--alter", "--delete-config", "interval.ms", "--add-config", "metrics=org.apache.kafka.consumer.,match=[client_software_name=kafka.python,client_software_version=1\\.2\\..*]"), resourceOpts);
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray(optsList));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, resourceName);
        List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("interval.ms", "1000", ConfigEntry.ConfigSource.DYNAMIC_CLIENT_METRICS_CONFIG, false, false, Collections.emptyList(), ConfigEntry.ConfigType.UNKNOWN, null));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        final AlterConfigsResult alterResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        Mockito.when((Object)alterResult.all()).thenReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertFalse((boolean)options.includeSynonyms(), (String)"Config synonyms requested unnecessarily");
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource res = resources.iterator().next();
                Assertions.assertEquals((Object)ConfigResource.Type.CLIENT_METRICS, (Object)res.type());
                Assertions.assertEquals((Object)resourceName, (Object)res.name());
                return describeResult;
            }

            public synchronized AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assertions.assertEquals((int)1, (int)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource res = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assertions.assertEquals((Object)ConfigResource.Type.CLIENT_METRICS, (Object)res.type());
                Assertions.assertEquals((int)3, (int)alterConfigOps.size());
                List<AlterConfigOp> expectedConfigOps = Arrays.asList(new AlterConfigOp(new ConfigEntry("match", "client_software_name=kafka.python,client_software_version=1\\.2\\..*"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("metrics", "org.apache.kafka.consumer."), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("interval.ms", ""), AlterConfigOp.OpType.DELETE));
                Assertions.assertEquals((int)expectedConfigOps.size(), (int)alterConfigOps.size());
                Iterator<AlterConfigOp> alterConfigOpsIter = alterConfigOps.iterator();
                for (AlterConfigOp expectedConfigOp : expectedConfigOps) {
                    Assertions.assertEquals((Object)expectedConfigOp, (Object)alterConfigOpsIter.next());
                }
                return alterResult;
            }
        };
        ConfigCommand.alterConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)alterOpts);
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
        ((AlterConfigsResult)Mockito.verify((Object)alterResult)).all();
    }

    @Test
    public void shouldDescribeClientMetricsConfigWithoutEntityName() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-type", "client-metrics", "--describe"));
        final ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "1");
        final ConfigEntry configEntry = new ConfigEntry("metrics", "*");
        final KafkaFutureImpl future = new KafkaFutureImpl();
        final DescribeConfigsResult describeResult = (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        Mockito.when((Object)describeResult.all()).thenReturn((Object)future);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node){

            public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assertions.assertTrue((boolean)options.includeSynonyms());
                Assertions.assertEquals((int)1, (int)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assertions.assertEquals((Object)ConfigResource.Type.CLIENT_METRICS, (Object)resource.type());
                Assertions.assertEquals((Object)resourceCustom.name(), (Object)resource.name());
                future.complete(Collections.singletonMap(resourceCustom, new Config(Collections.singletonList(configEntry))));
                return describeResult;
            }
        };
        mockAdminClient.incrementalAlterConfigs(Collections.singletonMap(resourceCustom, Collections.singletonList(new AlterConfigOp(configEntry, AlterConfigOp.OpType.SET))), new AlterConfigsOptions());
        ConfigCommand.describeConfig((Admin)mockAdminClient, (ConfigCommand.ConfigCommandOptions)describeOpts);
        ((DescribeConfigsResult)Mockito.verify((Object)describeResult)).all();
    }

    @Test
    public void shouldNotAlterClientMetricsConfigWithoutEntityName() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--bootstrap-server", "localhost:9092", "--entity-type", "client-metrics", "--alter", "--add-config", "interval.ms=1000"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)alterOpts).checkArgs());
        Assertions.assertEquals((Object)"an entity name must be specified with --alter of client-metrics", (Object)exception.getMessage());
    }

    @Test
    public void shouldNotSupportAlterClientMetricsWithZookeeperArg() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "sub", "--entity-type", "client-metrics", "--alter", "--add-config", "interval.ms=1000"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)alterOpts).checkArgs());
        Assertions.assertEquals((Object)"Invalid entity type client-metrics, the entity type must be one of users, brokers with a --zookeeper argument", (Object)exception.getMessage());
    }

    @Test
    public void shouldNotSupportDescribeClientMetricsWithZookeeperArg() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "sub", "--entity-type", "client-metrics", "--describe"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((ConfigCommand.ConfigCommandOptions)describeOpts).checkArgs());
        Assertions.assertEquals((Object)"Invalid entity type client-metrics, the entity type must be one of users, brokers with a --zookeeper argument", (Object)exception.getMessage());
    }

    @Test
    public void shouldNotSupportAlterClientMetricsWithZookeeper() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandTest.toArray("--zookeeper", ZK_CONNECT, "--entity-name", "sub", "--entity-type", "client-metrics", "--alter", "--add-config", "interval.ms=1000"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigCommand.alterConfigWithZk(null, (ConfigCommand.ConfigCommandOptions)alterOpts, (AdminZkClient)DUMMY_ADMIN_ZK_CLIENT));
        Assertions.assertEquals((Object)"client-metrics is not a known entityType. Should be one of List(topics, clients, users, brokers, ips)", (Object)exception.getMessage());
    }

    public static String[] toArray(String ... first) {
        return first;
    }

    @SafeVarargs
    public static String[] toArray(List<String> ... lists) {
        return (String[])Stream.of(lists).flatMap(Collection::stream).toArray(String[]::new);
    }

    @SafeVarargs
    public static List<String> concat(List<String> ... lists) {
        return Stream.of(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <K, V> java.util.Map<K, V> concat(java.util.Map<K, V> ... maps) {
        HashMap res = new HashMap();
        Stream.of(maps).map(java.util.Map::entrySet).flatMap(Collection::stream).forEach(e -> res.put(e.getKey(), e.getValue()));
        return res;
    }

    static class DummyAdminClient
    extends MockAdminClient {
        public DummyAdminClient(Node node) {
            super(Collections.singletonList(node), node);
        }

        public synchronized DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)Mockito.mock(DescribeConfigsResult.class);
        }

        public synchronized AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        }

        public synchronized AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        }

        public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
            return (DescribeClientQuotasResult)Mockito.mock(DescribeClientQuotasResult.class);
        }

        public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
            return (AlterClientQuotasResult)Mockito.mock(AlterClientQuotasResult.class);
        }
    }

    static class DummyAdminZkClient
    extends AdminZkClient {
        public DummyAdminZkClient(KafkaZkClient zkClient) {
            super(zkClient, None$.empty());
        }

        public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        }

        public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }
    }
}

