/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.LocalVirtualizationSerializer;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;

public class LocalVirtualizationInput
extends VirtualizationInput {
    private final LocalVirtualizationSerializer serializer;

    public LocalVirtualizationInput(InputStream in, LocalVirtualizationSerializer serializer, JRVirtualizationContext virtualizationContext) throws IOException {
        super(in, virtualizationContext);
        this.serializer = serializer;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz;
        block2: {
            try {
                clazz = super.resolveClass(desc);
                this.readShort();
            }
            catch (ClassNotFoundException e) {
                short loaderIdx = this.readShort();
                clazz = this.serializer.resolveClass(desc, loaderIdx);
                if (clazz != null) break block2;
                throw e;
            }
        }
        return clazz;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int classIdx = this.readIntCompressed();
        Class<?> clazz = this.serializer.getClassForDescriptorIdx(classIdx);
        ObjectStreamClass descriptor = ObjectStreamClass.lookupAny(clazz);
        return descriptor;
    }
}

