/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.WorkerSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerAssignmentImpl
implements SchedulerAssignment {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerAssignmentImpl.class);
    private static Function<WorkerSlot, Collection<ExecutorDetails>> MAKE_LIST = k -> new LinkedList();
    private final String topologyId;
    private final Map<ExecutorDetails, WorkerSlot> executorToSlot = new HashMap<ExecutorDetails, WorkerSlot>();
    private final Map<WorkerSlot, WorkerResources> resources = new HashMap<WorkerSlot, WorkerResources>();
    private final Map<String, Double> nodeIdToTotalSharedOffHeapNode = new HashMap<String, Double>();
    private final Map<WorkerSlot, Collection<ExecutorDetails>> slotToExecutors = new HashMap<WorkerSlot, Collection<ExecutorDetails>>();

    public SchedulerAssignmentImpl(String topologyId, Map<ExecutorDetails, WorkerSlot> executorToSlot, Map<WorkerSlot, WorkerResources> resources, Map<String, Double> nodeIdToTotalSharedOffHeap) {
        this.topologyId = topologyId;
        if (executorToSlot != null) {
            if (executorToSlot.entrySet().stream().anyMatch(entry -> entry.getKey() == null || entry.getValue() == null)) {
                throw new RuntimeException("Cannot create a scheduling with a null in it " + String.valueOf(executorToSlot));
            }
            this.executorToSlot.putAll(executorToSlot);
            for (Map.Entry<ExecutorDetails, WorkerSlot> entry2 : executorToSlot.entrySet()) {
                this.slotToExecutors.computeIfAbsent(entry2.getValue(), MAKE_LIST).add(entry2.getKey());
            }
        }
        if (resources != null) {
            if (resources.entrySet().stream().anyMatch(entry -> entry.getKey() == null || entry.getValue() == null)) {
                throw new RuntimeException("Cannot create resources with a null in it " + String.valueOf(resources));
            }
            this.resources.putAll(resources);
        }
        if (nodeIdToTotalSharedOffHeap != null) {
            if (nodeIdToTotalSharedOffHeap.entrySet().stream().anyMatch(entry -> entry.getKey() == null || entry.getValue() == null)) {
                throw new RuntimeException("Cannot create off heap with a null in it " + String.valueOf(nodeIdToTotalSharedOffHeap));
            }
            this.nodeIdToTotalSharedOffHeapNode.putAll(nodeIdToTotalSharedOffHeap);
        }
    }

    public SchedulerAssignmentImpl(String topologyId) {
        this(topologyId, null, null, null);
    }

    public SchedulerAssignmentImpl(SchedulerAssignment assignment) {
        this(assignment.getTopologyId(), assignment.getExecutorToSlot(), assignment.getScheduledResources(), assignment.getNodeIdToTotalSharedOffHeapNodeMemory());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " topo: " + this.topologyId + " execToSlots: " + String.valueOf(this.executorToSlot);
    }

    public boolean equalsIgnoreResources(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SchedulerAssignmentImpl)) {
            return false;
        }
        SchedulerAssignmentImpl o = (SchedulerAssignmentImpl)other;
        return this.topologyId.equals(o.topologyId) && this.executorToSlot.equals(o.executorToSlot);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topologyId == null ? 0 : this.topologyId.hashCode());
        result = 31 * result + (this.executorToSlot == null ? 0 : this.executorToSlot.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (!this.equalsIgnoreResources(other)) {
            return false;
        }
        SchedulerAssignmentImpl o = (SchedulerAssignmentImpl)other;
        return this.resources.equals(o.resources) && this.nodeIdToTotalSharedOffHeapNode.equals(o.nodeIdToTotalSharedOffHeapNode);
    }

    @Override
    public Set<WorkerSlot> getSlots() {
        return new HashSet<WorkerSlot>(this.executorToSlot.values());
    }

    @Deprecated
    public void assign(WorkerSlot slot, Collection<ExecutorDetails> executors) {
        this.assign(slot, executors, null);
    }

    public void assign(WorkerSlot slot, Collection<ExecutorDetails> executors, WorkerResources slotResources) {
        if (slot == null) {
            throw new AssertionError((Object)"WorkerSlot parameter is null");
        }
        for (ExecutorDetails executor : executors) {
            this.executorToSlot.put(executor, slot);
        }
        this.slotToExecutors.computeIfAbsent(slot, MAKE_LIST).addAll(executors);
        if (slotResources != null) {
            this.resources.put(slot, slotResources);
        } else {
            this.resources.remove(slot);
        }
    }

    public void unassignBySlot(WorkerSlot slot) {
        Collection<ExecutorDetails> executors = this.slotToExecutors.remove(slot);
        if (executors != null) {
            for (ExecutorDetails executor : executors) {
                this.executorToSlot.remove(executor);
            }
        }
        this.resources.remove(slot);
        String node = slot.getNodeId();
        boolean isFound = false;
        for (WorkerSlot ws : this.executorToSlot.values()) {
            if (!node.equals(ws.getNodeId())) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            this.nodeIdToTotalSharedOffHeapNode.remove(node);
        }
    }

    @Override
    public boolean isSlotOccupied(WorkerSlot slot) {
        return this.slotToExecutors.containsKey(slot);
    }

    @Override
    public boolean isExecutorAssigned(ExecutorDetails executor) {
        return this.executorToSlot.containsKey(executor);
    }

    @Override
    public String getTopologyId() {
        return this.topologyId;
    }

    @Override
    public Map<ExecutorDetails, WorkerSlot> getExecutorToSlot() {
        return this.executorToSlot;
    }

    @Override
    public Set<ExecutorDetails> getExecutors() {
        return this.executorToSlot.keySet();
    }

    @Override
    public Map<WorkerSlot, Collection<ExecutorDetails>> getSlotToExecutors() {
        return this.slotToExecutors;
    }

    @Override
    public Map<WorkerSlot, WorkerResources> getScheduledResources() {
        return this.resources;
    }

    public void setTotalSharedOffHeapNodeMemory(String node, double value) {
        this.nodeIdToTotalSharedOffHeapNode.put(node, value);
    }

    @Override
    public Map<String, Double> getNodeIdToTotalSharedOffHeapNodeMemory() {
        return this.nodeIdToTotalSharedOffHeapNode;
    }
}

