/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.login.impl;

import java.util.Dictionary;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.auth.xing.api.AbstractXingUserManager;
import org.apache.sling.auth.xing.api.XingUser;
import org.apache.sling.auth.xing.login.XingLoginUserManager;
import org.apache.sling.auth.xing.login.XingLoginUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING Login \u201cDefault User Manager\u201d", description="Default User Manager for Sling Authentication XING Login", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Default User Manager for Sling Authentication XING Login"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false)})
public class DefaultXingLoginUserManager
extends AbstractXingUserManager
implements XingLoginUserManager {
    private String secretKey;
    private String userDataProperty;
    private String userHashProperty;
    @Reference
    private SlingRepository slingRepository;
    private static final String DEFAULT_USER_DATA_PROPERTY = "data";
    private static final String DEFAULT_USER_HASH_PROPERTY = "hash";
    @Property(value={""})
    private static final String SECRET_KEY_PARAMETER = "org.apache.sling.auth.xing.login.impl.DefaultXingLoginUserManager.secretKey";
    @Property(value={"data"})
    private static final String USER_DATA_PROPERTY_PARAMETER = "org.apache.sling.auth.xing.login.impl.DefaultXingLoginUserManager.user.property.data";
    @Property(value={"hash"})
    private static final String USER_HASH_PROPERTY_PARAMETER = "org.apache.sling.auth.xing.login.impl.DefaultXingLoginUserManager.user.property.hash";
    @Property(boolValue={true})
    private static final String AUTO_CREATE_USER_PARAMETER = "org.apache.sling.auth.xing.login.impl.DefaultXingLoginUserManager.user.create.auto";
    @Property(boolValue={false})
    private static final String AUTO_UPDATE_USER_PARAMETER = "org.apache.sling.auth.xing.login.impl.DefaultXingLoginUserManager.user.update.auto";
    private final Logger logger = LoggerFactory.getLogger(DefaultXingLoginUserManager.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.logger.debug("activate");
        this.configure(componentContext);
    }

    @Modified
    protected void modified(ComponentContext componentContext) {
        this.logger.debug("modified");
        this.configure(componentContext);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.logger.debug("deactivate");
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
    }

    protected synchronized void configure(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.secretKey = PropertiesUtil.toString(properties.get(SECRET_KEY_PARAMETER), "").trim();
        this.userDataProperty = PropertiesUtil.toString(properties.get(USER_DATA_PROPERTY_PARAMETER), DEFAULT_USER_DATA_PROPERTY).trim();
        this.userHashProperty = PropertiesUtil.toString(properties.get(USER_HASH_PROPERTY_PARAMETER), DEFAULT_USER_HASH_PROPERTY).trim();
        this.autoCreateUser = PropertiesUtil.toBoolean(properties.get(AUTO_CREATE_USER_PARAMETER), true);
        this.autoUpdateUser = PropertiesUtil.toBoolean(properties.get(AUTO_UPDATE_USER_PARAMETER), false);
        if (StringUtils.isEmpty((String)this.secretKey)) {
            this.logger.warn("configured secret key is empty");
        }
    }

    protected SlingRepository getSlingRepository() {
        return this.slingRepository;
    }

    public User createUser(Credentials credentials) {
        this.logger.debug("create user");
        return this.storeUser(credentials);
    }

    public User updateUser(Credentials credentials) {
        this.logger.debug("update user");
        return this.storeUser(credentials);
    }

    protected User storeUser(Credentials credentials) {
        String givenHash = XingLoginUtil.getHash(credentials);
        String json = XingLoginUtil.getUser(credentials);
        if (givenHash == null || json == null) {
            this.logger.debug("unable to get hash and/or user data from given credentials");
            return null;
        }
        try {
            String computedHash = XingLoginUtil.hash(json, this.secretKey, "HmacSHA256");
            boolean match = givenHash.equals(computedHash);
            if (!match) {
                this.logger.warn("invalid hash or user data given, aborting");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            XingUser xingUser = XingLoginUtil.fromJson(json);
            String userId = xingUser.getId();
            User user = this.getUser(userId);
            if (user == null) {
                this.logger.debug("creating a new user with id '{}'", (Object)userId);
                Session session = this.getSession();
                UserManager userManager = this.getUserManager(session);
                user = userManager.createUser(userId, null);
            } else {
                this.logger.debug("updating an existing user with id '{}'", (Object)userId);
            }
            ValueFactory valueFactory = this.getSession().getValueFactory();
            Value dataValue = valueFactory.createValue(json);
            Value hashValue = valueFactory.createValue(givenHash);
            user.setProperty(this.userDataProperty, dataValue);
            user.setProperty(this.userHashProperty, hashValue);
            this.session.save();
            return user;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getHash(User user) {
        try {
            Value[] values = user.getProperty(this.userHashProperty);
            if (values != null && values.length == 1) {
                Value value = values[0];
                return value.getString();
            }
        }
        catch (RepositoryException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

