/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLPathUtils.class);
    public static final String LOCAL_HOST = "http://localhost";
    public static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");

    public static URL getServerURL(OpenAPI openAPI, Map<String, String> userDefinedVariables) {
        List servers = openAPI.getServers();
        if (servers == null || servers.isEmpty()) {
            LOGGER.warn("Server information seems not defined in the spec. Default to {}.", (Object)LOCAL_HOST);
            return URLPathUtils.getDefaultUrl();
        }
        return URLPathUtils.getServerURL((Server)servers.get(0), userDefinedVariables);
    }

    public static URL getServerURL(Server server, Map<String, String> userDefinedVariables) {
        HashMap<String, String> userVariables;
        String url = server.getUrl();
        ServerVariables variables = server.getVariables();
        if (variables == null) {
            variables = new ServerVariables();
        }
        HashMap<String, String> hashMap = userVariables = userDefinedVariables == null ? new HashMap<String, String>() : ImmutableMap.copyOf(userDefinedVariables);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            url = URLPathUtils.extractUrl(server, url, variables, userVariables);
            url = URLPathUtils.sanitizeUrl(url);
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Not valid URL: {}. Default to {}.", (Object)server.getUrl(), (Object)LOCAL_HOST);
            }
        }
        return URLPathUtils.getDefaultUrl();
    }

    private static String extractUrl(Server server, String url, ServerVariables variables, Map<String, String> userVariables) {
        HashSet<String> replacedVariables = new HashSet<String>();
        Matcher matcher = VARIABLE_PATTERN.matcher(url);
        while (matcher.find()) {
            String replacement;
            if (replacedVariables.contains(matcher.group())) continue;
            String variableName = matcher.group(1);
            ServerVariable variable = (ServerVariable)variables.get((Object)variableName);
            if (variable != null) {
                List enumValues;
                String defaultValue = variable.getDefault();
                List list = enumValues = variable.getEnum() == null ? new ArrayList() : variable.getEnum();
                if (defaultValue == null && !enumValues.isEmpty()) {
                    defaultValue = (String)enumValues.get(0);
                } else if (defaultValue == null) {
                    defaultValue = "";
                }
                replacement = userVariables.getOrDefault(variableName, defaultValue);
                if (!enumValues.isEmpty() && !enumValues.contains(replacement)) {
                    LOGGER.warn("Variable override of '{}' is not listed in the enum of allowed values ({}).", (Object)replacement, (Object)StringUtils.join(enumValues, (String)","));
                }
            } else {
                replacement = userVariables.getOrDefault(variableName, "");
            }
            if (StringUtils.isEmpty((CharSequence)replacement)) {
                replacement = "";
                LOGGER.warn("No value found for variable '{}' in server definition '{}' and no user override specified, default to empty string.", (Object)variableName, (Object)server.getUrl());
            }
            url = url.replace(matcher.group(), replacement);
            replacedVariables.add(matcher.group());
            matcher = VARIABLE_PATTERN.matcher(url);
        }
        return url;
    }

    public static String getScheme(OpenAPI openAPI, CodegenConfig config) {
        URL url = URLPathUtils.getServerURL(openAPI, config.serverVariableOverrides());
        return URLPathUtils.getScheme(url, config);
    }

    public static String getScheme(URL url, CodegenConfig config) {
        String scheme = url != null ? url.getProtocol() : "https";
        if (config != null) {
            scheme = config.escapeText(scheme);
        }
        return scheme;
    }

    public static String getPort(URL url, int defaultPort) {
        return URLPathUtils.getPort(url, String.valueOf(defaultPort));
    }

    public static String getPort(URL url, String defaultPort) {
        if (url == null || url.getPort() == -1) {
            return defaultPort;
        }
        return String.valueOf(url.getPort());
    }

    public static String getPath(URL url, String defaultPath) {
        if (url == null || url.getPath() == null || url.getPath().isEmpty()) {
            return defaultPath;
        }
        return url.getPath();
    }

    public static String getProtocolAndHost(URL url) {
        if (url == null) {
            return LOCAL_HOST;
        }
        String protocol = url.getProtocol() == null ? "http" : url.getProtocol();
        return protocol + "://" + url.getHost();
    }

    public static String getHost(OpenAPI openAPI, Map<String, String> userDefinedVariables) {
        if (openAPI.getServers() != null && openAPI.getServers().size() > 0) {
            return URLPathUtils.sanitizeUrl(URLPathUtils.getServerURL((Server)openAPI.getServers().get(0), userDefinedVariables).toString());
        }
        return LOCAL_HOST;
    }

    private static String sanitizeUrl(String url) {
        if (url.startsWith("//")) {
            url = "http:" + url;
            LOGGER.warn("'scheme' not defined in the spec (2.0). Default to [http] for server URL [{}]", (Object)url);
        } else if (url.startsWith("/")) {
            url = LOCAL_HOST + url;
            LOGGER.warn("'host' (OAS 2.0) or 'servers' (OAS 3.0) not defined in the spec. Default to [{}] for server URL [{}]", (Object)LOCAL_HOST, (Object)url);
        } else if (!url.matches("[a-zA-Z][0-9a-zA-Z.+\\-]+://.+")) {
            url = "http://" + url;
            LOGGER.warn("'scheme' not defined in the spec (2.0). Default to [http] for server URL [{}]", (Object)url);
        }
        return url;
    }

    private static URL getDefaultUrl() {
        try {
            return new URL(LOCAL_HOST);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

