/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.rya.indexing.external.fluo;

import java.util.Collection;

import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.indexing.external.PrecomputedJoinIndexer;

import org.apache.rya.indexing.pcj.update.PrecomputedJoinUpdater;

/**
 * A NoOp updater (which does nothing) to be used by {@link PrecomputedJoinIndexer} if neither Batch nor
 * {@link FluoPcjUpdater} is specified by the user to update Precomputed Joins.
 *
 */
public class NoOpUpdater implements PrecomputedJoinUpdater {

    @Override
    public void addStatements(Collection<RyaStatement> statements)
            throws PcjUpdateException {
    }

    @Override
    public void deleteStatements(Collection<RyaStatement> statements)
            throws PcjUpdateException {
    }

    @Override
    public void flush() throws PcjUpdateException {
    }

    @Override
    public void close() throws PcjUpdateException {
    }

}
