/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.filespecs.StringFileSpecification;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTokenizer;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.ASLinter;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.LinterSettings;
import org.apache.royale.linter.MXMLTagVisitor;
import org.apache.royale.linter.MXMLTokenQuery;
import org.apache.royale.linter.MXMLTokenVisitor;
import org.apache.royale.linter.internal.BaseLinter;

public class MXMLLinter
extends BaseLinter {
    private static final String LINTER_TAG_OFF = "@linter:off";
    private static final String LINTER_TAG_ON = "@linter:on";

    public MXMLLinter(LinterSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lint(String filePath, String text, Collection<ICompilerProblem> allProblems) {
        if (allProblems == null) {
            allProblems = new ArrayList<ICompilerProblem>();
        }
        ArrayList<ICompilerProblem> fileProblems = new ArrayList<ICompilerProblem>();
        try {
            StringReader textReader = new StringReader(text);
            MXMLTokenizer mxmlTokenizer = new MXMLTokenizer();
            List<MXMLToken> originalTokens = null;
            try {
                originalTokens = mxmlTokenizer.parseTokens(textReader);
            }
            finally {
                IOUtils.closeQuietly((Reader)textReader);
                IOUtils.closeQuietly((Closeable)mxmlTokenizer);
            }
            if (mxmlTokenizer.hasTokenizationProblems()) {
                fileProblems.addAll(mxmlTokenizer.getTokenizationProblems());
            }
            if (!this.settings.ignoreProblems && this.hasErrors(fileProblems)) {
                return;
            }
            boolean skipLinting = false;
            IMXMLToken[] allTokens = this.insertFormattingTokens(originalTokens, text);
            MXMLTokenQuery tokenQuery = new MXMLTokenQuery(allTokens);
            for (LinterRule rule : this.settings.rules) {
                Map<IMXMLToken.MXMLTokenKind, MXMLTokenVisitor> tokenHandlers = rule.getMXMLTokenVisitors();
                if (tokenHandlers == null) continue;
                for (IMXMLToken iMXMLToken : originalTokens) {
                    IMXMLToken.MXMLTokenKind tokenKind = iMXMLToken.getMXMLTokenKind();
                    if (tokenKind == IMXMLToken.MXMLTokenKind.COMMENT) {
                        String tokenText = iMXMLToken.getText();
                        boolean isASDoc = tokenText.startsWith("<!---") && tokenText.length() > 7;
                        String trimmed = tokenText.substring(isASDoc ? 5 : 4, tokenText.length() - 3).trim();
                        if (!skipLinting && LINTER_TAG_OFF.equals(trimmed)) {
                            skipLinting = true;
                        } else if (skipLinting && LINTER_TAG_ON.equals(trimmed)) {
                            skipLinting = false;
                            continue;
                        }
                    }
                    if (skipLinting || !tokenHandlers.containsKey((Object)tokenKind)) continue;
                    tokenHandlers.get((Object)tokenKind).visit(iMXMLToken, tokenQuery, fileProblems);
                }
            }
            PrefixMap prefixMap = mxmlTokenizer.getPrefixMap();
            MXMLData mxmlData = new MXMLData(originalTokens, prefixMap, (IFileSpecification)new StringFileSpecification(filePath, text));
            IMXMLTagData rootTag = mxmlData.getRootTag();
            if (rootTag != null) {
                this.visitTag(rootTag, tokenQuery, fileProblems);
            }
            IMXMLTagData current = rootTag;
            boolean bl = true;
            String className = Paths.get(filePath, new String[0]).getFileName().toString();
            int extensionIndex = className.indexOf(46);
            if (extensionIndex != -1) {
                className = className.substring(0, extensionIndex);
            }
            String componentName = null;
            if (rootTag != null) {
                componentName = rootTag.getShortName();
            }
            StringBuilder builder = new StringBuilder();
            builder.append("/* ");
            builder.append(LINTER_TAG_OFF);
            builder.append(" */");
            builder.append("package{public class ");
            builder.append(className);
            if (componentName != null) {
                builder.append(" extends ");
                builder.append(componentName);
            }
            builder.append("{");
            while (current != null) {
                String prefix;
                String ns;
                IMXMLTagData tag;
                if (current instanceof IMXMLTagData && "Script".equals((tag = current).getShortName()) && (ns = prefixMap.getNamespaceForPrefix(prefix = tag.getPrefix())) != null && ("http://www.adobe.com/2006/mxml".equals(ns) || "http://ns.adobe.com/mxml/2009".equals(ns) || "http://ns.adobe.com/mxml/2012".equals(ns))) {
                    if (tag.isOpenTag()) {
                        int line = tag.getLine();
                        String scriptText = tag.getCompilableText();
                        for (int i = n; i < line; ++i) {
                            builder.append("\n");
                        }
                        builder.append("/* ");
                        builder.append(LINTER_TAG_ON);
                        builder.append(" */\n");
                        builder.append(scriptText);
                        builder.append("/* ");
                        builder.append(LINTER_TAG_OFF);
                        builder.append(" */");
                    } else {
                        int n = tag.getLine() + 1;
                    }
                }
                current = current.getNext();
            }
            builder.append("}}\n");
            ASLinter asLinter = new ASLinter(this.settings);
            asLinter.lint(filePath, builder.toString(), fileProblems);
        }
        finally {
            allProblems.addAll(fileProblems);
        }
    }

    private void visitTag(IMXMLTagData tag, MXMLTokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        for (LinterRule rule : this.settings.rules) {
            List<MXMLTagVisitor> tagVisitors = rule.getMXMLTagVisitors();
            if (tagVisitors == null) continue;
            for (int i = 0; i < tagVisitors.size(); ++i) {
                tagVisitors.get(i).visit(tag, tokenQuery, problems);
            }
        }
        for (IMXMLTagData current = tag.getFirstChild(true); current != null; current = current.getNextSibling(true)) {
            this.visitTag(current, tokenQuery, problems);
        }
    }

    private IMXMLToken[] insertFormattingTokens(List<MXMLToken> originalTokens, String text) {
        ArrayList<IMXMLToken> tokens = new ArrayList<IMXMLToken>();
        IMXMLToken prevToken = null;
        for (IMXMLToken iMXMLToken : originalTokens) {
            if (prevToken != null) {
                int start = prevToken.getEnd();
                int end = iMXMLToken.getStart();
                if (end > start) {
                    String tokenText = text.substring(start, end);
                    MXMLToken formattingToken = new MXMLToken(999999, start, end, prevToken.getLine(), prevToken.getColumn() + end - start, tokenText);
                    formattingToken.setEndLine(iMXMLToken.getLine());
                    formattingToken.setEndLine(iMXMLToken.getColumn());
                    tokens.add(formattingToken);
                }
            }
            tokens.add(iMXMLToken);
            prevToken = iMXMLToken;
        }
        if (prevToken != null) {
            int start = prevToken.getEnd();
            int n = text.length();
            if (n > start) {
                String tokenText = text.substring(start, n);
                MXMLToken formattingToken = new MXMLToken(999999, start, n, prevToken.getLine(), prevToken.getColumn() + n - start, tokenText);
                formattingToken.setEndLine(prevToken.getLine());
                formattingToken.setEndLine(prevToken.getColumn());
                tokens.add(formattingToken);
            }
        }
        return tokens.toArray(new IMXMLToken[0]);
    }
}

