/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.Transport;
import com.microsoft.playwright.impl.Waitable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;

class JsonPipe
extends ChannelOwner
implements Transport {
    private final Queue<JsonObject> incoming = new LinkedList<JsonObject>();
    private ListenerCollection<EventType> listeners = new ListenerCollection();
    private boolean isClosed;

    JsonPipe(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void send(JsonObject message) {
        this.checkIfClosed();
        JsonObject params = new JsonObject();
        params.add("message", (JsonElement)message);
        this.sendMessage("send", params);
    }

    @Override
    public JsonObject poll(final Duration timeout) {
        final Instant start = Instant.now();
        return this.runUntil(() -> {}, new Waitable<JsonObject>(){
            JsonObject message;

            @Override
            public boolean isDone() {
                if (!JsonPipe.this.incoming.isEmpty()) {
                    this.message = (JsonObject)JsonPipe.this.incoming.remove();
                    return true;
                }
                JsonPipe.this.checkIfClosed();
                return Duration.between(start, Instant.now()).compareTo(timeout) > 0;
            }

            @Override
            public JsonObject get() {
                return this.message;
            }

            @Override
            public void dispose() {
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.sendMessage("close");
        }
    }

    void onClose(Consumer<JsonPipe> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    void offClose(Consumer<JsonPipe> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("message".equals(event)) {
            this.incoming.add(params.get("message").getAsJsonObject());
        } else if ("closed".equals(event)) {
            this.isClosed = true;
            this.listeners.notify(EventType.CLOSE, this);
        }
    }

    private void checkIfClosed() {
        if (this.isClosed) {
            throw new PlaywrightException("Browser has been closed");
        }
    }

    private static enum EventType {
        CLOSE;

    }
}

