/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;

public class RewriteEncodingRule
extends Rule {
    private static final HttpField VARY_ACCEPT_ENCODING = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
    private final BiFunction<Context, String, Resource> _getResource;
    private final Map<String, Encoding> _encodings = new TreeMap<String, Encoding>(String.CASE_INSENSITIVE_ORDER);

    public static Resource getResource(Context context, String pathInContext) {
        return context.getBaseResource().resolve(pathInContext);
    }

    public RewriteEncodingRule() {
        this(RewriteEncodingRule::getResource, "br", ".br", "gzip", ".gz", "zstd", ".zst");
    }

    public RewriteEncodingRule(BiFunction<Context, String, Resource> getResource) {
        this(getResource, "br", ".br", "gzip", ".gz", "zstd", ".zst");
    }

    public RewriteEncodingRule(BiFunction<Context, String, Resource> getResource, String ... encodingsAndExtensions) {
        this._getResource = getResource;
        if (encodingsAndExtensions.length % 2 != 0) {
            throw new IllegalArgumentException("encodingsAndExtensions must be an even number of arguments");
        }
        for (int i = 0; i < encodingsAndExtensions.length; i += 2) {
            this._encodings.put(encodingsAndExtensions[i], Encoding.of(encodingsAndExtensions[i], encodingsAndExtensions[i + 1]));
        }
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        if (input.getHttpURI().getPath().endsWith("/")) {
            return input;
        }
        List encodings = input.getHeaders().getQualityCSV(HttpHeader.ACCEPT_ENCODING);
        if (encodings != null && !encodings.isEmpty()) {
            for (String encodingName : encodings) {
                if (encodingName == null) continue;
                if (StringUtil.asciiEqualsIgnoreCase((String)"identity", (String)encodingName)) {
                    return new VaryHandler(input);
                }
                if ("*".equals(encodingName)) {
                    for (Map.Entry<String, Encoding> entry : this._encodings.entrySet()) {
                        String pathInContext = Request.getPathInContext((Request)input);
                        String encodedPathInContext = pathInContext + entry.getValue().extension();
                        Resource resource = this._getResource.apply(input.getContext(), encodedPathInContext);
                        if (!resource.exists()) continue;
                        return this.newEncodingHandler(input, encodedPathInContext, entry.getValue());
                    }
                    continue;
                }
                Encoding encoding = this._encodings.get(encodingName);
                if (encoding == null) continue;
                String pathInContext = Request.getPathInContext((Request)input);
                String encodedPathInContext = pathInContext + encoding.extension();
                Resource resource = this._getResource.apply(input.getContext(), encodedPathInContext);
                if (!resource.exists()) continue;
                return this.newEncodingHandler(input, encodedPathInContext, encoding);
            }
        }
        return new VaryHandler(input);
    }

    @Override
    public String toString() {
        return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
    }

    protected Rule.Handler newEncodingHandler(Rule.Handler input, String languagePathInContext, Encoding encoding) {
        return new EncodingHandler(input, languagePathInContext, encoding);
    }

    private void ensureVaryAcceptEncoding(Response response) {
        response.getHeaders().computeField(HttpHeader.VARY, (h, l) -> {
            if (l == null || l.isEmpty()) {
                return VARY_ACCEPT_ENCODING;
            }
            boolean acceptEncoding = false;
            StringBuilder vary = new StringBuilder();
            block0: for (HttpField field : l) {
                for (String value : field.getValues()) {
                    if (HttpHeader.ACCEPT_ENCODING.asString().equalsIgnoreCase(value)) {
                        acceptEncoding = true;
                        break block0;
                    }
                    if (!vary.isEmpty()) {
                        vary.append(", ");
                    }
                    vary.append(value);
                }
            }
            if (!acceptEncoding) {
                vary.append(", ").append(HttpHeader.ACCEPT_ENCODING.asString());
            }
            return new HttpField(HttpHeader.VARY, vary.toString());
        });
    }

    protected record Encoding(String encoding, String extension, HttpField contentEncodingField) {
        public static Encoding of(String encoding, String extension) {
            return new Encoding(encoding, extension, (HttpField)new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, encoding));
        }
    }

    protected class VaryHandler
    extends Rule.Handler {
        public VaryHandler(Rule.Handler input) {
            super(input);
        }

        @Override
        protected boolean handle(Response response, Callback callback) throws Exception {
            RewriteEncodingRule.this.ensureVaryAcceptEncoding(response);
            return super.handle(response, callback);
        }
    }

    protected class EncodingHandler
    extends Rule.Handler {
        private static final EnumSet<HttpHeader> IF_MATCHES = EnumSet.of(HttpHeader.IF_MATCH, HttpHeader.IF_NONE_MATCH);
        private final Encoding _encoding;
        private final String _dashEncoding;
        private final HttpURI _encodingURI;
        private final HttpFields _httpFields;

        public EncodingHandler(Rule.Handler input, String encodingPathInContext, Encoding encoding) {
            super(input);
            this._encoding = encoding;
            this._dashEncoding = "-" + encoding.encoding();
            this._encodingURI = HttpURI.build((HttpURI)input.getHttpURI()).path(URIUtil.addPaths((String)input.getContext().getContextPath(), (String)encodingPathInContext)).asImmutable();
            HttpFields httpFields = input.getHeaders();
            if (httpFields.contains(IF_MATCHES)) {
                httpFields = HttpFields.build((HttpFields)httpFields).computeField(HttpHeader.IF_MATCH, this::computeNoEncodingEtag).computeField(HttpHeader.IF_NONE_MATCH, this::computeNoEncodingEtag).asImmutable();
            }
            this._httpFields = httpFields;
        }

        private HttpField computeNoEncodingEtag(HttpHeader header, List<HttpField> fields) {
            if (fields == null || fields.isEmpty()) {
                return null;
            }
            return new HttpField(header, fields.stream().flatMap(field -> field.getValueList(true).stream()).map(value -> value.replace(this._dashEncoding, "")).collect(Collectors.joining(", ")));
        }

        public HttpURI getHttpURI() {
            return this._encodingURI;
        }

        public HttpFields getHeaders() {
            return this._httpFields;
        }

        @Override
        protected boolean handle(Response response, Callback callback) throws Exception {
            response.getHeaders().computeField(HttpHeader.CONTENT_ENCODING, (h, l) -> {
                if (l == null || l.isEmpty()) {
                    return this._encoding.contentEncodingField();
                }
                return (HttpField)l.get(0);
            });
            RewriteEncodingRule.this.ensureVaryAcceptEncoding(response);
            HttpFields.Mutable.Wrapper responseFields = new HttpFields.Mutable.Wrapper(response.getHeaders()){

                public HttpField onAddField(HttpField field) {
                    String etag;
                    if (field.getHeader() == HttpHeader.ETAG && (etag = field.getValue()).endsWith("\"")) {
                        return new HttpField(HttpHeader.ETAG, etag.substring(0, etag.length() - 1) + EncodingHandler.this._dashEncoding + "\"");
                    }
                    return field;
                }

                public HttpField onReplaceField(HttpField oldField, HttpField newField) {
                    if (oldField.getHeader() == HttpHeader.VARY && !newField.getValue().contains(HttpHeader.ACCEPT_ENCODING.asString())) {
                        return new HttpField(HttpHeader.VARY, newField.getValue() + ", " + HttpHeader.ACCEPT_ENCODING.asString());
                    }
                    return this.onAddField(newField);
                }

                public boolean onRemoveField(HttpField field) {
                    return field.getHeader() != HttpHeader.VARY || !field.getValue().contains(HttpHeader.ACCEPT_ENCODING.asString());
                }
            };
            Response.Wrapper wrappedResponse = new Response.Wrapper(this, response.getRequest(), response, (HttpFields.Mutable)responseFields){
                final /* synthetic */ HttpFields.Mutable val$responseFields;
                final /* synthetic */ EncodingHandler this$1;
                {
                    this.val$responseFields = mutable;
                    this.this$1 = this$1;
                    super(arg0, arg1);
                }

                public HttpFields.Mutable getHeaders() {
                    return this.val$responseFields;
                }
            };
            return super.handle((Response)wrappedResponse, callback);
        }
    }
}

