/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropAliasNode
extends DDLStatementNode {
    private char aliasType;
    private char nameSpace;

    DropAliasNode(TableName tableName, char c, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.aliasType = c;
        switch (this.aliasType) {
            case 'G': {
                this.nameSpace = (char)71;
                break;
            }
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            case 'A': {
                this.nameSpace = (char)65;
                break;
            }
        }
    }

    public char getAliasType() {
        return this.aliasType;
    }

    @Override
    String statementToString() {
        return "DROP ".concat(DropAliasNode.aliasTypeName(this.aliasType));
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.getRelativeName();
        AliasDescriptor aliasDescriptor = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            aliasDescriptor = dataDictionary.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string, this.nameSpace);
        }
        if (aliasDescriptor == null) {
            throw StandardException.newException((String)"42Y55", (Object[])new Object[]{this.statementToString(), string});
        }
        if (aliasDescriptor.getSystemAlias()) {
            throw StandardException.newException((String)"42Y71", (Object[])new Object[]{string});
        }
        this.getCompilerContext().createDependency(aliasDescriptor);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropAliasConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.nameSpace);
    }

    private static String aliasTypeName(char c) {
        String string = null;
        switch (c) {
            case 'G': {
                string = "DERBY AGGREGATE";
                break;
            }
            case 'P': {
                string = "PROCEDURE";
                break;
            }
            case 'F': {
                string = "FUNCTION";
                break;
            }
            case 'S': {
                string = "SYNONYM";
                break;
            }
            case 'A': {
                string = "TYPE";
            }
        }
        return string;
    }
}

