/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;

public class UriResourceFunctionImpl
extends UriResourceWithKeysImpl
implements UriResourceFunction {
    private final EdmFunctionImport functionImport;
    private final EdmFunction function;
    private final List<UriParameter> parameters;

    public UriResourceFunctionImpl(EdmFunctionImport edmFunctionImport, EdmFunction function, List<UriParameter> parameters) {
        super(UriResourceKind.function);
        this.functionImport = edmFunctionImport;
        this.function = function;
        this.parameters = parameters;
    }

    public List<UriParameter> getParameters() {
        return this.parameters == null ? Collections.emptyList() : Collections.unmodifiableList(this.parameters);
    }

    public EdmFunction getFunction() {
        return this.function;
    }

    public EdmFunctionImport getFunctionImport() {
        return this.functionImport;
    }

    public EdmType getType() {
        return this.function.getReturnType().getType();
    }

    public boolean isCollection() {
        return this.keyPredicates == null && this.function.getReturnType().isCollection();
    }

    public String getSegmentValue() {
        return this.functionImport == null ? (this.function == null ? "" : this.function.getName()) : this.functionImport.getName();
    }
}

