/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.core.communication.header.ODataErrorResponseChecker;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractRequest.class);

    protected void checkRequest(ODataClient odataClient, HttpUriRequest request) {
        if (odataClient instanceof EdmEnabledODataClient && !request.getURI().toASCIIString().startsWith(((EdmEnabledODataClient)odataClient).getServiceRoot())) {
            throw new IllegalArgumentException(String.format("The current request URI %s does not match the configured service root %s", request.getURI().toASCIIString(), ((EdmEnabledODataClient)odataClient).getServiceRoot()));
        }
    }

    protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        if (response.getStatusLine().getStatusCode() >= 400) {
            ContentType contentType = AbstractRequest.determineContentType(response, accept);
            try {
                ODataRuntimeException exception = ODataErrorResponseChecker.checkResponse(odataClient, response.getStatusLine(), response.getEntity() == null ? null : response.getEntity().getContent(), contentType);
                if (exception != null) {
                    if (exception instanceof ODataClientErrorException) {
                        ((ODataClientErrorException)exception).setHeaderInfo(response.getAllHeaders());
                    }
                    throw exception;
                }
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Received '" + response.getStatusLine() + "' but could not extract error body", e);
            }
        }
    }

    private static ContentType determineContentType(HttpResponse response, String accept) {
        if (response.getEntity() == null || response.getEntity().getContentType() == null || StringUtils.isBlank(response.getEntity().getContentType().getValue())) {
            return ContentType.fromAcceptHeader(accept);
        }
        try {
            return ContentType.create(response.getEntity().getContentType().getValue());
        }
        catch (Exception exception) {
            return ContentType.JSON;
        }
    }
}

