/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.Collection;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;

public class XmlErrorDocumentProducer {
    public void writeErrorDocument(XMLStreamWriter writer, String errorCode, String message, Locale locale, String innerError) throws XMLStreamException {
        ODataErrorContext context = new ODataErrorContext();
        context.setErrorCode(errorCode);
        context.setMessage(message);
        context.setLocale(locale);
        context.setInnerError(innerError);
        this.writeErrorDocument(writer, context);
    }

    public void writeErrorDocument(XMLStreamWriter writer, ODataErrorContext context) throws XMLStreamException {
        Locale locale = context.getLocale();
        String errorCode = context.getErrorCode();
        String message = context.getMessage();
        String innerError = context.getInnerError();
        Collection errorDetails = context.getErrorDetails();
        writer.writeStartDocument();
        writer.writeStartElement("error");
        writer.writeDefaultNamespace("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        this.writeSimpleElement(writer, "code", errorCode);
        writer.writeStartElement("message");
        if (locale != null) {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", this.getLocale(locale));
        } else {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", "");
        }
        if (message != null) {
            writer.writeCharacters(message);
        }
        writer.writeEndElement();
        if (!errorDetails.isEmpty()) {
            this.writeErrorDetails(writer, errorDetails);
        } else if (innerError != null) {
            this.writeSimpleElement(writer, "innererror", innerError);
        }
        writer.writeEndDocument();
    }

    private void writeErrorDetails(XMLStreamWriter writer, Collection<ODataErrorContext> errorDetails) throws XMLStreamException {
        writer.writeStartElement("innererror");
        writer.writeStartElement("errordetails");
        for (ODataErrorContext detail : errorDetails) {
            writer.writeStartElement("errordetail");
            this.writeSimpleElement(writer, "code", detail.getErrorCode());
            this.writeSimpleElement(writer, "message", detail.getMessage());
            this.writeSimpleElement(writer, "target", detail.getTarget());
            this.writeSimpleElement(writer, "severity", detail.getSeverity());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private String getLocale(Locale locale) {
        if (locale.getCountry().isEmpty()) {
            return locale.getLanguage();
        }
        return locale.getLanguage() + "-" + locale.getCountry();
    }

    private void writeSimpleElement(XMLStreamWriter writer, String elementName, String value) throws XMLStreamException {
        writer.writeStartElement(elementName);
        if (null != value) {
            writer.writeCharacters(value);
        }
        writer.writeEndElement();
    }
}

