/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class StartsWithEvaluator
extends BooleanEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> search;

    public StartsWithEvaluator(Evaluator<String> subject, Evaluator<String> search) {
        this.subject = subject;
        this.search = search;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        String searchString = this.search.evaluate(evaluationContext).getValue();
        return new BooleanQueryResult(searchString == null ? false : subjectValue.startsWith(searchString));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

