/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;

public class FlowSnapshotContainer {
    private final RegisteredFlowSnapshot flowSnapshot;
    private final Map<String, RegisteredFlowSnapshot> childSnapshotsByGroupId;

    public FlowSnapshotContainer(RegisteredFlowSnapshot flowSnapshot) {
        this.flowSnapshot = Objects.requireNonNull(flowSnapshot);
        if (this.flowSnapshot.getParameterContexts() == null) {
            flowSnapshot.setParameterContexts(new HashMap());
        }
        if (this.flowSnapshot.getParameterProviders() == null) {
            flowSnapshot.setParameterProviders(new HashMap());
        }
        this.childSnapshotsByGroupId = new HashMap<String, RegisteredFlowSnapshot>();
    }

    public RegisteredFlowSnapshot getFlowSnapshot() {
        return this.flowSnapshot;
    }

    public RegisteredFlowSnapshot getChildSnapshot(String groupId) {
        return this.childSnapshotsByGroupId.get(groupId);
    }

    public void addChildSnapshot(RegisteredFlowSnapshot childSnapshot, VersionedProcessGroup destinationGroup) {
        this.childSnapshotsByGroupId.put(destinationGroup.getIdentifier(), childSnapshot);
        this.mergeParameterContexts(childSnapshot);
        this.mergeParameterProviders(childSnapshot);
    }

    private void mergeParameterContexts(RegisteredFlowSnapshot childSnapshot) {
        Map childContexts = childSnapshot.getParameterContexts();
        if (childContexts == null) {
            return;
        }
        for (Map.Entry childContextEntry : childContexts.entrySet()) {
            String childContextName = (String)childContextEntry.getKey();
            VersionedParameterContext childContext = (VersionedParameterContext)childContextEntry.getValue();
            VersionedParameterContext matchingContext = (VersionedParameterContext)this.flowSnapshot.getParameterContexts().get(childContextName);
            if (matchingContext == null) {
                this.flowSnapshot.getParameterContexts().put(childContextName, childContext);
                continue;
            }
            if (matchingContext.getParameters() == null) {
                matchingContext.setParameters(new HashSet());
            }
            Set childParameters = childContext.getParameters() == null ? Collections.emptySet() : childContext.getParameters();
            for (VersionedParameter childParameter : childParameters) {
                if (matchingContext.getParameters().contains(childParameter)) continue;
                matchingContext.getParameters().add(childParameter);
            }
        }
    }

    private void mergeParameterProviders(RegisteredFlowSnapshot childSnapshot) {
        Map childParamProviders = childSnapshot.getParameterProviders();
        if (childParamProviders == null) {
            return;
        }
        for (Map.Entry childProviderEntry : childParamProviders.entrySet()) {
            String childProviderId = (String)childProviderEntry.getKey();
            ParameterProviderReference childProvider = (ParameterProviderReference)childProviderEntry.getValue();
            this.flowSnapshot.getParameterProviders().putIfAbsent(childProviderId, childProvider);
        }
    }
}

