/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.metadata.v4.MetadataStaxReader;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

@Named
@Singleton
@Deprecated(since="4.0.0")
public class DefaultVersionRangeResolver
implements VersionRangeResolver {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    private final MetadataResolver metadataResolver;
    private final SyncContextFactory syncContextFactory;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final VersionScheme versionScheme;

    @Inject
    public DefaultVersionRangeResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher, VersionScheme versionScheme) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver, "metadataResolver cannot be null");
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "syncContextFactory cannot be null");
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        this.versionScheme = Objects.requireNonNull(versionScheme, "versionScheme cannot be null");
    }

    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        VersionConstraint versionConstraint;
        VersionRangeResult result = new VersionRangeResult(request);
        try {
            versionConstraint = this.versionScheme.parseVersionConstraint(request.getArtifact().getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            result.addException((Exception)((Object)e));
            throw new VersionRangeResolutionException(result);
        }
        result.setVersionConstraint(versionConstraint);
        if (versionConstraint.getRange() == null) {
            result.addVersion(versionConstraint.getVersion());
        } else {
            VersionRange.Bound lowerBound = versionConstraint.getRange().getLowerBound();
            if (lowerBound != null && lowerBound.equals((Object)versionConstraint.getRange().getUpperBound())) {
                result.addVersion(lowerBound.getVersion());
            } else {
                Map<String, ArtifactRepository> versionIndex = this.getVersions(session, result, request);
                ArrayList<Version> versions = new ArrayList<Version>();
                for (Map.Entry<String, ArtifactRepository> v : versionIndex.entrySet()) {
                    try {
                        Version ver = this.versionScheme.parseVersion(v.getKey());
                        if (!versionConstraint.containsVersion(ver)) continue;
                        versions.add(ver);
                        result.setRepository(ver, v.getValue());
                    }
                    catch (InvalidVersionSpecificationException e) {
                        result.addException((Exception)((Object)e));
                    }
                }
                Collections.sort(versions);
                result.setVersions(versions);
            }
        }
        return result;
    }

    private Map<String, ArtifactRepository> getVersions(RepositorySystemSession session, VersionRangeResult result, VersionRangeRequest request) {
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        HashMap<String, ArtifactRepository> versionIndex = new HashMap<String, ArtifactRepository>();
        DefaultMetadata metadata = new DefaultMetadata(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
        metadataRequests.add(new MetadataRequest((Metadata)metadata, null, request.getRequestContext()));
        for (RemoteRepository repository : request.getRepositories()) {
            MetadataRequest metadataRequest = new MetadataRequest((Metadata)metadata, repository, request.getRequestContext());
            metadataRequest.setDeleteLocalCopyIfMissing(true);
            metadataRequest.setTrace(trace);
            metadataRequests.add(metadataRequest);
        }
        List metadataResults = this.metadataResolver.resolveMetadata(session, metadataRequests);
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace != null) {
            List versions = workspace.findVersions(request.getArtifact());
            for (String version : versions) {
                versionIndex.put(version, (ArtifactRepository)workspace.getRepository());
            }
        }
        for (MetadataResult metadataResult : metadataResults) {
            result.addException(metadataResult.getException());
            RemoteRepository repository = metadataResult.getRequest().getRepository();
            if (repository == null) {
                repository = session.getLocalRepository();
            }
            Versioning versioning = this.readVersions(session, trace, metadataResult.getMetadata(), (ArtifactRepository)repository, result);
            versioning = this.filterVersionsByRepositoryType(versioning, metadataResult.getRequest().getRepository());
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, (ArtifactRepository)repository);
            }
        }
        return versionIndex;
    }

    private Versioning readVersions(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, VersionRangeResult result) {
        Versioning versioning;
        block14: {
            versioning = null;
            try {
                if (metadata == null) break block14;
                try (SyncContext syncContext = this.syncContextFactory.newInstance(session, true);){
                    syncContext.acquire(null, Collections.singleton(metadata));
                    if (metadata.getPath() == null || !Files.exists(metadata.getPath(), new LinkOption[0])) break block14;
                    try (InputStream in = Files.newInputStream(metadata.getPath(), new OpenOption[0]);){
                        versioning = new Versioning(new MetadataStaxReader().read(in, false).getVersioning());
                    }
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
                result.addException(e);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private Versioning filterVersionsByRepositoryType(Versioning versioning, RemoteRepository remoteRepository) {
        if (remoteRepository == null) {
            return versioning;
        }
        Versioning filteredVersions = versioning.clone();
        for (String version : versioning.getVersions()) {
            if (remoteRepository.getPolicy(ArtifactUtils.isSnapshot((String)version)).isEnabled()) continue;
            filteredVersions.removeVersion(version);
        }
        return filteredVersions;
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

