/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.util.List;
import org.mvndaemon.mvnd.common.DaemonState;

public class DaemonInfo {
    public static final int TOKEN_SIZE = 16;
    private final String id;
    private final String javaHome;
    private final String mvndHome;
    private final int pid;
    private final String address;
    private final byte[] token;
    private final String locale;
    private final List<String> options;
    private final DaemonState state;
    private final long lastIdle;
    private final long lastBusy;

    public DaemonInfo(String id, String javaHome, String mavenHome, int pid, String address, byte[] token, String locale, List<String> options, DaemonState state, long lastIdle, long lastBusy) {
        this.id = id;
        this.javaHome = javaHome;
        this.mvndHome = mavenHome;
        this.pid = pid;
        this.address = address;
        this.token = token;
        this.locale = locale;
        this.options = options;
        this.state = state;
        this.lastIdle = lastIdle;
        this.lastBusy = lastBusy;
    }

    public String getId() {
        return this.id;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public String getMvndHome() {
        return this.mvndHome;
    }

    public int getPid() {
        return this.pid;
    }

    public String getAddress() {
        return this.address;
    }

    public byte[] getToken() {
        return this.token;
    }

    public String getLocale() {
        return this.locale;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public DaemonState getState() {
        return this.state;
    }

    public long getLastIdle() {
        return this.lastIdle;
    }

    public long getLastBusy() {
        return this.lastBusy;
    }

    public DaemonInfo withState(DaemonState state) {
        long lb;
        long li;
        if (this.state == DaemonState.Idle && state == DaemonState.Busy) {
            li = this.lastIdle;
            lb = System.currentTimeMillis();
        } else if (this.state == DaemonState.Busy && state == DaemonState.Idle) {
            li = System.currentTimeMillis();
            lb = this.lastBusy;
        } else {
            li = this.lastIdle;
            lb = this.lastBusy;
        }
        return new DaemonInfo(this.id, this.javaHome, this.mvndHome, this.pid, this.address, this.token, this.locale, this.options, state, li, lb);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DaemonInfo{id=").append(this.id);
        this.appendNonKeyFields(sb);
        return sb.append('}').toString();
    }

    public StringBuilder appendNonKeyFields(StringBuilder sb) {
        return sb.append("javaHome=").append(this.javaHome).append(", options=").append(this.options).append(", mavenHome=").append(this.mvndHome).append(", pid=").append(this.pid).append(", address=").append(this.address).append(", locale=").append(this.locale).append(", state=").append((Object)this.state).append(", lastIdle=").append(this.lastIdle).append(", lastBusy=").append(this.lastBusy);
    }
}

